// Generated by delombok at Fri Jan 12 23:31:34 EST 2024
package io.github.qsy7.examples.cli;

import io.github.qsy7.inject.cli.service.CommandLineHandler;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.property.api.enumeration.SystemProxy;
import io.github.qsy7.property.api.property.ProxyHost;
import io.github.qsy7.property.api.property.ProxyPort;
import java.util.Arrays;
import java.util.Optional;
import jakarta.inject.Inject;

public class CLIExampleCommandLineHandler implements CommandLineHandler {
  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(CLIExampleCommandLineHandler.class);
  protected final Optional<String> proxyHost;
  protected final Optional<Integer> proxyPort;

  @Inject
  public CLIExampleCommandLineHandler(
  //      @Property(CommandLineHandlerShutdownTimeout.class) int shutdownTimeoutInSeconds,
  @Property(ProxyHost.class) Optional proxyHost, @Property(ProxyPort.class) Optional proxyPort) {
    //    super(shutdownTimeoutInSeconds);
    this.proxyHost = proxyHost;
    this.proxyPort = proxyPort;
  }

  @Override
  public void run(String... arguments) {
    LOGGER.info("HttpProxy: {}", System.getProperty(SystemProxy.HttpProxy.getClass().getName() + "." + SystemProxy.HttpProxy.name()));
    if (proxyHost.isPresent()) {
      LOGGER.info("proxyHost: {}", proxyHost.get());
    } else {
      LOGGER.info("No proxyHost is specified");
    }
    if (proxyPort.isPresent()) {
      LOGGER.info("proxyPort: {}", proxyPort.get());
    } else {
      LOGGER.info("No proxyPort is specified");
    }
    executeTest();
    LOGGER.info("arguments: {}", Arrays.stream(arguments));
  }

  protected void executeTest() {
    // no, use process builder here
    try {
      //      System.getenv().put("GOPATH", "/usr/local");
      final Process process = Runtime.getRuntime().exec("go get -u" + " github.io.github.qsy7/go-application/commands/secrets/find...");
      process.waitFor();
    } catch (Exception e) {
      LOGGER.warn("Error", e);
      Thread.currentThread().interrupt();
    }
  }
}
