/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.infrastructure.inject.core.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.infrastructure.inject.core.Injector;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.infrastructure.inject.core.service.ServiceManager;
import io.github.qsy7.infrastructure.inject.core.service.StartupAware;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.impl.PropertyHelper;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.util.AnnotationLiteral;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceManager
implements ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceManager.class);
    protected final Reflections reflections;
    protected transient Injector injector;

    @Override
    public void initialize() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "initialize", new Object[0]);
        DefaultServiceManager defaultServiceManager = this;
        defaultServiceManager.injector = ApplicationHelper.getApplicationInstance().getInjector();
        defaultServiceManager.getStartupAwareServices().forEach(service -> this.doStartService((Class<? extends StartupAware>)service));
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "initialize", new Object[0], null, l);
    }

    protected Set<Class<? extends StartupAware>> getStartupAwareServices() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "getStartupAwareServices", new Object[0]);
        Object object = this;
        object = ((DefaultServiceManager)object).reflections.getSubTypesOf(StartupAware.class).stream().filter(serviceClass -> PropertyHelper.isConcrete(serviceClass)).collect(Collectors.toSet());
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "getStartupAwareServices", new Object[0], object, l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStartService(Class<? extends StartupAware> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "doStartService", new Object[]{clazz});
        DefaultServiceManager defaultServiceManager = this;
        Class<? extends StartupAware> clazz2 = clazz;
        try {
            void serviceClass;
            StartupAware startupAware = serviceClass.injector.getInstance(clazz2, new AnnotationLiteral[0]);
            startupAware.startup();
            CloseableUtil.addAutoCloseable(startupAware);
        }
        catch (Exception exception) {
            void e;
            LOGGER.warn(String.format("startup exception - %s", e), exception);
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "doStartService", new Object[]{clazz}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultServiceManager(Reflections reflections) {
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "<init>", new Object[]{reflections});
        DefaultServiceManager defaultServiceManager = this;
        Reflections reflections3 = reflections;
        reflections2.reflections = reflections3;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.service.DefaultServiceManager", "<init>", new Object[]{reflections}, null, l);
    }
}

