/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.inject.cli;

import io.github.qsy7.infrastructure.inject.core.ApplicationInstance;
import io.github.qsy7.infrastructure.inject.core.Injector;
import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.infrastructure.inject.core.service.ServiceManager;
import io.github.qsy7.inject.cli.CLIConfigurationException;
import io.github.qsy7.inject.cli.property.OperatingMode;
import io.github.qsy7.inject.cli.service.CommandLineHandler;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.PropertyManager;
import io.github.qsy7.property.api.SecretService;
import io.github.qsy7.property.impl.PropertyHelper;
import java.util.Iterator;
import java.util.Optional;
import javax.enterprise.util.AnnotationLiteral;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineApplicationInstance
extends ApplicationInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineApplicationInstance.class);
    protected transient Class<? extends CommandLineHandler> commandLineHandlerClass;
    protected final String[] arguments;

    /*
     * WARNING - void declaration
     */
    public CommandLineApplicationInstance(Reflections reflections, PropertyManager propertyManager, ServiceManager serviceManager, SecretService secretService, Injector injector, String[] stringArray) {
        void arguments;
        void injector2;
        void secretService2;
        void serviceManager2;
        void propertyManager2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "<init>", new Object[]{reflections, propertyManager, serviceManager, secretService, injector, stringArray});
        CommandLineApplicationInstance commandLineApplicationInstance = this;
        Reflections reflections3 = reflections;
        PropertyManager propertyManager3 = propertyManager;
        ServiceManager serviceManager3 = serviceManager;
        SecretService secretService3 = secretService;
        Injector injector3 = injector;
        String[] stringArray2 = stringArray;
        super((Reflections)propertyManager2, (PropertyManager)serviceManager2, (ServiceManager)secretService2, (SecretService)injector2, (Injector)arguments);
        reflections2.arguments = stringArray2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "<init>", new Object[]{reflections, propertyManager, serviceManager, secretService, injector, stringArray}, null, l);
    }

    public void run() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "run", new Object[0]);
        CommandLineApplicationInstance commandLineApplicationInstance = this;
        ApplicationHelper.setApplicationInstance(commandLineApplicationInstance);
        try {
            commandLineApplicationInstance.initialize();
            commandLineApplicationInstance.initializeCommandLineHandler();
            commandLineApplicationInstance.runInternal();
        }
        catch (Throwable throwable) {
            LOGGER.error("Error running", throwable);
            System.exit(1);
        }
        System.exit(0);
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "run", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    protected void initializeCommandLineHandler() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "initializeCommandLineHandler", new Object[0]);
        CommandLineApplicationInstance commandLineApplicationInstance = this;
        Optional<Class<? extends CommandLineHandler>> optional = commandLineApplicationInstance.getOperatingModeInitiator();
        if (optional.isPresent()) {
            operatingModeInitiatorClass.commandLineHandlerClass = optional.get();
        } else {
            void operatingModeInitiatorClass;
            Optional<Class<? extends CommandLineHandler>> optional2 = operatingModeInitiatorClass.getCommandLineHandlerClass();
            if (optional2.isPresent()) {
                operatingModeInitiatorClass.commandLineHandlerClass = optional2.get();
            } else {
                throw new CLIConfigurationException("Application is improperly configured, there must be one and only one OperatingMode class in the classpath");
            }
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "initializeCommandLineHandler", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    protected Optional<Class<? extends CommandLineHandler>> getOperatingModeInitiator() {
        Optional<Object> optional;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getOperatingModeInitiator", new Object[0]);
        Object object = this;
        Iterator<Class<OperatingMode>> iterator = ((CommandLineApplicationInstance)object).reflections.getSubTypesOf(OperatingMode.class).iterator();
        if (iterator.hasNext()) {
            void operatingModeIterator;
            Class<OperatingMode> clazz = iterator.next();
            OperatingMode operatingMode = operatingModeIterator.getOperatingMode(clazz);
            optional = Optional.of(operatingMode.getInitiatorClass());
        } else {
            optional = Optional.empty();
        }
        object = optional;
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getOperatingModeInitiator", new Object[0], object, l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected OperatingMode getOperatingMode(Class<? extends OperatingMode> clazz) {
        void operatingModeClass;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getOperatingMode", new Object[]{clazz});
        Object object = this;
        Class<? extends OperatingMode> clazz2 = clazz;
        object = Enum.valueOf(clazz2, operatingModeClass.propertyManager.get(clazz2));
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getOperatingMode", new Object[]{clazz}, object, l);
        return object;
    }

    protected Optional<Class<? extends CommandLineHandler>> getCommandLineHandlerClass() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getCommandLineHandlerClass", new Object[0]);
        Object object = this;
        object = ((CommandLineApplicationInstance)object).reflections.getSubTypesOf(CommandLineHandler.class).stream().filter(c -> PropertyHelper.isConcrete(c)).findFirst();
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getCommandLineHandlerClass", new Object[0], object, l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void runInternal() throws Exception {
        void commandLineHandler;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "runInternal", new Object[0]);
        CommandLineApplicationInstance commandLineApplicationInstance = this;
        CommandLineHandler commandLineHandler2 = commandLineApplicationInstance.getInjector().getInstance(commandLineApplicationInstance.commandLineHandlerClass, new AnnotationLiteral[0]);
        commandLineHandler2.run(commandLineHandler.arguments);
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "runInternal", new Object[0], null, l);
    }

    public String[] getArguments() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getArguments", new Object[0]);
        String[] stringArray = this;
        stringArray = stringArray.arguments;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.inject.cli.CommandLineApplicationInstance", "getArguments", new Object[0], stringArray, l);
        return stringArray;
    }
}

