/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.FieldContextualLoggable;
import io.github.qsy7.logging.annotation.ContextualLoggableField;
import io.github.qsy7.logging.util.ArgumentUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ContextualDataUtil {
    public static String getContextualData(Object target) {
        StringBuilder buffer = new StringBuilder();
        ContextualDataUtil.getContextual(target).entrySet().forEach(entry -> buffer.append((String)entry.getKey()).append("->").append(ArgumentUtil.getArgument(false, entry.getValue())));
        return buffer.toString();
    }

    public static Map<String, Object> getContextual(Object target) {
        HashMap<String, Object> contextualData = new HashMap<String, Object>();
        ContextualDataUtil.getContextual(contextualData, target, target.getClass());
        return contextualData;
    }

    private static void getContextual(Map<String, Object> contextual, Object object, Class targetClass) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ContextualLoggableField.class)) continue;
            try {
                boolean wasAccessible = field.canAccess(object);
                field.setAccessible(true);
                contextual.put(targetClass.getName() + "." + field.getName(), field.get(object));
                if (wasAccessible) continue;
                field.setAccessible(wasAccessible);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (targetClass.getSuperclass() != null && targetClass.getSuperclass().isAssignableFrom(FieldContextualLoggable.class)) {
            ContextualDataUtil.getContextual(contextual, object, targetClass.getSuperclass());
        }
    }

    private ContextualDataUtil() {
    }
}

