/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.ContextualLoggable;
import io.github.qsy7.logging.enumeration.LogLevel;
import java.security.SecureRandom;
import java.util.Base64;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    public static final SecureRandom random = new SecureRandom();
    public static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    public static int idLength = 8;

    public static void onException(ContextualLoggable contextualLoggable, String typeName, String methodName, Object[] arguments, Throwable throwable) {
        ExceptionUtil.onException(typeName, methodName, arguments, throwable);
        LogLevel.ERROR.log(LoggerFactory.getLogger(typeName), "Contextual Details:\n{}", contextualLoggable.printContextualInformation());
    }

    public static void onException(String typeName, String methodName, Object[] arguments, Throwable throwable) {
        LogLevel.ERROR.log(LoggerFactory.getLogger(typeName), "{}({})\n{}", methodName, arguments, ExceptionUtil.getStackTrace(throwable, ExceptionUtil.getExceptionId()));
    }

    public static String getExceptionId() {
        byte[] buffer = new byte[idLength];
        random.nextBytes(buffer);
        return encoder.encodeToString(buffer);
    }

    public static String getStackTrace(Throwable throwable, String exceptionId) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Exception ID: " + exceptionId + "\n");
        buffer.append(throwable.getClass() + "\n");
        if (throwable.getMessage() != null) {
            buffer.append(throwable.getMessage());
            buffer.append("\n");
        }
        if (throwable.getCause() != null) {
            buffer.append(throwable.getCause().getMessage());
            buffer.append("\n");
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            buffer.append("\t" + stackTraceElement.toString() + "\n");
        }
        return buffer.toString();
    }

    private ExceptionUtil() {
    }
}

