/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.api.model;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.enumeration.BatteryState;
import io.github.qsy7.shell.api.model.Node;
import io.github.qsy7.shell.api.model.ShellCommand;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class BatteryStatus
extends AbstractEntity {
    @ManyToOne(optional=false)
    @JoinColumn(nullable=false, updatable=false)
    protected Node node;
    @Column(nullable=false, updatable=false)
    protected LocalDateTime dateTime;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    protected BatteryState batteryState;
    @Column(nullable=false, updatable=false)
    protected int batteryChargePercentage;
    @ManyToOne
    @JoinColumn(updatable=false)
    protected ShellCommand shellCommand;

    public Node getNode() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getNode", new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.node;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getNode", new Object[0], abstractEntity, l);
        return abstractEntity;
    }

    public LocalDateTime getDateTime() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getDateTime", new Object[0]);
        Serializable serializable = this;
        serializable = serializable.dateTime;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getDateTime", new Object[0], serializable, l);
        return serializable;
    }

    public BatteryState getBatteryState() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getBatteryState", new Object[0]);
        Object object = this;
        object = object.batteryState;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getBatteryState", new Object[0], object, l);
        return object;
    }

    public int getBatteryChargePercentage() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getBatteryChargePercentage", new Object[0]);
        BatteryStatus batteryStatus = this;
        int n = batteryStatus.batteryChargePercentage;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getBatteryChargePercentage", new Object[0], n, l);
        return n;
    }

    public ShellCommand getShellCommand() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getShellCommand", new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.shellCommand;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "getShellCommand", new Object[0], abstractEntity, l);
        return abstractEntity;
    }

    public void setNode(Node node) {
        Node node2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setNode", new Object[]{node});
        BatteryStatus batteryStatus = this;
        node.node = node2 = node;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setNode", new Object[]{node}, null, l);
    }

    public void setDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setDateTime", new Object[]{localDateTime});
        BatteryStatus batteryStatus = this;
        dateTime.dateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setDateTime", new Object[]{localDateTime}, null, l);
    }

    public void setBatteryState(BatteryState batteryState) {
        BatteryState batteryState2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setBatteryState", new Object[]{batteryState});
        BatteryStatus batteryStatus = this;
        batteryState.batteryState = batteryState2 = batteryState;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setBatteryState", new Object[]{batteryState}, null, l);
    }

    public void setBatteryChargePercentage(int n) {
        int n2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setBatteryChargePercentage", new Object[]{n});
        BatteryStatus batteryStatus = this;
        batteryChargePercentage.batteryChargePercentage = n2 = n;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setBatteryChargePercentage", new Object[]{n}, null, l);
    }

    public void setShellCommand(ShellCommand shellCommand) {
        ShellCommand shellCommand2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setShellCommand", new Object[]{shellCommand});
        BatteryStatus batteryStatus = this;
        shellCommand.shellCommand = shellCommand2 = shellCommand;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "setShellCommand", new Object[]{shellCommand}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        void o;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "equals", new Object[]{object});
        BatteryStatus batteryStatus = this;
        Object object2 = object;
        if (object2 == o) {
            bl = true;
        } else if (!(object2 instanceof BatteryStatus)) {
            bl = false;
        } else {
            BatteryStatus batteryStatus2 = (BatteryStatus)object2;
            if (!batteryStatus2.canEqual(o)) {
                bl = false;
            } else {
                void other$node;
                void this$node;
                Node node = o.getNode();
                Node node2 = this$node.getNode();
                if (other$node == null ? node2 != null : !other$node.equals(node2)) {
                    bl = false;
                } else {
                    void other$dateTime;
                    LocalDateTime localDateTime = o.getDateTime();
                    LocalDateTime localDateTime2 = this$node.getDateTime();
                    bl = !(other$dateTime == null ? localDateTime2 != null : !other$dateTime.equals(localDateTime2));
                }
            }
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "equals", new Object[]{object}, bl2, l);
        return bl2;
    }

    protected boolean canEqual(Object object) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.shell.api.model.BatteryStatus", "canEqual", new Object[]{object});
        BatteryStatus batteryStatus = this;
        Object object2 = object;
        boolean bl = object2 instanceof BatteryStatus;
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.shell.api.model.BatteryStatus", "canEqual", new Object[]{object}, bl, l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $node;
        void PRIME;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "hashCode", new Object[0]);
        BatteryStatus batteryStatus = this;
        int n = 59;
        boolean bl = true;
        Node node = PRIME.getNode();
        $node = $node * 59 + (node == null ? 43 : ((Object)node).hashCode());
        LocalDateTime localDateTime = PRIME.getDateTime();
        void var3_3 = $node = $node * 59 + (localDateTime == null ? 43 : ((Object)localDateTime).hashCode());
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "hashCode", new Object[0], (int)var3_3, l);
        return (int)var3_3;
    }

    @Override
    public String toString() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "toString", new Object[0]);
        Object object = this;
        object = "BatteryStatus(node=" + ((BatteryStatus)object).node + ", dateTime=" + ((BatteryStatus)object).dateTime + ", batteryState=" + ((BatteryStatus)object).batteryState + ", batteryChargePercentage=" + ((BatteryStatus)object).batteryChargePercentage + ", shellCommand=" + ((BatteryStatus)object).shellCommand + ")";
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "toString", new Object[0], object, l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public BatteryStatus(Node node, LocalDateTime localDateTime, BatteryState batteryState, int n, ShellCommand shellCommand) {
        void shellCommand2;
        void batteryChargePercentage;
        void batteryState2;
        void dateTime;
        void node2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "<init>", new Object[]{node, localDateTime, batteryState, n, shellCommand});
        BatteryStatus batteryStatus = this;
        Node node3 = node;
        LocalDateTime localDateTime2 = localDateTime;
        BatteryState batteryState3 = batteryState;
        int n2 = n;
        ShellCommand shellCommand3 = shellCommand;
        node2.dateTime = LocalDateTime.now();
        node2.node = dateTime;
        node2.dateTime = batteryState2;
        node2.batteryState = batteryChargePercentage;
        node2.batteryChargePercentage = shellCommand2;
        node2.shellCommand = shellCommand3;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "<init>", new Object[]{node, localDateTime, batteryState, n, shellCommand}, null, l);
    }

    public BatteryStatus() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "<init>", new Object[0]);
        BatteryStatus batteryStatus = this;
        batteryStatus.dateTime = LocalDateTime.now();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.BatteryStatus", "<init>", new Object[0], null, l);
    }
}

