/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.api.model;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.datastore.api.model.entity.AbstractUUIDEntity;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.enumeration.MountAction;
import io.github.qsy7.shell.api.model.MountCommandShellCommand;
import io.github.qsy7.shell.api.model.MountPoint;
import io.github.qsy7.shell.api.model.MultipleShellCommandable;
import io.github.qsy7.shell.api.model.ShellCommand;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
public class MountCommand
extends AbstractUUIDEntity
implements MultipleShellCommandable {
    @Column(nullable=false, updatable=false)
    protected String rootPath;
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    @JoinColumn(nullable=false, updatable=false)
    protected MountPoint mountPoint;
    @OneToMany(mappedBy="mountCommand", cascade={CascadeType.ALL})
    protected List<MountCommandShellCommand> shellCommands;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, updatable=false)
    protected MountAction mountAction;
    @Column(nullable=false, updatable=false)
    protected int timeout;

    public MountCommand() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "<init>", new Object[0]);
        MountCommand mountCommand = this;
        mountCommand.shellCommands = new ArrayList<MountCommandShellCommand>();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "<init>", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addShellCommand(ShellCommand shellCommand) {
        void shellCommand2;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "addShellCommand", new Object[]{shellCommand});
        MountCommand mountCommand = this;
        ShellCommand shellCommand3 = shellCommand;
        shellCommand2.shellCommands.add(new MountCommandShellCommand().withShellCommand(shellCommand3).withMountCommand((MountCommand)shellCommand2));
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "addShellCommand", new Object[]{shellCommand}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public MountCommand withMountPoint(MountPoint mountPoint) {
        void mountPoint2;
        MountPoint mountPoint3;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withMountPoint", new Object[]{mountPoint});
        MountCommand mountCommand = this;
        mountPoint2.mountPoint = mountPoint3 = mountPoint;
        mountCommand = mountPoint2;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withMountPoint", new Object[]{mountPoint}, mountCommand, l);
        return mountCommand;
    }

    /*
     * WARNING - void declaration
     */
    public MountCommand withMountAction(MountAction mountAction) {
        void mountAction2;
        MountAction mountAction3;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withMountAction", new Object[]{mountAction});
        MountCommand mountCommand = this;
        mountAction2.mountAction = mountAction3 = mountAction;
        mountCommand = mountAction2;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withMountAction", new Object[]{mountAction}, mountCommand, l);
        return mountCommand;
    }

    /*
     * WARNING - void declaration
     */
    public MountCommand withRootPath(String string) {
        void rootPath;
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withRootPath", new Object[]{string});
        MountCommand mountCommand = this;
        rootPath.rootPath = string2 = string;
        mountCommand = rootPath;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.MountCommand", "withRootPath", new Object[]{string}, mountCommand, l);
        return mountCommand;
    }

    @Override
    public String toString() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "toString", new Object[0]);
        Object object = this;
        object = "MountCommand(rootPath=" + ((MountCommand)object).rootPath + ", mountPoint=" + ((MountCommand)object).mountPoint + ", mountAction=" + ((MountCommand)object).mountAction + ", timeout=" + ((MountCommand)object).timeout + ")";
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "toString", new Object[0], object, l);
        return object;
    }

    public String getRootPath() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getRootPath", new Object[0]);
        Object object = this;
        object = ((MountCommand)object).rootPath;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getRootPath", new Object[0], object, l);
        return object;
    }

    public MountPoint getMountPoint() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getMountPoint", new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.mountPoint;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getMountPoint", new Object[0], abstractEntity, l);
        return abstractEntity;
    }

    public List<MountCommandShellCommand> getShellCommands() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getShellCommands", new Object[0]);
        Object object = this;
        object = ((MountCommand)object).shellCommands;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getShellCommands", new Object[0], object, l);
        return object;
    }

    public MountAction getMountAction() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getMountAction", new Object[0]);
        Object object = this;
        object = object.mountAction;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getMountAction", new Object[0], object, l);
        return object;
    }

    @Override
    public int getTimeout() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getTimeout", new Object[0]);
        MountCommand mountCommand = this;
        int n = mountCommand.timeout;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "getTimeout", new Object[0], n, l);
        return n;
    }

    public void setRootPath(String string) {
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setRootPath", new Object[]{string});
        MountCommand mountCommand = this;
        rootPath.rootPath = string2 = string;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setRootPath", new Object[]{string}, null, l);
    }

    public void setMountPoint(MountPoint mountPoint) {
        MountPoint mountPoint2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setMountPoint", new Object[]{mountPoint});
        MountCommand mountCommand = this;
        mountPoint.mountPoint = mountPoint2 = mountPoint;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setMountPoint", new Object[]{mountPoint}, null, l);
    }

    public void setShellCommands(List<MountCommandShellCommand> list) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setShellCommands", new Object[]{list});
        MountCommand mountCommand = this;
        List<MountCommandShellCommand> list2 = list;
        shellCommands.shellCommands = list2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setShellCommands", new Object[]{list}, null, l);
    }

    public void setMountAction(MountAction mountAction) {
        MountAction mountAction2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setMountAction", new Object[]{mountAction});
        MountCommand mountCommand = this;
        mountAction.mountAction = mountAction2 = mountAction;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setMountAction", new Object[]{mountAction}, null, l);
    }

    @Override
    public void setTimeout(int n) {
        int n2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setTimeout", new Object[]{n});
        MountCommand mountCommand = this;
        timeout.timeout = n2 = n;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.MountCommand", "setTimeout", new Object[]{n}, null, l);
    }
}

