/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.api.model;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.model.CommandError;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.EnvironmentAware;
import io.github.qsy7.shell.api.model.Node;
import io.github.qsy7.shell.api.model.ShellCommandEnvironmentProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity
public class ShellCommand
extends AbstractEntity
implements EnvironmentAware {
    @ManyToOne(optional=false)
    @JoinColumn(nullable=false, updatable=false)
    protected Node node;
    @Lob
    @Column(nullable=false, updatable=false)
    protected String commandLine;
    @Column(updatable=false)
    protected String workingDirectory;
    @Column(nullable=false, updatable=false)
    protected LocalDateTime dateTime;
    @Column(updatable=false)
    protected int timeout;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shellCommand")
    protected Set<ShellCommandEnvironmentProperty> shellCommandEnvironmentProperties;
    @Column
    protected int returnCode;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shellCommand")
    protected List<CommandOutput> outputs;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shellCommand")
    protected List<CommandError> errors;

    /*
     * WARNING - void declaration
     */
    public ShellCommand withTimeout(int n) {
        void timeout;
        int n2;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withTimeout", new Object[]{n});
        ShellCommand shellCommand = this;
        timeout.timeout = n2 = n;
        shellCommand = timeout;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withTimeout", new Object[]{n}, shellCommand, l);
        return shellCommand;
    }

    /*
     * WARNING - void declaration
     */
    public ShellCommand withCommandLine(String string) {
        void commandLine;
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withCommandLine", new Object[]{string});
        ShellCommand shellCommand = this;
        commandLine.commandLine = string2 = string;
        shellCommand = commandLine;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withCommandLine", new Object[]{string}, shellCommand, l);
        return shellCommand;
    }

    /*
     * WARNING - void declaration
     */
    public ShellCommand withWorkingDirectory(String string) {
        void workingDirectory;
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withWorkingDirectory", new Object[]{string});
        ShellCommand shellCommand = this;
        workingDirectory.workingDirectory = string2 = string;
        shellCommand = workingDirectory;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.shell.api.model.ShellCommand", "withWorkingDirectory", new Object[]{string}, shellCommand, l);
        return shellCommand;
    }

    public Node getNode() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getNode", new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.node;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getNode", new Object[0], abstractEntity, l);
        return abstractEntity;
    }

    public String getCommandLine() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getCommandLine", new Object[0]);
        Object object = this;
        object = ((ShellCommand)object).commandLine;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getCommandLine", new Object[0], object, l);
        return object;
    }

    public String getWorkingDirectory() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getWorkingDirectory", new Object[0]);
        Object object = this;
        object = ((ShellCommand)object).workingDirectory;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getWorkingDirectory", new Object[0], object, l);
        return object;
    }

    public LocalDateTime getDateTime() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getDateTime", new Object[0]);
        Serializable serializable = this;
        serializable = serializable.dateTime;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getDateTime", new Object[0], serializable, l);
        return serializable;
    }

    public int getTimeout() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getTimeout", new Object[0]);
        ShellCommand shellCommand = this;
        int n = shellCommand.timeout;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getTimeout", new Object[0], n, l);
        return n;
    }

    @Override
    public Set<ShellCommandEnvironmentProperty> getShellCommandEnvironmentProperties() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getShellCommandEnvironmentProperties", new Object[0]);
        Object object = this;
        object = ((ShellCommand)object).shellCommandEnvironmentProperties;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getShellCommandEnvironmentProperties", new Object[0], object, l);
        return object;
    }

    public int getReturnCode() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getReturnCode", new Object[0]);
        ShellCommand shellCommand = this;
        int n = shellCommand.returnCode;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getReturnCode", new Object[0], n, l);
        return n;
    }

    public List<CommandOutput> getOutputs() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getOutputs", new Object[0]);
        Object object = this;
        object = ((ShellCommand)object).outputs;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getOutputs", new Object[0], object, l);
        return object;
    }

    public List<CommandError> getErrors() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getErrors", new Object[0]);
        Object object = this;
        object = ((ShellCommand)object).errors;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "getErrors", new Object[0], object, l);
        return object;
    }

    public void setNode(Node node) {
        Node node2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setNode", new Object[]{node});
        ShellCommand shellCommand = this;
        node.node = node2 = node;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setNode", new Object[]{node}, null, l);
    }

    public void setCommandLine(String string) {
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setCommandLine", new Object[]{string});
        ShellCommand shellCommand = this;
        commandLine.commandLine = string2 = string;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setCommandLine", new Object[]{string}, null, l);
    }

    public void setWorkingDirectory(String string) {
        String string2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setWorkingDirectory", new Object[]{string});
        ShellCommand shellCommand = this;
        workingDirectory.workingDirectory = string2 = string;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setWorkingDirectory", new Object[]{string}, null, l);
    }

    public void setDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setDateTime", new Object[]{localDateTime});
        ShellCommand shellCommand = this;
        dateTime.dateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setDateTime", new Object[]{localDateTime}, null, l);
    }

    public void setTimeout(int n) {
        int n2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setTimeout", new Object[]{n});
        ShellCommand shellCommand = this;
        timeout.timeout = n2 = n;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setTimeout", new Object[]{n}, null, l);
    }

    @Override
    public void setShellCommandEnvironmentProperties(Set<ShellCommandEnvironmentProperty> set) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setShellCommandEnvironmentProperties", new Object[]{set});
        ShellCommand shellCommand = this;
        Set<ShellCommandEnvironmentProperty> set2 = set;
        shellCommandEnvironmentProperties.shellCommandEnvironmentProperties = set2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setShellCommandEnvironmentProperties", new Object[]{set}, null, l);
    }

    public void setReturnCode(int n) {
        int n2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setReturnCode", new Object[]{n});
        ShellCommand shellCommand = this;
        returnCode.returnCode = n2 = n;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setReturnCode", new Object[]{n}, null, l);
    }

    public void setOutputs(List<CommandOutput> list) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setOutputs", new Object[]{list});
        ShellCommand shellCommand = this;
        List<CommandOutput> list2 = list;
        outputs.outputs = list2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setOutputs", new Object[]{list}, null, l);
    }

    public void setErrors(List<CommandError> list) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setErrors", new Object[]{list});
        ShellCommand shellCommand = this;
        List<CommandError> list2 = list;
        errors.errors = list2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "setErrors", new Object[]{list}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        void o;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "equals", new Object[]{object});
        ShellCommand shellCommand = this;
        Object object2 = object;
        if (object2 == o) {
            bl = true;
        } else if (!(object2 instanceof ShellCommand)) {
            bl = false;
        } else {
            ShellCommand shellCommand2 = (ShellCommand)object2;
            if (!shellCommand2.canEqual(o)) {
                bl = false;
            } else {
                void other$node;
                void this$node;
                Node node = o.getNode();
                Node node2 = this$node.getNode();
                if (other$node == null ? node2 != null : !other$node.equals(node2)) {
                    bl = false;
                } else {
                    void other$commandLine;
                    String string = o.getCommandLine();
                    String string2 = this$node.getCommandLine();
                    if (other$commandLine == null ? string2 != null : !other$commandLine.equals(string2)) {
                        bl = false;
                    } else {
                        void other$workingDirectory;
                        String string3 = o.getWorkingDirectory();
                        String string4 = this$node.getWorkingDirectory();
                        if (other$workingDirectory == null ? string4 != null : !other$workingDirectory.equals(string4)) {
                            bl = false;
                        } else {
                            void other$dateTime;
                            LocalDateTime localDateTime = o.getDateTime();
                            LocalDateTime localDateTime2 = this$node.getDateTime();
                            bl = !(other$dateTime == null ? localDateTime2 != null : !other$dateTime.equals(localDateTime2));
                        }
                    }
                }
            }
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "equals", new Object[]{object}, bl2, l);
        return bl2;
    }

    protected boolean canEqual(Object object) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.shell.api.model.ShellCommand", "canEqual", new Object[]{object});
        ShellCommand shellCommand = this;
        Object object2 = object;
        boolean bl = object2 instanceof ShellCommand;
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.shell.api.model.ShellCommand", "canEqual", new Object[]{object}, bl, l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $node;
        void PRIME;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "hashCode", new Object[0]);
        ShellCommand shellCommand = this;
        int n = 59;
        boolean bl = true;
        Node node = PRIME.getNode();
        $node = $node * 59 + (node == null ? 43 : ((Object)node).hashCode());
        String string = PRIME.getCommandLine();
        $node = $node * 59 + (string == null ? 43 : string.hashCode());
        String string2 = PRIME.getWorkingDirectory();
        $node = $node * 59 + (string2 == null ? 43 : string2.hashCode());
        LocalDateTime localDateTime = PRIME.getDateTime();
        void var3_3 = $node = $node * 59 + (localDateTime == null ? 43 : ((Object)localDateTime).hashCode());
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "hashCode", new Object[0], (int)var3_3, l);
        return (int)var3_3;
    }

    @Override
    public String toString() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "toString", new Object[0]);
        Object object = this;
        object = "ShellCommand(node=" + ((ShellCommand)object).node + ", commandLine=" + ((ShellCommand)object).commandLine + ", workingDirectory=" + ((ShellCommand)object).workingDirectory + ", dateTime=" + ((ShellCommand)object).dateTime + ", timeout=" + ((ShellCommand)object).timeout + ", shellCommandEnvironmentProperties=" + ((ShellCommand)object).shellCommandEnvironmentProperties + ", returnCode=" + ((ShellCommand)object).returnCode + ", outputs=" + ((ShellCommand)object).outputs + ", errors=" + ((ShellCommand)object).errors + ")";
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "toString", new Object[0], object, l);
        return object;
    }

    public ShellCommand() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "<init>", new Object[0]);
        ShellCommand shellCommand = this;
        shellCommand.dateTime = LocalDateTime.now();
        shellCommand.shellCommandEnvironmentProperties = new HashSet<ShellCommandEnvironmentProperty>();
        shellCommand.outputs = new ArrayList<CommandOutput>();
        shellCommand.errors = new ArrayList<CommandError>();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.shell.api.model.ShellCommand", "<init>", new Object[0], null, l);
    }
}

