/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import java.util.Formattable;
import java.util.Formatter;

final class TextDecor
implements Formattable {
    public static final int MAX = 100;
    private final transient Object object;

    TextDecor(Object obj) {
        this.object = obj;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.object == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            formatter.format("%s", TextDecor.pretty(this.object.toString()));
        }
    }

    private static String pretty(String text) {
        String result;
        if (text.length() < 100) {
            result = text;
        } else {
            int skip = text.length() - 100;
            StringBuilder output = new StringBuilder(text.length());
            output.append(text.substring(0, (text.length() - skip) / 2));
            output.append("..").append(Integer.toString(skip)).append("..");
            output.append(text.substring(text.length() - 100 + output.length()));
            result = output.toString();
        }
        return result.replace("\n", "\\n");
    }
}

