/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ArgumentUtil;
import org.slf4j.LoggerFactory;

public class MethodLogUtil {
    public static long onEnter(LogLevel logLevel, String typeName, String methodName, Object[] arguments) {
        logLevel.log(LoggerFactory.getLogger(typeName), "{}({})", methodName, ArgumentUtil.getArguments(false, arguments));
        return System.nanoTime();
    }

    public static void onExit(LogLevel logLevel, String typeName, String methodName, Object[] arguments, Object result, long startTime) {
        logLevel.log(LoggerFactory.getLogger(typeName), "{}({}) => {} in {}ns", methodName, ArgumentUtil.getArguments(false, arguments), ArgumentUtil.getArgument(false, result), System.nanoTime() - startTime);
    }

    private MethodLogUtil() {
    }
}

