/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.property.impl;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.PropertyManager;
import io.github.qsy7.property.impl.PropertyHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyManager<PropertyClassType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertyManager.class);
    protected final Reflections reflections;
    protected final PropertyManager propertyManager;
    protected boolean invoked;

    public void call() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.AbstractPropertyManager", "call", new Object[0]);
        AbstractPropertyManager abstractPropertyManager = this;
        AbstractPropertyManager abstractPropertyManager2 = abstractPropertyManager;
        try {
            if (!abstractPropertyManager2.invoked) {
                try {
                    for (Class<PropertyClassType> propertyClass : abstractPropertyManager2.getClasses()) {
                        if (!PropertyHelper.isConcrete(propertyClass)) continue;
                        try {
                            abstractPropertyManager2.processClass(propertyClass);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            LOGGER.warn(String.format("Error configuring: %s", propertyClass), e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Error configuring", e);
                }
                abstractPropertyManager2.invoked = true;
            }
            abstractPropertyManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractPropertyManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.AbstractPropertyManager", "call", new Object[0], (Throwable)((Object)abstractPropertyManager2));
        }
        if (abstractPropertyManager2 != null) {
            throw abstractPropertyManager2;
        }
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.AbstractPropertyManager", "call", new Object[0], null, l);
    }

    protected abstract Collection<Class<? extends PropertyClassType>> getClasses();

    protected abstract void processClass(Class<? extends PropertyClassType> var1) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException;

    /*
     * WARNING - void declaration
     */
    public AbstractPropertyManager(Reflections reflections, PropertyManager propertyManager) {
        void propertyManager2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.AbstractPropertyManager", "<init>", new Object[]{reflections, propertyManager});
        AbstractPropertyManager abstractPropertyManager = this;
        Reflections reflections3 = reflections;
        PropertyManager propertyManager3 = propertyManager;
        abstractPropertyManager.invoked = false;
        abstractPropertyManager.reflections = reflections2;
        abstractPropertyManager.propertyManager = propertyManager2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.AbstractPropertyManager", "<init>", new Object[]{reflections, propertyManager}, null, l);
    }
}

