/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Properties;
import javax.jdo.metadata.JDOMetadata;
import org.datanucleus.api.jdo.JDOAdapter;
import org.datanucleus.api.jdo.metadata.api.JDOMetadataImpl;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.NucleusLogger;

public class JDOEnhancer
implements javax.jdo.JDOEnhancer {
    DataNucleusEnhancer enhancer;

    public JDOEnhancer() {
        this.enhancer = new DataNucleusEnhancer("JDO", null);
    }

    public JDOEnhancer(Properties props) {
        this.enhancer = new DataNucleusEnhancer("JDO", props);
    }

    @Override
    public JDOMetadata newMetadata() {
        return new JDOMetadataImpl();
    }

    @Override
    public void registerMetadata(JDOMetadata metadata) {
        MetaDataManager mmgr = this.enhancer.getMetaDataManager();
        FileMetaData filemd = ((JDOMetadataImpl)metadata).getInternal();
        mmgr.loadUserMetaData(filemd, this.enhancer.getClassLoader());
    }

    @Override
    public JDOEnhancer addClass(String className, byte[] bytes) {
        this.enhancer.addClass(className, bytes);
        return this;
    }

    @Override
    public JDOEnhancer addClasses(String ... classNames) {
        this.enhancer.addClasses(classNames);
        return this;
    }

    @Override
    public JDOEnhancer addFiles(String ... metadataFiles) {
        this.enhancer.addFiles(metadataFiles);
        return this;
    }

    @Override
    public JDOEnhancer addJar(String jarFileName) {
        this.enhancer.addJar(jarFileName);
        return this;
    }

    @Override
    public JDOEnhancer addPersistenceUnit(String persistenceUnitName) {
        this.enhancer.addPersistenceUnit(persistenceUnitName);
        return this;
    }

    @Override
    public int enhance() {
        try {
            return this.enhancer.enhance();
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public byte[] getEnhancedBytes(String className) {
        try {
            return this.enhancer.getEnhancedBytes(className);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    public byte[] getPkClassBytes(String className) {
        try {
            return this.enhancer.getPkClassBytes(className);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Properties getProperties() {
        return this.enhancer.getProperties();
    }

    @Override
    public JDOEnhancer setClassLoader(ClassLoader loader) {
        this.enhancer.setClassLoader(loader);
        return this;
    }

    @Override
    public JDOEnhancer setOutputDirectory(String dir) {
        this.enhancer.setOutputDirectory(dir);
        return this;
    }

    @Override
    public JDOEnhancer setVerbose(boolean verbose) {
        this.enhancer.setVerbose(verbose);
        return this;
    }

    @Override
    public int validate() {
        try {
            return this.enhancer.validate();
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        NucleusLogger.GENERAL.warn("JDOEnhancer.transform not implemented. Report where this was called from", new Exception());
        return null;
    }
}

