/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.util.ArrayList;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.ComparableExpression;
import javax.jdo.query.OrderExpression;
import javax.jdo.query.PersistableExpression;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionType;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.OrderExpressionImpl;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;

public class ComparableExpressionImpl<T>
extends ExpressionImpl<T>
implements ComparableExpression<T> {
    public ComparableExpressionImpl(PersistableExpression parent, String name) {
        super(parent, name);
    }

    public ComparableExpressionImpl(Expression queryExpr) {
        super(queryExpr);
    }

    public ComparableExpressionImpl(Class<T> cls, String name, ExpressionType type) {
        super(cls, name, type);
    }

    @Override
    public BooleanExpression gt(ComparableExpression<? extends T> expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)((Object)expr)).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_GT, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression gt(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_GT, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression gteq(ComparableExpression<? extends T> expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)((Object)expr)).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_GTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression gteq(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_GTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression lt(ComparableExpression<? extends T> expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)((Object)expr)).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_LT, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression lt(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_LT, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression lteq(ComparableExpression<? extends T> expr) {
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)((Object)expr)).getQueryExpression();
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_LTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public BooleanExpression lteq(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        DyadicExpression queryExpr = new DyadicExpression(leftQueryExpr, Expression.OP_LTEQ, rightQueryExpr);
        return new BooleanExpressionImpl(queryExpr);
    }

    @Override
    public ComparableExpression<T> max() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.queryExpr);
        InvokeExpression invokeExpr = new InvokeExpression(null, "max", args);
        return new NumericExpressionImpl(invokeExpr);
    }

    @Override
    public ComparableExpression<T> min() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.queryExpr);
        InvokeExpression invokeExpr = new InvokeExpression(null, "min", args);
        return new NumericExpressionImpl(invokeExpr);
    }

    @Override
    public OrderExpression<T> asc() {
        return new OrderExpressionImpl(this, OrderExpression.OrderDirection.ASC);
    }

    @Override
    public OrderExpression<T> desc() {
        return new OrderExpressionImpl(this, OrderExpression.OrderDirection.DESC);
    }
}

