/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.util.ArrayList;
import javax.jdo.JDOException;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.NumericExpression;
import javax.jdo.query.PersistableExpression;
import org.datanucleus.ClassLoaderResolverImpl;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionType;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.PersistableExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.expression.VariableExpression;
import org.datanucleus.util.ClassUtils;

public class ExpressionImpl<T>
implements javax.jdo.query.Expression<T> {
    protected Expression queryExpr;
    protected ExpressionType exprType = ExpressionType.PATH;

    public ExpressionImpl(PersistableExpression parent, String name) {
        ArrayList<String> tuples = new ArrayList<String>();
        if (parent != null) {
            Expression parentQueryExpr = ((ExpressionImpl)((Object)parent)).getQueryExpression();
            if (name == null && parentQueryExpr instanceof DyadicExpression && ((DyadicExpression)parentQueryExpr).getOperator() == Expression.OP_CAST) {
                this.queryExpr = parentQueryExpr;
            } else if (parentQueryExpr instanceof PrimaryExpression) {
                tuples.addAll(((PrimaryExpression)parentQueryExpr).getTuples());
                tuples.add(name);
                this.queryExpr = new PrimaryExpression(parentQueryExpr.getLeft(), tuples);
            } else {
                tuples.add(name);
                this.queryExpr = new PrimaryExpression(parentQueryExpr, tuples);
            }
        } else {
            tuples.add(name);
            this.queryExpr = new PrimaryExpression(tuples);
        }
    }

    public ExpressionImpl(Class cls, String name, ExpressionType type) {
        if (type != ExpressionType.PARAMETER && type != ExpressionType.VARIABLE) {
            throw new JDOException("Should not have called this constructor of ExpressionImpl!");
        }
        this.exprType = type;
        if (this.exprType == ExpressionType.PARAMETER) {
            this.queryExpr = new ParameterExpression(name, cls);
        } else if (this.exprType == ExpressionType.VARIABLE) {
            this.queryExpr = new VariableExpression(name, cls);
        }
    }

    public ExpressionImpl(Expression queryExpr) {
        this.queryExpr = queryExpr;
    }

    @Override
    public javax.jdo.query.Expression<T> as(String alias) {
        this.queryExpr.setAlias(alias);
        return this;
    }

    public Expression getQueryExpression() {
        return this.queryExpr;
    }

    public boolean isParameter() {
        return this.exprType == ExpressionType.PARAMETER;
    }

    public boolean isVariable() {
        return this.exprType == ExpressionType.VARIABLE;
    }

    @Override
    public BooleanExpression eq(javax.jdo.query.Expression expr) {
        if (expr == null) {
            return this.eq((T)null);
        }
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)expr).getQueryExpression();
        return new BooleanExpressionImpl(new DyadicExpression(leftQueryExpr, Expression.OP_EQ, rightQueryExpr));
    }

    @Override
    public BooleanExpression eq(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        return new BooleanExpressionImpl(new DyadicExpression(leftQueryExpr, Expression.OP_EQ, rightQueryExpr));
    }

    @Override
    public BooleanExpression ne(javax.jdo.query.Expression expr) {
        if (expr == null) {
            return this.ne((T)null);
        }
        Expression leftQueryExpr = this.queryExpr;
        Expression rightQueryExpr = ((ExpressionImpl)expr).getQueryExpression();
        return new BooleanExpressionImpl(new DyadicExpression(leftQueryExpr, Expression.OP_NOTEQ, rightQueryExpr));
    }

    @Override
    public BooleanExpression ne(T t) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(t);
        return new BooleanExpressionImpl(new DyadicExpression(leftQueryExpr, Expression.OP_NOTEQ, rightQueryExpr));
    }

    @Override
    public BooleanExpression instanceOf(Class cls) {
        Expression leftQueryExpr = this.queryExpr;
        Literal rightQueryExpr = new Literal(cls);
        return new BooleanExpressionImpl(new DyadicExpression(leftQueryExpr, Expression.OP_IS, rightQueryExpr));
    }

    @Override
    public javax.jdo.query.Expression cast(Class cls) {
        if (this instanceof PersistableExpressionImpl) {
            PersistableExpressionImpl castExpr = new PersistableExpressionImpl(new DyadicExpression(this.queryExpr, Expression.OP_CAST, new Literal(cls.getName())));
            Class[] ctrArgTypes = new Class[]{PersistableExpression.class, String.class, Integer.TYPE};
            Object[] ctrArgs = new Object[]{castExpr, null, 0};
            String implClsName = ClassUtils.getPackageNameForClass(cls) + ".Q" + cls.getSimpleName();
            ClassLoaderResolverImpl clr = new ClassLoaderResolverImpl(cls.getClassLoader());
            try {
                Class implCls = clr.classForName(implClsName);
                return (javax.jdo.query.Expression)ClassUtils.newInstance(implCls, ctrArgTypes, ctrArgs);
            }
            catch (Throwable thr) {
                throw new UnsupportedOperationException("Unable to cast to " + cls.getName() + " since this does not have an equivalent Q class present");
            }
        }
        if (this instanceof DateExpressionImpl) {
            return new DateExpressionImpl(new DyadicExpression(this.queryExpr, Expression.OP_CAST, new Literal(cls.getName())));
        }
        if (this instanceof TimeExpressionImpl) {
            return new TimeExpressionImpl(new DyadicExpression(this.queryExpr, Expression.OP_CAST, new Literal(cls.getName())));
        }
        if (this instanceof DateTimeExpressionImpl) {
            return new DateTimeExpressionImpl(new DyadicExpression(this.queryExpr, Expression.OP_CAST, new Literal(cls.getName())));
        }
        throw new UnsupportedOperationException("cast not yet supported for expression of type " + this.getClass().getName());
    }

    @Override
    public NumericExpression<Long> count() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.queryExpr);
        InvokeExpression invokeExpr = new InvokeExpression(null, "count", args);
        return new NumericExpressionImpl<Long>(invokeExpr);
    }

    @Override
    public NumericExpression<Long> countDistinct() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(new DyadicExpression(Expression.OP_DISTINCT, this.queryExpr));
        InvokeExpression invokeExpr = new InvokeExpression(null, "count", args);
        return new NumericExpressionImpl<Long>(invokeExpr);
    }
}

