/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import javax.jdo.JDOUserException;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;

class PersistentNontransactionalDirty
extends LifeCycleState {
    protected PersistentNontransactionalDirty() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 10;
    }

    @Override
    public LifeCycleState transitionMakeTransactional(DNStateManager sm, boolean refreshFields) {
        return this;
    }

    @Override
    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 10);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionEvict(DNStateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionReadField(DNStateManager sm, boolean isLoaded) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new JDOUserException(Localiser.msg("027002"), sm.getInternalObjectId());
        }
        return this;
    }

    @Override
    public LifeCycleState transitionBegin(DNStateManager sm, Transaction tx) {
        sm.saveFields();
        sm.enlistInTransaction();
        return this;
    }

    @Override
    public LifeCycleState transitionWriteField(DNStateManager sm) {
        return this;
    }

    @Override
    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    @Override
    public String toString() {
        return "P_NONTRANS_DIRTY";
    }
}

