/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.DyadicExpression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;

public abstract class MathFunction
implements InvocationEvaluator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        void var6_17;
        String method = expr.getOperation();
        Object paramValue = this.getParamValueForParam(expr.getArguments().get(0), eval, method);
        Object var6_6 = null;
        if (expr.getArguments().size() == 1) {
            if (paramValue instanceof Double) {
                Double d = this.evaluateMathFunction((Double)paramValue);
                return var6_17;
            } else if (paramValue instanceof Float) {
                Float f = Float.valueOf((float)this.evaluateMathFunction(((Float)paramValue).floatValue()));
                return var6_17;
            } else if (paramValue instanceof BigDecimal) {
                BigDecimal bigDecimal = new BigDecimal(this.evaluateMathFunction(((BigDecimal)paramValue).doubleValue()));
                return var6_17;
            } else if (paramValue instanceof Integer) {
                Double d = this.evaluateMathFunction(((Integer)paramValue).doubleValue());
                return var6_17;
            } else {
                if (!(paramValue instanceof Long)) throw new NucleusException("Not possible to use " + this.getFunctionName() + " on value of type " + paramValue.getClass().getName());
                Double d = this.evaluateMathFunction(((Long)paramValue).doubleValue());
            }
            return var6_17;
        } else {
            Object paramValue2;
            if (expr.getArguments().size() != 2) return var6_17;
            Object object = paramValue2 = expr.getArguments().size() == 2 ? this.getParamValueForParam(expr.getArguments().get(1), eval, method) : null;
            if (paramValue instanceof Double) {
                Double d = this.evaluateMathFunction((Double)paramValue, (Double)paramValue2);
                return var6_17;
            } else if (paramValue instanceof Float) {
                Float f = Float.valueOf((float)this.evaluateMathFunction(((Float)paramValue).floatValue(), ((Float)paramValue2).floatValue()));
                return var6_17;
            } else if (paramValue instanceof BigDecimal) {
                BigDecimal bigDecimal = new BigDecimal(this.evaluateMathFunction(((BigDecimal)paramValue).doubleValue(), ((BigDecimal)paramValue2).doubleValue()));
                return var6_17;
            } else if (paramValue instanceof Integer) {
                Double d = this.evaluateMathFunction(((Integer)paramValue).doubleValue(), ((Integer)paramValue2).doubleValue());
                return var6_17;
            } else {
                if (!(paramValue instanceof Long)) throw new NucleusException("Not possible to use " + this.getFunctionName() + " on value of type " + paramValue.getClass().getName());
                Double d = this.evaluateMathFunction(((Long)paramValue).doubleValue(), ((Long)paramValue2).doubleValue());
            }
        }
        return var6_17;
    }

    protected abstract String getFunctionName();

    protected abstract double evaluateMathFunction(double var1);

    protected double evaluateMathFunction(double num1, double num2) {
        throw new NucleusUserException("evaluate method with multiple arguments not implemented");
    }

    protected Object getParamValueForParam(Object param, InMemoryExpressionEvaluator eval, String method) {
        Object paramValue = null;
        if (param instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)param;
            paramValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (param instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)param;
            paramValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (param instanceof InvokeExpression) {
            InvokeExpression invokeExpr = (InvokeExpression)param;
            paramValue = eval.getValueForInvokeExpression(invokeExpr);
        } else if (param instanceof Literal) {
            paramValue = ((Literal)param).getLiteral();
        } else if (param instanceof DyadicExpression) {
            DyadicExpression dyExpr = (DyadicExpression)param;
            paramValue = dyExpr.evaluate(eval);
        } else {
            throw new NucleusException(method + " parameter which is instanceof " + param.getClass().getName() + " not supported");
        }
        return paramValue;
    }
}

