/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.enumeration;

import io.github.qsy7.logging.util.ArgumentUtil;
import io.github.qsy7.logging.util.ObjectFormatUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public enum ArgumentType {
    CollectionArgument(Collection.class){

        @Override
        public String doFormat(boolean isSensitive, Object input, int argumentLength) {
            String[] out = new String[argumentLength];
            Iterator iterator = ((Collection)input).iterator();
            for (int i = 0; i < argumentLength; ++i) {
                out[i] = ObjectFormatUtil.format(iterator.next(), isSensitive);
            }
            return ObjectFormatUtil.format(argumentLength, ((Collection)input).size(), out);
        }

        @Override
        protected int length(Object input) {
            return ((Collection)input).size();
        }
    }
    ,
    MapArgument(Map.class){

        @Override
        protected int length(Object input) {
            return ((Map)input).size();
        }

        @Override
        public String doFormat(boolean isSensitive, Object input, int argumentLength) {
            String[] out = new String[argumentLength];
            Iterator iterator = ((Map)input).entrySet().iterator();
            for (int i = 0; i < argumentLength; ++i) {
                out[i] = ObjectFormatUtil.format(iterator.next(), isSensitive);
            }
            return ObjectFormatUtil.format(argumentLength, ((Map)input).size(), out);
        }
    }
    ,
    ObjectArrayArgument(Object[].class){

        @Override
        protected int length(Object input) {
            return ((Object[])input).length;
        }

        @Override
        public String doFormat(boolean isSensitive, Object input, int argumentLength) {
            Object[] inputArray = (Object[])input;
            String[] out = new String[argumentLength];
            for (int i = 0; i < argumentLength && i < inputArray.length; ++i) {
                out[i] = ObjectFormatUtil.format(inputArray[i], isSensitive);
            }
            return ObjectFormatUtil.format(argumentLength, inputArray.length, out);
        }
    }
    ,
    ObjectArgument(Object.class){

        @Override
        protected int length(Object input) {
            return 1;
        }

        @Override
        public String doFormat(boolean isSensitive, Object input, int argumentLength) {
            return ObjectFormatUtil.format(input, isSensitive);
        }
    };

    private final Class argumentType;

    private ArgumentType(Class argumentType) {
        this.argumentType = argumentType;
    }

    public boolean supports(Class argumentClass) {
        return this.argumentType.isAssignableFrom(argumentClass);
    }

    public String format(boolean isSensitive, Object input, int numberOfArguments) {
        int inputLength = this.length(input);
        int argumentLength = ArgumentUtil.length(numberOfArguments, inputLength);
        return this.doFormat(isSensitive, input, argumentLength);
    }

    protected abstract String doFormat(boolean var1, Object var2, int var3);

    protected abstract int length(Object var1);
}

