/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.util.SensitiveUtil;
import java.util.Arrays;

public class ObjectFormatUtil {
    public static String[] AVOID_TO_STRING_CLASSES = new String[]{"javax.persistence.EntityManager", "org.hibernate.internal.SessionImpl"};

    public static String format(Object element, boolean isSensitive) {
        if (element == null) {
            return "null";
        }
        if (Arrays.binarySearch(AVOID_TO_STRING_CLASSES, element.getClass().getName()) == -1) {
            return SensitiveUtil.format(element.toString(), isSensitive);
        }
        return String.valueOf(element.getClass()) + "@" + element.hashCode();
    }

    public static String format(int argumentLength, int inputLength, String[] elements) {
        return ObjectFormatUtil.getPrefix(argumentLength, inputLength) + "[" + String.join((CharSequence)", ", elements) + "]";
    }

    private static String getPrefix(int argumentLength, int inputLength) {
        if (argumentLength < inputLength) {
            return "first " + argumentLength + " of " + inputLength + " ";
        }
        return "";
    }

    private ObjectFormatUtil() {
    }
}

