/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.annotations;

import java.util.Map;
import javax.jdo.annotations.Column;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.metadata.JDOAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.SoftDeleteMetaData;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.util.StringUtils;

public class SoftDeleteHandler
implements ClassAnnotationHandler {
    @Override
    public void processClassAnnotation(AnnotationObject annotation, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        SoftDeleteMetaData sdmd = cmd.newSoftDeleteMetaData();
        Map<String, Object> annotationValues = annotation.getNameValueMap();
        String columnName = (String)annotationValues.get("column");
        Column[] columns = (Column[])annotationValues.get("columns");
        if (columns != null && columns.length > 0) {
            ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
            if (StringUtils.isWhitespace(colmd.getName())) {
                colmd.setName(columnName);
            }
            sdmd.setColumnMetaData(colmd);
        } else {
            sdmd.setColumnName(columnName);
        }
        String indexed = (String)annotationValues.get("indexed");
        if (!StringUtils.isWhitespace(indexed)) {
            sdmd.setIndexed(Boolean.parseBoolean(indexed));
        }
    }
}

