/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import javax.jdo.AttributeConverter;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.jdo.DataNucleusHelperJDO;
import org.datanucleus.api.jdo.JDOTypeConverter;
import org.datanucleus.api.jdo.JDOTypeConverterUtils;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DatastoreIdentityMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataFileType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.MultitenancyMetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.xml.AbstractXmlMetaDataHandler;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JDOXmlMetaDataHandler
extends AbstractXmlMetaDataHandler {
    public JDOXmlMetaDataHandler(MetaDataManager mgr, String filename, EntityResolver resolver) {
        super(mgr, filename, resolver);
        this.metadata = new FileMetaData(filename);
        this.pushStack(this.metadata);
    }

    protected ClassMetaData newClassObject(PackageMetaData pmd, Attributes attrs) {
        String serializeReadAttr;
        String name = this.getAttr(attrs, "name");
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidClassMetaDataException("044061", new Object[]{pmd.getName()});
        }
        ClassMetaData cmd = new ClassMetaData(pmd, name);
        cmd.setTable(this.getAttr(attrs, "table"));
        cmd.setCatalog(this.getAttr(attrs, "catalog"));
        cmd.setSchema(this.getAttr(attrs, "schema"));
        cmd.setRequiresExtent(this.getAttr(attrs, "requires-extent"));
        String detachableStr = this.getAttr(attrs, "detachable");
        if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty(PropertyNames.PROPERTY_METADATA_ALWAYS_DETACHABLE)) {
            cmd.setDetachable(true);
        } else {
            cmd.setDetachable(detachableStr);
        }
        String objIdCls = this.getAttr(attrs, "objectid-class");
        if (!StringUtils.isWhitespace(objIdCls)) {
            cmd.setObjectIdClass(DataNucleusHelperJDO.getObjectIdClassForInputIdClass(objIdCls));
        }
        cmd.setEmbeddedOnly(this.getAttr(attrs, "embedded-only"));
        cmd.setPersistenceModifier(ClassPersistenceModifier.getClassPersistenceModifier(this.getAttr(attrs, "persistence-modifier")));
        cmd.setIdentityType(IdentityType.getIdentityType(this.getAttr(attrs, "identity-type")));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            cmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        if ((serializeReadAttr = this.getAttr(attrs, "serialize-read")) != null) {
            cmd.setSerializeRead(serializeReadAttr.equalsIgnoreCase("true"));
        }
        String converterAttr = this.getAttr(attrs, "converter");
        String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
        if (disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr) || !StringUtils.isWhitespace(converterAttr)) {
            // empty if block
        }
        return cmd;
    }

    protected InterfaceMetaData newInterfaceObject(PackageMetaData pmd, Attributes attrs) {
        String name = this.getAttr(attrs, "name");
        if (StringUtils.isWhitespace(name)) {
            throw new InvalidClassMetaDataException("044061", new Object[]{pmd.getName()});
        }
        InterfaceMetaData imd = new InterfaceMetaData(pmd, name);
        imd.setTable(this.getAttr(attrs, "table"));
        imd.setCatalog(this.getAttr(attrs, "catalog"));
        imd.setSchema(this.getAttr(attrs, "schema"));
        String detachableStr = this.getAttr(attrs, "detachable");
        if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty(PropertyNames.PROPERTY_METADATA_ALWAYS_DETACHABLE)) {
            imd.setDetachable(true);
        } else {
            imd.setDetachable(detachableStr);
        }
        imd.setRequiresExtent(this.getAttr(attrs, "requires-extent"));
        String objIdCls = this.getAttr(attrs, "objectid-class");
        if (!StringUtils.isWhitespace(objIdCls)) {
            imd.setObjectIdClass(DataNucleusHelperJDO.getObjectIdClassForInputIdClass(objIdCls));
        }
        imd.setEmbeddedOnly(this.getAttr(attrs, "embedded-only"));
        imd.setIdentityType(IdentityType.getIdentityType(this.getAttr(attrs, "identity-type")));
        imd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            imd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        String converterAttr = this.getAttr(attrs, "converter");
        String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
        if (disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr) || !StringUtils.isWhitespace(converterAttr)) {
            // empty if block
        }
        return imd;
    }

    protected FieldMetaData newFieldObject(MetaData md, Attributes attrs) {
        String depStr;
        String serStr;
        String embStr;
        String dfgStr;
        FieldMetaData fmd = new FieldMetaData(md, this.getAttr(attrs, "name"));
        String modStr = this.getAttr(attrs, "persistence-modifier");
        FieldPersistenceModifier modifier = FieldPersistenceModifier.getFieldPersistenceModifier(modStr);
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        fmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
        String pkStr = this.getAttr(attrs, "primary-key");
        if (!StringUtils.isWhitespace(pkStr)) {
            fmd.setPrimaryKey(Boolean.valueOf(pkStr));
        }
        if (!StringUtils.isWhitespace(dfgStr = this.getAttr(attrs, "default-fetch-group"))) {
            fmd.setDefaultFetchGroup(Boolean.valueOf(dfgStr));
        }
        if (!StringUtils.isWhitespace(embStr = this.getAttr(attrs, "embedded"))) {
            fmd.setEmbedded(Boolean.valueOf(embStr));
        }
        if (!StringUtils.isWhitespace(serStr = this.getAttr(attrs, "serialized"))) {
            fmd.setSerialised(Boolean.valueOf(serStr));
        }
        if (!StringUtils.isWhitespace(depStr = this.getAttr(attrs, "dependent"))) {
            fmd.setDependent(Boolean.valueOf(depStr));
        }
        fmd.setNullValue(NullValue.getNullValue(this.getAttr(attrs, "null-value")));
        fmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
        fmd.setColumn(this.getAttr(attrs, "column"));
        fmd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
        fmd.setUnique(this.getAttr(attrs, "unique"));
        fmd.setTable(this.getAttr(attrs, "table"));
        fmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
        fmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
        fmd.setValueStrategy(this.getAttr(attrs, "value-strategy"));
        fmd.setSequence(this.getAttr(attrs, "sequence"));
        fmd.setFieldTypes(this.getAttr(attrs, "field-type"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            fmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        String converterAttr = this.getAttr(attrs, "converter");
        String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
        if (disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr)) {
            fmd.setTypeConverterDisabled();
        } else if (!StringUtils.isWhitespace(converterAttr)) {
            Class converterCls;
            TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
            if (typeMgr.getTypeConverterForName((converterCls = this.clr.classForName(converterAttr)).getName()) == null) {
                AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, null);
                Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                JDOTypeConverter typeConv = new JDOTypeConverter(conv);
                typeMgr.registerConverter(converterAttr, typeConv, attrType, dbType, false, null);
            }
            fmd.setTypeConverterName(converterAttr);
        }
        return fmd;
    }

    protected PropertyMetaData newPropertyObject(MetaData md, Attributes attrs) {
        String depStr;
        String serStr;
        String embStr;
        String dfgStr;
        PropertyMetaData pmd = new PropertyMetaData(md, this.getAttr(attrs, "name"));
        String modStr = this.getAttr(attrs, "persistence-modifier");
        FieldPersistenceModifier modifier = FieldPersistenceModifier.getFieldPersistenceModifier(modStr);
        if (modifier != null) {
            pmd.setPersistenceModifier(modifier);
        }
        pmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
        String pkStr = this.getAttr(attrs, "primary-key");
        if (!StringUtils.isWhitespace(pkStr)) {
            pmd.setPrimaryKey(Boolean.valueOf(pkStr));
        }
        if (!StringUtils.isWhitespace(dfgStr = this.getAttr(attrs, "default-fetch-group"))) {
            pmd.setDefaultFetchGroup(Boolean.valueOf(dfgStr));
        }
        if (!StringUtils.isWhitespace(embStr = this.getAttr(attrs, "embedded"))) {
            pmd.setEmbedded(Boolean.valueOf(embStr));
        }
        if (!StringUtils.isWhitespace(serStr = this.getAttr(attrs, "serialized"))) {
            pmd.setSerialised(Boolean.valueOf(serStr));
        }
        if (!StringUtils.isWhitespace(depStr = this.getAttr(attrs, "dependent"))) {
            pmd.setDependent(Boolean.valueOf(depStr));
        }
        pmd.setNullValue(NullValue.getNullValue(this.getAttr(attrs, "null-value")));
        pmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
        pmd.setColumn(this.getAttr(attrs, "column"));
        pmd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
        pmd.setUnique(this.getAttr(attrs, "unique"));
        pmd.setTable(this.getAttr(attrs, "table"));
        pmd.setLoadFetchGroup(this.getAttr(attrs, "load-fetch-group"));
        pmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
        pmd.setValueStrategy(this.getAttr(attrs, "value-strategy"));
        pmd.setSequence(this.getAttr(attrs, "sequence"));
        pmd.setFieldTypes(this.getAttr(attrs, "field-type"));
        pmd.setFieldName(this.getAttr(attrs, "field-name"));
        String cacheableAttr = this.getAttr(attrs, "cacheable");
        if (cacheableAttr != null) {
            pmd.setCacheable(!cacheableAttr.equalsIgnoreCase("false"));
        }
        String converterAttr = this.getAttr(attrs, "converter");
        String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
        if (disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr)) {
            pmd.setTypeConverterDisabled();
        } else if (!StringUtils.isWhitespace(converterAttr)) {
            Class converterCls;
            TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
            if (typeMgr.getTypeConverterForName((converterCls = this.clr.classForName(converterAttr)).getName()) == null) {
                AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, null);
                Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                JDOTypeConverter typeConv = new JDOTypeConverter(conv);
                typeMgr.registerConverter(converterAttr, typeConv, attrType, dbType, false, null);
            }
            pmd.setTypeConverterName(converterAttr);
        }
        return pmd;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        block184: {
            if (this.charactersBuffer.length() > 0) {
                String currentString = this.getString().trim();
                if (this.getStack() instanceof QueryMetaData) {
                    ((QueryMetaData)this.getStack()).setQuery(currentString.trim());
                }
            }
            if (localName.length() < 1) {
                localName = qName;
            }
            try {
                AbstractMemberMetaData fmd;
                MetaData parent;
                MetaData md;
                PackageMetaData pmd;
                FileMetaData filemd;
                if (localName.equals("jdo")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetaDataFileType.JDO_FILE);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block184;
                }
                if (localName.equals("orm")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetaDataFileType.JDO_ORM_FILE);
                    filemd.setCatalog(this.getAttr(attrs, "catalog"));
                    filemd.setSchema(this.getAttr(attrs, "schema"));
                    break block184;
                }
                if (localName.equals("jdoquery")) {
                    filemd = (FileMetaData)this.getStack();
                    filemd.setType(MetaDataFileType.JDO_QUERY_FILE);
                    break block184;
                }
                if (localName.equals("fetch-plan")) {
                    filemd = (FileMetaData)this.metadata;
                    FetchPlanMetaData fpmd = filemd.newFetchPlanMetaData(this.getAttr(attrs, "name"));
                    fpmd.setMaxFetchDepth(this.getAttr(attrs, "max-fetch-depth"));
                    fpmd.setFetchSize(this.getAttr(attrs, "fetch-size"));
                    this.pushStack(fpmd);
                    break block184;
                }
                if (localName.equals("package")) {
                    filemd = (FileMetaData)this.getStack();
                    PackageMetaData pmd2 = filemd.newPackageMetaData(this.getAttr(attrs, "name"));
                    pmd2.setCatalog(this.getAttr(attrs, "catalog"));
                    pmd2.setSchema(this.getAttr(attrs, "schema"));
                    this.pushStack(pmd2);
                    break block184;
                }
                if (localName.equals("class")) {
                    pmd = (PackageMetaData)this.getStack();
                    ClassMetaData cmd = this.newClassObject(pmd, attrs);
                    pmd.addClass(cmd);
                    this.pushStack(cmd);
                    break block184;
                }
                if (localName.equals("interface")) {
                    pmd = (PackageMetaData)this.getStack();
                    InterfaceMetaData imd = this.newInterfaceObject(pmd, attrs);
                    pmd.addInterface(imd);
                    this.pushStack(imd);
                    break block184;
                }
                if (localName.equals("primary-key")) {
                    md = this.getStack();
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                    pkmd.setName(this.getAttr(attrs, "name"));
                    pkmd.setColumnName(this.getAttr(attrs, "column"));
                    if (md instanceof AbstractClassMetaData) {
                        ((AbstractClassMetaData)md).setPrimaryKeyMetaData(pkmd);
                    } else if (md instanceof JoinMetaData) {
                        ((JoinMetaData)md).setPrimaryKeyMetaData(pkmd);
                    }
                    this.pushStack(pkmd);
                    break block184;
                }
                if (localName.equals("implements")) {
                    ClassMetaData cmd = (ClassMetaData)this.getStack();
                    ImplementsMetaData imd = new ImplementsMetaData(this.getAttr(attrs, "name"));
                    cmd.addImplements(imd);
                    this.pushStack(imd);
                    break block184;
                }
                if (localName.equals("property")) {
                    parent = this.getStack();
                    if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(acmd, attrs);
                        acmd.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd = (EmbeddedMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(emd, attrs);
                        emd.addMember(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof ImplementsMetaData) {
                        ImplementsMetaData implmd = (ImplementsMetaData)parent;
                        PropertyMetaData propmd = this.newPropertyObject(implmd, attrs);
                        implmd.addProperty(propmd);
                        this.pushStack(propmd);
                    } else if (parent instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)parent;
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData(fgmd, this.getAttr(attrs, "name"));
                        fgmmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
                        fgmmd.setProperty();
                        fgmd.addMember(fgmmd);
                        this.pushStack(fgmmd);
                    }
                    break block184;
                }
                if (localName.equals("datastore-identity")) {
                    AbstractClassMetaData acmd = (AbstractClassMetaData)this.getStack();
                    DatastoreIdentityMetaData idmd = acmd.newDatastoreIdentityMetaData();
                    idmd.setColumnName(this.getAttr(attrs, "column"));
                    idmd.setValueStrategy(ValueGenerationStrategy.getIdentityStrategy(this.getAttr(attrs, "strategy")));
                    idmd.setSequence(this.getAttr(attrs, "sequence"));
                    this.pushStack(idmd);
                    break block184;
                }
                if (localName.equals("inheritance")) {
                    parent = this.getStack();
                    AbstractClassMetaData acmd = (AbstractClassMetaData)parent;
                    InheritanceMetaData inhmd = acmd.newInheritanceMetaData();
                    inhmd.setStrategy(this.getAttr(attrs, "strategy"));
                    this.pushStack(inhmd);
                    break block184;
                }
                if (localName.equals("discriminator")) {
                    md = this.getStack();
                    if (md instanceof InheritanceMetaData) {
                        InheritanceMetaData inhmd = (InheritanceMetaData)md;
                        DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetaData();
                        dismd.setColumnName(this.getAttr(attrs, "column"));
                        dismd.setValue(this.getAttr(attrs, "value"));
                        dismd.setStrategy(this.getAttr(attrs, "strategy"));
                        dismd.setIndexed(this.getAttr(attrs, "indexed"));
                        this.pushStack(dismd);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData embmd = (EmbeddedMetaData)md;
                        DiscriminatorMetaData dismd = embmd.newDiscriminatorMetaData();
                        dismd.setColumnName(this.getAttr(attrs, "column"));
                        dismd.setValue(this.getAttr(attrs, "value"));
                        dismd.setStrategy(this.getAttr(attrs, "strategy"));
                        dismd.setIndexed(this.getAttr(attrs, "indexed"));
                        this.pushStack(dismd);
                    }
                    break block184;
                }
                if (localName.equals("query")) {
                    MetaData emd = this.getStack();
                    String name = this.getAttr(attrs, "name");
                    String lang = this.getAttr(attrs, "language");
                    if (!StringUtils.isWhitespace(lang)) {
                        if (lang.equals("javax.jdo.query.JDOQL")) {
                            lang = QueryLanguage.JDOQL.name();
                        } else if (lang.equals("javax.jdo.query.SQL")) {
                            lang = QueryLanguage.SQL.name();
                        } else if (lang.equals("javax.jdo.query.JPQL")) {
                            lang = QueryLanguage.JPQL.name();
                        }
                    }
                    if (emd instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)emd;
                        if (StringUtils.isWhitespace(name)) {
                            throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setScope(cmd.getFullClassName());
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        cmd.addQuery(qmd);
                        this.pushStack(qmd);
                    } else if (emd instanceof InterfaceMetaData) {
                        InterfaceMetaData imd = (InterfaceMetaData)emd;
                        if (StringUtils.isWhitespace(name)) {
                            throw new InvalidClassMetaDataException("044154", new Object[]{imd.getFullClassName()});
                        }
                        QueryMetaData qmd = new QueryMetaData(name);
                        qmd.setScope(imd.getFullClassName());
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        imd.addQuery(qmd);
                        this.pushStack(qmd);
                    } else if (emd instanceof FileMetaData) {
                        FileMetaData filemd2 = (FileMetaData)emd;
                        QueryMetaData qmd = filemd2.newQueryMetaData(name);
                        qmd.setLanguage(lang);
                        qmd.setUnmodifiable(this.getAttr(attrs, "unmodifiable"));
                        qmd.setResultClass(this.getAttr(attrs, "result-class"));
                        qmd.setUnique(this.getAttr(attrs, "unique"));
                        qmd.setFetchPlanName(this.getAttr(attrs, "fetch-plan"));
                        this.pushStack(qmd);
                    }
                    break block184;
                }
                if (localName.equals("sequence")) {
                    String seqStart;
                    pmd = (PackageMetaData)this.getStack();
                    SequenceMetaData seqmd = pmd.newSequenceMetaData(this.getAttr(attrs, "name"), this.getAttr(attrs, "strategy"));
                    seqmd.setFactoryClass(this.getAttr(attrs, "factory-class"));
                    seqmd.setDatastoreSequence(this.getAttr(attrs, "datastore-sequence"));
                    String seqSize = this.getAttr(attrs, "allocation-size");
                    if (seqSize != null) {
                        seqmd.setAllocationSize(seqSize);
                    }
                    if ((seqStart = this.getAttr(attrs, "initial-value")) != null) {
                        seqmd.setInitialValue(seqStart);
                    }
                    this.pushStack(seqmd);
                    break block184;
                }
                if (localName.equals("field")) {
                    md = this.getStack();
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmd = (FetchGroupMetaData)md;
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData(fgmd, this.getAttr(attrs, "name"));
                        fgmmd.setRecursionDepth(this.getAttr(attrs, "recursion-depth"));
                        fgmd.addMember(fgmmd);
                        this.pushStack(fgmmd);
                        return;
                    }
                    FieldMetaData fmd2 = this.newFieldObject(md, attrs);
                    if (md instanceof ClassMetaData) {
                        ClassMetaData cmd = (ClassMetaData)md;
                        cmd.addMember(fmd2);
                    } else if (md instanceof EmbeddedMetaData) {
                        EmbeddedMetaData emd = (EmbeddedMetaData)md;
                        emd.addMember(fmd2);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addMember(fmd2.getName());
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData imd = (IndexMetaData)md;
                        imd.addMember(fmd2.getName());
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData umd = (UniqueMetaData)md;
                        umd.addMember(fmd2.getName());
                    }
                    this.pushStack(fmd2);
                    break block184;
                }
                if (localName.equals("join")) {
                    parent = this.getStack();
                    String tableName = this.getAttr(attrs, "table");
                    String columnName = this.getAttr(attrs, "column");
                    String outer = this.getAttr(attrs, "outer");
                    IndexedValue indexed = IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed"));
                    String unique = this.getAttr(attrs, "unique");
                    String deleteAction = this.getAttr(attrs, "delete-action");
                    JoinMetaData joinmd = null;
                    if (parent instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd3 = (AbstractMemberMetaData)parent;
                        joinmd = fmd3.newJoinMetaData();
                    } else if (parent instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)parent;
                        joinmd = new JoinMetaData();
                        cmd.addJoin(joinmd);
                    } else if (parent instanceof InheritanceMetaData) {
                        InheritanceMetaData inhmd = (InheritanceMetaData)parent;
                        joinmd = inhmd.newJoinMetaData();
                    } else {
                        throw new NucleusUserException("Error processing JDO XML metadata. Found \"join\" with parent " + StringUtils.toJVMIDString(parent) + " - not supported");
                    }
                    joinmd.setTable(tableName);
                    joinmd.setColumnName(columnName);
                    joinmd.setOuter(MetaDataUtils.getBooleanForString(outer, false));
                    joinmd.setIndexed(indexed);
                    joinmd.setUnique(unique);
                    joinmd.setDeleteAction(deleteAction);
                    this.pushStack(joinmd);
                    break block184;
                }
                if (localName.equals("map")) {
                    String depValStr;
                    String serValStr;
                    String depKeyStr;
                    String serKeyStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    MapMetaData mapmd = fmd.newMapMetaData();
                    mapmd.setKeyType(this.getAttr(attrs, "key-type"));
                    String embKeyStr = this.getAttr(attrs, "embedded-key");
                    if (!StringUtils.isWhitespace(embKeyStr)) {
                        mapmd.setEmbeddedKey(Boolean.valueOf(embKeyStr));
                    }
                    if (!StringUtils.isWhitespace(serKeyStr = this.getAttr(attrs, "serialized-key"))) {
                        mapmd.setSerializedKey(Boolean.valueOf(serKeyStr));
                    }
                    if (!StringUtils.isWhitespace(depKeyStr = this.getAttr(attrs, "dependent-key"))) {
                        mapmd.setDependentKey(Boolean.valueOf(depKeyStr));
                    }
                    mapmd.setValueType(this.getAttr(attrs, "value-type"));
                    String embValStr = this.getAttr(attrs, "embedded-value");
                    if (!StringUtils.isWhitespace(embValStr)) {
                        mapmd.setEmbeddedValue(Boolean.valueOf(embValStr));
                    }
                    if (!StringUtils.isWhitespace(serValStr = this.getAttr(attrs, "serialized-value"))) {
                        mapmd.setSerializedValue(Boolean.valueOf(serValStr));
                    }
                    if (!StringUtils.isWhitespace(depValStr = this.getAttr(attrs, "dependent-value"))) {
                        mapmd.setDependentValue(Boolean.valueOf(depValStr));
                    }
                    this.pushStack(mapmd);
                    break block184;
                }
                if (localName.equals("array")) {
                    String depElemStr;
                    String serElemStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ArrayMetaData arrmd = fmd.newArrayMetaData();
                    arrmd.setElementType(this.getAttr(attrs, "element-type"));
                    String embElemStr = this.getAttr(attrs, "embedded-element");
                    if (!StringUtils.isWhitespace(embElemStr)) {
                        arrmd.setEmbeddedElement(Boolean.valueOf(embElemStr));
                    }
                    if (!StringUtils.isWhitespace(serElemStr = this.getAttr(attrs, "serialized-element"))) {
                        arrmd.setSerializedElement(Boolean.valueOf(serElemStr));
                    }
                    if (!StringUtils.isWhitespace(depElemStr = this.getAttr(attrs, "dependent-element"))) {
                        arrmd.setDependentElement(Boolean.valueOf(depElemStr));
                    }
                    this.pushStack(arrmd);
                    break block184;
                }
                if (localName.equals("collection")) {
                    String depElemStr;
                    String serElemStr;
                    fmd = (AbstractMemberMetaData)this.getStack();
                    CollectionMetaData collmd = fmd.newCollectionMetaData();
                    collmd.setElementType(this.getAttr(attrs, "element-type"));
                    String embElemStr = this.getAttr(attrs, "embedded-element");
                    if (!StringUtils.isWhitespace(embElemStr)) {
                        collmd.setEmbeddedElement(Boolean.valueOf(embElemStr));
                    }
                    if (!StringUtils.isWhitespace(serElemStr = this.getAttr(attrs, "serialized-element"))) {
                        collmd.setSerializedElement(Boolean.valueOf(serElemStr));
                    }
                    if (!StringUtils.isWhitespace(depElemStr = this.getAttr(attrs, "dependent-element"))) {
                        collmd.setDependentElement(Boolean.valueOf(depElemStr));
                    }
                    this.pushStack(collmd);
                    break block184;
                }
                if (localName.equals("column")) {
                    md = this.getStack();
                    ColumnMetaData colmd = new ColumnMetaData();
                    colmd.setName(this.getAttr(attrs, "name"));
                    colmd.setTarget(this.getAttr(attrs, "target"));
                    colmd.setTargetMember(this.getAttr(attrs, "target-field"));
                    colmd.setJdbcType(this.getAttr(attrs, "jdbc-type"));
                    colmd.setSqlType(this.getAttr(attrs, "sql-type"));
                    colmd.setLength(this.getAttr(attrs, "length"));
                    colmd.setScale(this.getAttr(attrs, "scale"));
                    colmd.setAllowsNull(this.getAttr(attrs, "allows-null"));
                    colmd.setDefaultValue(this.getAttr(attrs, "default-value"));
                    colmd.setInsertValue(this.getAttr(attrs, "insert-value"));
                    String pos = this.getAttr(attrs, "position");
                    if (pos != null) {
                        colmd.setPosition(pos);
                    }
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd4 = (AbstractMemberMetaData)md;
                        fmd4.addColumn(colmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elemd = (AbstractElementMetaData)md;
                        elemd.addColumn(colmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jnmd = (JoinMetaData)md;
                        jnmd.addColumn(colmd);
                    } else if (md instanceof DatastoreIdentityMetaData) {
                        DatastoreIdentityMetaData idmd = (DatastoreIdentityMetaData)md;
                        idmd.setColumnMetaData(colmd);
                    } else if (md instanceof ForeignKeyMetaData) {
                        ForeignKeyMetaData fkmd = (ForeignKeyMetaData)md;
                        fkmd.addColumn(colmd);
                    } else if (md instanceof IndexMetaData) {
                        IndexMetaData idxmd = (IndexMetaData)md;
                        idxmd.addColumn(colmd.getName());
                    } else if (md instanceof UniqueMetaData) {
                        UniqueMetaData unimd = (UniqueMetaData)md;
                        unimd.addColumn(colmd.getName());
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData ormd = (OrderMetaData)md;
                        ormd.addColumn(colmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setColumnMetaData(colmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setColumnMetaData(colmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        cmd.addUnmappedColumn(colmd);
                    } else if (md instanceof PrimaryKeyMetaData) {
                        PrimaryKeyMetaData pkmd = (PrimaryKeyMetaData)md;
                        pkmd.addColumn(colmd);
                    }
                    this.pushStack(colmd);
                    break block184;
                }
                if (localName.equals("element")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ElementMetaData elemmd = new ElementMetaData();
                    elemmd.setTable(this.getAttr(attrs, "table"));
                    elemmd.setColumnName(this.getAttr(attrs, "column"));
                    elemmd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    elemmd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    elemmd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
                    elemmd.setUnique(MetaDataUtils.getBooleanForString(this.getAttr(attrs, "unique"), false));
                    String mappedBy = this.getAttr(attrs, "mapped-by");
                    elemmd.setMappedBy(mappedBy);
                    if (!StringUtils.isWhitespace(mappedBy) && fmd.getMappedBy() == null) {
                        fmd.setMappedBy(mappedBy);
                    }
                    String converterAttr = this.getAttr(attrs, "converter");
                    String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
                    if (!(disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr) || StringUtils.isWhitespace(converterAttr))) {
                        Class converterCls;
                        TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName((converterCls = this.clr.classForName(converterAttr)).getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, null);
                            Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            JDOTypeConverter typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterAttr, typeConv, attrType, dbType, false, null);
                        }
                        elemmd.addExtension("type-converter-name", converterAttr);
                    }
                    fmd.setElementMetaData(elemmd);
                    this.pushStack(elemmd);
                    break block184;
                }
                if (localName.equals("key")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    KeyMetaData keymd = new KeyMetaData();
                    keymd.setTable(this.getAttr(attrs, "table"));
                    keymd.setColumnName(this.getAttr(attrs, "column"));
                    keymd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    keymd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    keymd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
                    keymd.setUnique(MetaDataUtils.getBooleanForString(this.getAttr(attrs, "unique"), false));
                    keymd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    String converterAttr = this.getAttr(attrs, "converter");
                    String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
                    if (!(disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr) || StringUtils.isWhitespace(converterAttr))) {
                        Class converterCls;
                        TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName((converterCls = this.clr.classForName(converterAttr)).getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, null);
                            Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            JDOTypeConverter typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterAttr, typeConv, attrType, dbType, false, null);
                        }
                        keymd.addExtension("type-converter-name", converterAttr);
                    }
                    fmd.setKeyMetaData(keymd);
                    this.pushStack(keymd);
                    break block184;
                }
                if (localName.equals("value")) {
                    fmd = (AbstractMemberMetaData)this.getStack();
                    ValueMetaData valuemd = new ValueMetaData();
                    valuemd.setTable(this.getAttr(attrs, "table"));
                    valuemd.setColumnName(this.getAttr(attrs, "column"));
                    valuemd.setDeleteAction(this.getAttr(attrs, "delete-action"));
                    valuemd.setUpdateAction(this.getAttr(attrs, "update-action"));
                    valuemd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
                    valuemd.setUnique(MetaDataUtils.getBooleanForString(this.getAttr(attrs, "unique"), false));
                    valuemd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    String converterAttr = this.getAttr(attrs, "converter");
                    String disableConverterAttr = this.getAttr(attrs, "use-default-conversion");
                    if (!(disableConverterAttr != null && Boolean.getBoolean(disableConverterAttr) || StringUtils.isWhitespace(converterAttr))) {
                        Class converterCls;
                        TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName((converterCls = this.clr.classForName(converterAttr)).getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, null);
                            Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            JDOTypeConverter typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterAttr, typeConv, attrType, dbType, false, null);
                        }
                        valuemd.addExtension("type-converter-name", converterAttr);
                    }
                    fmd.setValueMetaData(valuemd);
                    this.pushStack(valuemd);
                    break block184;
                }
                if (localName.equals("fetch-group")) {
                    md = this.getStack();
                    FetchGroupMetaData fgmd = new FetchGroupMetaData(this.getAttr(attrs, "name"));
                    String postLoadStr = this.getAttr(attrs, "post-load");
                    if (!StringUtils.isWhitespace(postLoadStr)) {
                        fgmd.setPostLoad(Boolean.valueOf(postLoadStr));
                    }
                    if (md instanceof FetchGroupMetaData) {
                        FetchGroupMetaData fgmdParent = (FetchGroupMetaData)md;
                        fgmdParent.addFetchGroup(fgmd);
                    } else if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        cmd.addFetchGroup(fgmd);
                    } else if (md instanceof FetchPlanMetaData) {
                        FetchPlanMetaData fpmd = (FetchPlanMetaData)md;
                        fpmd.addFetchGroup(fgmd);
                    }
                    this.pushStack(fgmd);
                    break block184;
                }
                if (localName.equals("extension")) {
                    md = this.getStack();
                    String vendorName = this.getAttr(attrs, "vendor-name");
                    if (StringUtils.isWhitespace(vendorName)) {
                        throw new InvalidMetaDataException("044160", vendorName, this.getAttr(attrs, "key"), this.getAttr(attrs, "value"));
                    }
                    if (vendorName != null && vendorName.equalsIgnoreCase("datanucleus")) {
                        String extKey = this.getAttr(attrs, "key");
                        if (extKey.equals("multitenant") || extKey.equals("multitenancy-column-name") || extKey.equals("multitenancy-jdbc-type") || extKey.equals("multitenancy-column-length")) {
                            AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                            MultitenancyMetaData mtmd = cmd.getMultitenancyMetaData();
                            if (mtmd == null) {
                                mtmd = cmd.newMultitenancyMetaData();
                            }
                            if (extKey.equals("multitenancy-column-name")) {
                                mtmd.setColumnName(this.getAttr(attrs, "value"));
                            } else if (extKey.equals("multitenancy-column-length")) {
                                ColumnMetaData colmd = mtmd.getColumnMetaData();
                                if (colmd == null) {
                                    colmd = mtmd.newColumnMetaData();
                                }
                                colmd.setLength(this.getAttr(attrs, "value"));
                            }
                        } else if (extKey.equals("softdelete") || extKey.equals("softdelete-column-name")) {
                            AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                            MultitenancyMetaData mtmd = cmd.getMultitenancyMetaData();
                            if (mtmd == null) {
                                mtmd = cmd.newMultitenancyMetaData();
                            }
                            if (extKey.equals("softdelete-column-name")) {
                                mtmd.setColumnName(this.getAttr(attrs, "value"));
                            }
                        } else {
                            md.addExtension(extKey, this.getAttr(attrs, "value"));
                        }
                    }
                    break block184;
                }
                if (localName.equals("version")) {
                    md = this.getStack();
                    AbstractClassMetaData cmd = null;
                    String memberName = null;
                    if (md instanceof AbstractClassMetaData) {
                        cmd = (AbstractClassMetaData)md;
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData mmd = (AbstractMemberMetaData)md;
                        cmd = mmd.getAbstractClassMetaData();
                        memberName = mmd.getName();
                    }
                    if (cmd != null) {
                        VersionMetaData vermd = cmd.newVersionMetaData();
                        String strategy = this.getAttr(attrs, "strategy");
                        vermd.setStrategy(StringUtils.isWhitespace(strategy) ? "version-number" : strategy);
                        vermd.setColumnName(this.getAttr(attrs, "column"));
                        vermd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
                        if (memberName != null) {
                            vermd.setMemberName(memberName);
                        }
                        this.pushStack(vermd);
                    }
                    break block184;
                }
                if (localName.equals("index")) {
                    md = this.getStack();
                    IndexMetaData idxmd = new IndexMetaData();
                    idxmd.setName(this.getAttr(attrs, "name"));
                    idxmd.setTable(this.getAttr(attrs, "table"));
                    String uniStr = this.getAttr(attrs, "unique");
                    if (!StringUtils.isWhitespace(uniStr)) {
                        idxmd.setUnique(Boolean.valueOf(uniStr));
                    }
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        cmd.addIndex(idxmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd5 = (AbstractMemberMetaData)md;
                        fmd5.setIndexMetaData(idxmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setIndexMetaData(idxmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setIndexMetaData(idxmd);
                    } else if (md instanceof OrderMetaData) {
                        OrderMetaData omd = (OrderMetaData)md;
                        omd.setIndexMetaData(idxmd);
                    } else if (md instanceof VersionMetaData) {
                        VersionMetaData vermd = (VersionMetaData)md;
                        vermd.setIndexMetaData(idxmd);
                    } else if (md instanceof DiscriminatorMetaData) {
                        DiscriminatorMetaData dismd = (DiscriminatorMetaData)md;
                        dismd.setIndexMetaData(idxmd);
                    }
                    this.pushStack(idxmd);
                    break block184;
                }
                if (localName.equals("unique")) {
                    md = this.getStack();
                    UniqueMetaData unimd = new UniqueMetaData();
                    unimd.setName(this.getAttr(attrs, "name"));
                    unimd.setTable(this.getAttr(attrs, "table"));
                    String defStr = this.getAttr(attrs, "deferred");
                    if (!StringUtils.isWhitespace(defStr)) {
                        unimd.setDeferred(Boolean.valueOf(defStr));
                    }
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        cmd.addUniqueConstraint(unimd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd6 = (AbstractMemberMetaData)md;
                        fmd6.setUniqueMetaData(unimd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setUniqueMetaData(unimd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setUniqueMetaData(unimd);
                    }
                    this.pushStack(unimd);
                    break block184;
                }
                if (localName.equals("foreign-key")) {
                    md = this.getStack();
                    ForeignKeyMetaData fkmd = new ForeignKeyMetaData();
                    fkmd.setName(this.getAttr(attrs, "name"));
                    fkmd.setTable(this.getAttr(attrs, "table"));
                    fkmd.setUnique(this.getAttr(attrs, "unique"));
                    fkmd.setDeferred(this.getAttr(attrs, "deferred"));
                    fkmd.setDeleteAction(ForeignKeyAction.getForeignKeyAction(this.getAttr(attrs, "delete-action")));
                    fkmd.setUpdateAction(ForeignKeyAction.getForeignKeyAction(this.getAttr(attrs, "update-action")));
                    if (md instanceof AbstractClassMetaData) {
                        AbstractClassMetaData cmd = (AbstractClassMetaData)md;
                        cmd.addForeignKey(fkmd);
                    } else if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd7 = (AbstractMemberMetaData)md;
                        fmd7.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof JoinMetaData) {
                        JoinMetaData jmd = (JoinMetaData)md;
                        jmd.setForeignKeyMetaData(fkmd);
                    } else if (md instanceof AbstractElementMetaData) {
                        AbstractElementMetaData elmd = (AbstractElementMetaData)md;
                        elmd.setForeignKeyMetaData(fkmd);
                    }
                    this.pushStack(fkmd);
                    break block184;
                }
                if (localName.equals("order")) {
                    OrderMetaData ordmd = new OrderMetaData();
                    ordmd.setIndexed(IndexedValue.getIndexedValue(this.getAttr(attrs, "indexed")));
                    ordmd.setColumnName(this.getAttr(attrs, "column"));
                    ordmd.setMappedBy(this.getAttr(attrs, "mapped-by"));
                    AbstractMemberMetaData fmd8 = (AbstractMemberMetaData)this.getStack();
                    fmd8.setOrderMetaData(ordmd);
                    this.pushStack(ordmd);
                    break block184;
                }
                if (localName.equals("embedded")) {
                    md = this.getStack();
                    EmbeddedMetaData embmd = new EmbeddedMetaData();
                    embmd.setOwnerMember(this.getAttr(attrs, "owner-field"));
                    embmd.setNullIndicatorColumn(this.getAttr(attrs, "null-indicator-column"));
                    embmd.setNullIndicatorValue(this.getAttr(attrs, "null-indicator-value"));
                    if (md instanceof AbstractMemberMetaData) {
                        AbstractMemberMetaData fmd9 = (AbstractMemberMetaData)md;
                        fmd9.setEmbeddedMetaData(embmd);
                    } else if (md instanceof KeyMetaData) {
                        KeyMetaData kmd = (KeyMetaData)md;
                        kmd.setEmbeddedMetaData(embmd);
                    } else if (md instanceof ValueMetaData) {
                        ValueMetaData vmd = (ValueMetaData)md;
                        vmd.setEmbeddedMetaData(embmd);
                    } else if (md instanceof ElementMetaData) {
                        ElementMetaData elmd = (ElementMetaData)md;
                        elmd.setEmbeddedMetaData(embmd);
                    }
                    this.pushStack(embmd);
                    break block184;
                }
                String message = Localiser.msg("044037", qName);
                NucleusLogger.METADATA.error(message);
                throw new RuntimeException(message);
            }
            catch (RuntimeException ex) {
                NucleusLogger.METADATA.error(Localiser.msg("044042", qName, this.getStack(), uri), ex);
                throw ex;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentString;
        if (localName.length() < 1) {
            localName = qName;
        }
        if ((currentString = this.getString().trim()).length() > 0) {
            MetaData md = this.getStack();
            if (localName.equals("query")) {
                ((QueryMetaData)md).setQuery(currentString);
            }
        }
        if (localName.equals("package") || localName.equals("fetch-plan") || localName.equals("class") || localName.equals("interface") || localName.equals("implements") || localName.equals("property") || localName.equals("datastore-identity") || localName.equals("inheritance") || localName.equals("primary-key") || localName.equals("version") || localName.equals("unmapped") || localName.equals("query") || localName.equals("sequence") || localName.equals("field") || localName.equals("map") || localName.equals("element") || localName.equals("embedded") || localName.equals("key") || localName.equals("value") || localName.equals("array") || localName.equals("collection") || localName.equals("join") || localName.equals("index") || localName.equals("unique") || localName.equals("foreign-key") || localName.equals("order") || localName.equals("fetch-group") || localName.equals("column") || localName.equals("discriminator")) {
            this.popStack();
        }
    }
}

