/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;

class PersistentClean
extends LifeCycleState {
    protected PersistentClean() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 2;
    }

    @Override
    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    @Override
    public LifeCycleState transitionMakeNontransactional(DNStateManager sm) {
        sm.clearSavedFields();
        return this.changeState(sm, 9);
    }

    @Override
    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    @Override
    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionEvict(DNStateManager sm) {
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    @Override
    public LifeCycleState transitionWriteField(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.getRestoreValues()) {
            sm.saveFields();
        }
        return this.changeState(sm, 3);
    }

    @Override
    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    @Override
    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        return this;
    }

    @Override
    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        return this;
    }

    @Override
    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    @Override
    public String toString() {
        return "P_CLEAN";
    }
}

