/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.cache.L2CachePopulateFieldManager;
import org.datanucleus.cache.L2CacheRetrieveFieldManager;
import org.datanucleus.cache.Level2Cache;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.DeleteOperation;
import org.datanucleus.flush.PersistOperation;
import org.datanucleus.flush.UpdateMemberOperation;
import org.datanucleus.identity.IdentityReference;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.state.CallbackHandler;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.SavedState;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectReferencingStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.federation.FederatedStoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchDepthFieldManager;
import org.datanucleus.store.fieldmanager.AttachFieldManager;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.DetachFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.LoadFieldManager;
import org.datanucleus.store.fieldmanager.MakeTransientFieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.fieldmanager.SingleTypeFieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.fieldmanager.UnsetOwnerFieldManager;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOCollection;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOMap;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConversionHelper;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class StateManagerImpl
implements DNStateManager<Persistable> {
    protected static final SingleTypeFieldManager HOLLOWFIELDMANAGER = new SingleTypeFieldManager();
    protected static final int FLAG_INSERTING = 0x400000;
    protected static final int FLAG_INSERTING_CALLBACKS = 0x200000;
    protected static final int FLAG_DELETING = 0x100000;
    protected static final int FLAG_EMBEDDED = 524288;
    protected static final int FLAG_VALIDATING = 262144;
    protected static final int FLAG_RESTORE_VALUES = 131072;
    protected static final int FLAG_STORING_PC = 65536;
    protected static final int FLAG_NEED_INHERITANCE_VALIDATION = 32768;
    protected static final int FLAG_POSTINSERT_UPDATE = 16384;
    protected static final int FLAG_LOADINGFPFIELDS = 8192;
    protected static final int FLAG_POSTLOAD_PENDING = 4096;
    protected static final int FLAG_CHANGING_STATE = 2048;
    protected static final int FLAG_FLUSHED_NEW = 1024;
    protected static final int FLAG_BECOMING_DELETED = 512;
    protected static final int FLAG_UPDATING_EMBEDDING_FIELDS_WITH_OWNER = 256;
    protected static final int FLAG_RETRIEVING_DETACHED_STATE = 128;
    protected static final int FLAG_RESETTING_DETACHED_STATE = 64;
    protected static final int FLAG_ATTACHING = 32;
    protected static final int FLAG_DETACHING = 16;
    protected static final int FLAG_MAKING_TRANSIENT = 8;
    protected static final int FLAG_FLUSHING = 4;
    protected static final int FLAG_DISCONNECTING = 2;
    protected Persistable myPC;
    protected int flags;
    protected ExecutionContext myEC;
    protected AbstractClassMetaData cmd;
    protected Object myInternalID;
    protected Object myID;
    protected LifeCycleState myLC;
    protected Object myVersion;
    protected Object transactionalVersion;
    protected byte persistenceFlags;
    protected FetchPlanForClass myFP;
    protected boolean dirty = false;
    protected boolean[] dirtyFields;
    protected boolean[] loadedFields;
    protected FieldManager currFM = null;
    protected SavedState savedState = null;
    private static final EnhancementHelper HELPER = (EnhancementHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return EnhancementHelper.getInstance();
            }
            catch (SecurityException e) {
                throw new NucleusUserException(Localiser.msg("026000"), e).setFatal();
            }
        }
    });
    boolean[] preDeleteLoadedFields = null;

    public StateManagerImpl(ExecutionContext ec, AbstractClassMetaData cmd) {
        this.connect(ec, cmd);
    }

    @Override
    public void connect(ExecutionContext ec, AbstractClassMetaData cmd) {
        int fieldCount = cmd.getMemberCount();
        this.cmd = cmd;
        this.myEC = ec;
        this.dirtyFields = new boolean[fieldCount];
        this.loadedFields = new boolean[fieldCount];
        this.dirty = false;
        this.myFP = this.myEC.getFetchPlan().getFetchPlanForClass(cmd);
        this.myVersion = null;
        this.transactionalVersion = null;
        this.persistenceFlags = 0;
        ec.setAttachDetachReferencedObject(this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        List<ExecutionContext.EmbeddedOwnerRelation> subSMRelations;
        int[] fieldNumbers;
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("026011", IdentityUtils.getPersistableIdentityForId(this.getInternalObjectId()), this));
        }
        if (this.isPostLoadPending()) {
            this.flags &= 0xFFFFF7FF;
            this.setPostLoadPending(false);
            this.postLoad();
        }
        if ((fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getSCOMutableMemberPositions(), true)) != null && fieldNumbers.length > 0) {
            this.provideFields(fieldNumbers, new UnsetOwnerFieldManager());
        }
        if ((subSMRelations = this.myEC.getEmbeddedInformationForOwner(this)) != null && !subSMRelations.isEmpty()) {
            for (ExecutionContext.EmbeddedOwnerRelation embRel : subSMRelations) {
                DNStateManager embSM = embRel.getEmbeddedSM();
                if (!embSM.isConnected()) continue;
                embSM.disconnect();
            }
        }
        this.myEC.removeStateManagerFromCache(this);
        this.persistenceFlags = 0;
        this.myPC.dnReplaceFlags();
        this.flags |= 2;
        try {
            this.replaceStateManager(this.myPC, null);
        }
        finally {
            this.flags &= 0xFFFFFFFD;
        }
        this.savedState = null;
        this.preDeleteLoadedFields = null;
        this.myPC = null;
        this.myID = null;
        this.myInternalID = null;
        this.myLC = null;
        this.myEC = null;
        this.myFP = null;
        this.myVersion = null;
        this.persistenceFlags = 0;
        this.flags = 0;
        this.transactionalVersion = null;
        this.currFM = null;
        this.dirty = false;
        this.cmd = null;
        this.dirtyFields = null;
        this.loadedFields = null;
    }

    @Override
    public boolean isConnected() {
        return this.myPC != null;
    }

    @Override
    public void initialiseForHollow(Object id, FieldValues fv, Class pcClass) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.persistenceFlags = 1;
        if (IdentityUtils.isDatastoreIdentity(id) || id == null) {
            this.myPC = HELPER.newInstance(pcClass, this);
        } else {
            this.myPC = HELPER.newInstance(pcClass, this, this.myID);
            this.markPKFieldsAsLoaded();
        }
        this.myEC.putObjectIntoLevel1Cache(this);
        if (fv != null) {
            this.loadFieldValues(fv);
        }
    }

    @Override
    public void initialiseForHollowPreConstructed(Object id, Persistable pc) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.persistenceFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.dnReplaceFlags();
    }

    @Override
    public void initialiseForPersistentClean(Object id, Persistable pc) {
        this.myID = id;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.persistenceFlags = 1;
        this.myPC = pc;
        this.replaceStateManager(this.myPC, this);
        this.myPC.dnReplaceFlags();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myEC.putObjectIntoLevel1Cache(this);
    }

    @Override
    public void initialiseForEmbedded(Persistable pc, boolean copyPc) {
        this.myID = null;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.persistenceFlags = 1;
        this.flags |= 0x80000;
        this.myPC = pc;
        this.replaceStateManager(this.myPC, this);
        if (copyPc) {
            Persistable pcCopy = this.myPC.dnNewInstance(this);
            pcCopy.dnCopyFields(this.myPC, this.cmd.getAllMemberPositions());
            this.replaceStateManager(pcCopy, this);
            this.myPC = pcCopy;
            pc.dnReplaceFlags();
            this.replaceStateManager(pc, null);
        }
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    @Override
    public void initialiseForEmbedded(Class<Persistable> pcClass) {
        this.myID = null;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.persistenceFlags = 1;
        this.flags |= 0x80000;
        this.myPC = HELPER.newInstance(pcClass, this);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialiseForPersistentNew(Persistable pc, FieldValues preInsertChanges) {
        ClassLoaderResolver clr;
        int[] relationPositions;
        this.myPC = pc;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(1);
        this.persistenceFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
        this.myPC.dnReplaceFlags();
        this.saveFields();
        this.populateValueGenerationMembers();
        if (preInsertChanges != null) {
            preInsertChanges.fetchFields(this);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkFieldNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNumbers.length; ++i) {
                int fieldNumber = pkFieldNumbers[i];
                AbstractMemberMetaData pkMmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (this.myEC.getMetaDataManager().getMetaDataForClass(pkMmd.getType(), this.getExecutionContext().getClassLoaderResolver()) == null) continue;
                try {
                    if (this.myEC.getMultithreaded()) {
                        this.myEC.threadLock();
                    }
                    FieldManager prevFM = this.currFM;
                    try {
                        this.currFM = new SingleValueFieldManager();
                        this.myPC.dnProvideField(fieldNumber);
                        Persistable pkFieldPC = (Persistable)((SingleValueFieldManager)this.currFM).fetchObjectField(fieldNumber);
                        if (pkFieldPC == null) {
                            throw new NucleusUserException(Localiser.msg("026016", pkMmd.getFullFieldName()));
                        }
                        if (this.myEC.getApiAdapter().isPersistent(pkFieldPC)) continue;
                        Persistable persistedFieldPC = null;
                        persistedFieldPC = pkMmd.isEmbedded() ? this.myEC.persistObjectInternal(pkFieldPC, null, PersistableObjectType.EMBEDDED_PC, this, fieldNumber) : this.myEC.persistObjectInternal(pkFieldPC, null, PersistableObjectType.PC);
                        this.replaceField(this.myPC, fieldNumber, persistedFieldPC, false);
                        continue;
                    }
                    finally {
                        this.currFM = prevFM;
                    }
                }
                finally {
                    if (this.myEC.getMultithreaded()) {
                        this.myEC.threadUnlock();
                    }
                }
            }
        }
        this.setIdentity(false);
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
        this.getCallbackHandler().postCreate(this.myPC);
        if (this.myEC.getManageRelations() && (relationPositions = this.cmd.getRelationMemberPositions(clr = this.myEC.getClassLoaderResolver())) != null) {
            for (int i = 0; i < relationPositions.length; ++i) {
                Object value;
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(relationPositions[i]);
                if (!RelationType.isBidirectional(mmd.getRelationType(clr)) || (value = this.provideField(relationPositions[i])) == null) continue;
                this.myEC.getRelationshipManager(this).relationChange(relationPositions[i], null, value);
            }
        }
    }

    @Override
    public void initialiseForTransactionalTransient(Persistable pc) {
        this.myPC = pc;
        this.myLC = null;
        this.persistenceFlags = (byte)-1;
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.myPC.dnReplaceFlags();
        this.populateValueGenerationMembers();
        this.setIdentity(false);
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
    }

    @Override
    public void initialiseForDetached(Persistable pc, Object id, Object version) {
        this.myID = id;
        this.myPC = pc;
        this.setVersion(version);
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(11);
        this.myPC.dnReplaceFlags();
        this.replaceStateManager(this.myPC, this);
    }

    @Override
    public void initialiseForPNewToBeDeleted(Persistable pc) {
        this.myID = null;
        this.myPC = pc;
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(1);
        for (int i = 0; i < this.loadedFields.length; ++i) {
            this.loadedFields[i] = true;
        }
        this.replaceStateManager(this.myPC, this);
    }

    @Override
    public void initialiseForCachedPC(CachedPC cachedPC, Object id) {
        this.initialiseForHollow(id, (FieldValues)null, cachedPC.getObjectClass());
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2);
        this.persistenceFlags = (byte)-1;
        int[] fieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), this.myFP.getMemberNumbers(), true);
        if (fieldsToLoad != null) {
            this.myEC.putObjectIntoLevel1Cache(this);
            L2CacheRetrieveFieldManager l2RetFM = this.constructL2CacheRetrieveFieldManager(this, cachedPC);
            this.replaceFields(fieldsToLoad, l2RetFM);
            for (int i = 0; i < fieldsToLoad.length; ++i) {
                this.loadedFields[fieldsToLoad[i]] = true;
            }
            int[] fieldsNotLoaded = l2RetFM.getFieldsNotLoaded();
            if (fieldsNotLoaded != null) {
                for (int i = 0; i < fieldsNotLoaded.length; ++i) {
                    this.loadedFields[fieldsNotLoaded[i]] = false;
                }
            }
        }
        if (cachedPC.getVersion() != null) {
            this.setVersion(cachedPC.getVersion());
        }
        this.replaceAllLoadedSCOFieldsWithWrappers();
        if (this.myEC.getTransaction().isActive()) {
            this.myEC.enlistInTransaction(this);
        }
        if (this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.postLoad();
        }
    }

    public L2CacheRetrieveFieldManager constructL2CacheRetrieveFieldManager(DNStateManager stateManager, CachedPC cachedPC) {
        return new L2CacheRetrieveFieldManager(stateManager, cachedPC);
    }

    public L2CachePopulateFieldManager constructL2CachePopulateFieldManager(DNStateManager stateManager, CachedPC cachedPC) {
        return new L2CachePopulateFieldManager(stateManager, cachedPC);
    }

    protected void populateValueGenerationMembers() {
        int[] valueGenMemberPositions = this.cmd.getValueGenerationMemberPositions();
        if (valueGenMemberPositions != null) {
            for (int i = 0; i < valueGenMemberPositions.length; ++i) {
                int memberPos = valueGenMemberPositions[i];
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(memberPos);
                if (mmd.getValueStrategy() == null || this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, memberPos)) continue;
                boolean applyStrategy = true;
                if (!mmd.getType().isPrimitive() && mmd.hasExtension("strategy-when-notnull") && mmd.getValueForExtension("strategy-when-notnull").equalsIgnoreCase("false") && this.provideField(memberPos) != null) {
                    applyStrategy = false;
                }
                if (!applyStrategy) continue;
                Object obj = this.getStoreManager().getValueGenerationStrategyValue(this.myEC, this.cmd, mmd);
                this.replaceField(memberPos, obj);
            }
        }
    }

    @Override
    public AbstractClassMetaData getClassMetaData() {
        return this.cmd;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.myEC;
    }

    @Override
    public ExecutionContextReference getExecutionContextReference() {
        return this.myEC;
    }

    @Override
    public StoreManager getStoreManager() {
        return this.myEC.getNucleusContext().isFederated() ? ((FederatedStoreManager)this.myEC.getStoreManager()).getStoreManagerForClass(this.cmd) : this.myEC.getStoreManager();
    }

    @Override
    public FetchPlanForClass getFetchPlanForClass() {
        return this.myFP;
    }

    @Override
    public LifeCycleState getLifecycleState() {
        return this.myLC;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.myEC.getCallbackHandler();
    }

    @Override
    public Persistable getObject() {
        return this.myPC;
    }

    @Override
    public String getObjectAsPrintable() {
        return StringUtils.toJVMIDString(this.myPC);
    }

    public String toString() {
        return "StateManager[pc=" + StringUtils.toJVMIDString(this.myPC) + ", lifecycle=" + this.myLC + (this.isEmbedded() ? ", EMBEDDED" : "") + "]";
    }

    @Override
    public boolean isWaitingToBeFlushedToDatastore() {
        return this.myLC.stateType() == 1 && !this.isFlushedNew();
    }

    @Override
    public boolean isRestoreValues() {
        return (this.flags & 0x20000) != 0;
    }

    protected boolean isChangingState() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isInserting() {
        return (this.flags & 0x400000) != 0;
    }

    @Override
    public void setInserting() {
        this.flags |= 0x400000;
        this.flags &= 0xFFDFFFFF;
    }

    @Override
    public void setInsertingCallbacks() {
        this.flags &= 0xFFBFFFFF;
        this.flags |= 0x200000;
    }

    @Override
    public boolean isDeleting() {
        return (this.flags & 0x100000) != 0;
    }

    @Override
    public void markForInheritanceValidation() {
        this.flags |= 0x8000;
    }

    @Override
    public void setTransactionalVersion(Object version) {
        this.transactionalVersion = version;
    }

    public Object getTransactionalVersion(Object pc) {
        return this.transactionalVersion;
    }

    @Override
    public void setVersion(Object version) {
        this.myVersion = version;
        this.transactionalVersion = version;
    }

    @Override
    public void setFlushedNew(boolean flag) {
        this.flags = flag ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    @Override
    public boolean isFlushedNew() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isFlushedToDatastore() {
        return !this.dirty;
    }

    @Override
    public void setFlushing(boolean flushing) {
        this.flags = flushing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    protected boolean isFlushing() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void markAsFlushed() {
        this.clearDirtyFlags();
    }

    @Override
    public void refresh() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRefresh(this);
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void retrieve(boolean fgOnly) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionRetrieve((DNStateManager)this, fgOnly);
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void makePersistentTransactionalTransient() {
        this.preStateChange();
        try {
            if (this.myLC.isTransactional && !this.myLC.isPersistent) {
                this.makePersistent();
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void makeNontransactional() {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeNontransactional(this);
        }
        finally {
            this.postStateChange();
        }
    }

    protected void transitionReadField(boolean isLoaded) {
        if (this.myLC == null) {
            return;
        }
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionReadField(this, isLoaded);
            }
            finally {
                this.postStateChange();
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    protected void transitionWriteField() {
        if (this.isEmbedded()) {
            return;
        }
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionWriteField(this);
            }
            finally {
                this.postStateChange();
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    @Override
    public void evict() {
        if (this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(2) && this.myLC != this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
            return;
        }
        this.preStateChange();
        try {
            try {
                this.getCallbackHandler().preClear(this.getObject());
                this.getCallbackHandler().postClear(this.getObject());
            }
            finally {
                this.myLC = this.myLC.transitionEvict(this);
            }
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void preBegin(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionBegin(this, tx);
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void postCommit(Transaction tx) {
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionCommit(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.myVersion = this.transactionalVersion;
            }
        }
        finally {
            this.postStateChange();
        }
    }

    @Override
    public void preRollback(Transaction tx) {
        this.preStateChange();
        try {
            this.myEC.clearDirty(this);
            this.myLC = this.myLC.transitionRollback(this, tx);
            if (this.transactionalVersion != this.myVersion) {
                this.transactionalVersion = this.myVersion;
            }
        }
        finally {
            this.postStateChange();
        }
    }

    protected void internalDeletePersistent() {
        if (this.isDeleting()) {
            throw new NucleusUserException(Localiser.msg("026008"));
        }
        this.flags |= 0x100000;
        try {
            if (this.dirty) {
                this.clearDirtyFlags();
                this.myEC.flushInternal(false);
            }
            if (!this.isEmbedded()) {
                this.getStoreManager().getPersistenceHandler().deleteObject(this);
            }
            this.preDeleteLoadedFields = null;
        }
        finally {
            this.flags &= 0xFFEFFFFF;
        }
    }

    @Override
    public void locate() {
        this.getStoreManager().getPersistenceHandler().locateObject(this);
    }

    @Override
    public Persistable getReferencedPC() {
        return (Persistable)this.myEC.getAttachDetachReferencedObject(this);
    }

    protected boolean areFieldsLoaded(int[] fieldNumbers) {
        if (fieldNumbers == null) {
            return true;
        }
        for (int i = 0; i < fieldNumbers.length; ++i) {
            if (this.loadedFields[fieldNumbers[i]]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unloadField(int fieldNumber) {
        if (this.isEmbedded()) {
            throw new NucleusUserException("Cannot unload field/property of embedded object");
        }
        this.loadedFields[fieldNumber] = false;
    }

    @Override
    public void unloadNonFetchPlanFields() {
        int[] fpFieldNumbers = this.myFP.getMemberNumbers();
        int[] nonfpFieldNumbers = null;
        if (fpFieldNumbers == null || fpFieldNumbers.length == 0) {
            nonfpFieldNumbers = this.cmd.getAllMemberPositions();
        } else {
            int fieldCount = this.cmd.getMemberCount();
            if (fieldCount == fpFieldNumbers.length) {
                return;
            }
            nonfpFieldNumbers = new int[fieldCount - fpFieldNumbers.length];
            int currentFPFieldIndex = 0;
            int j = 0;
            for (int i = 0; i < fieldCount; ++i) {
                if (currentFPFieldIndex >= fpFieldNumbers.length) {
                    nonfpFieldNumbers[j++] = i;
                    continue;
                }
                if (fpFieldNumbers[currentFPFieldIndex] == i) {
                    ++currentFPFieldIndex;
                    continue;
                }
                nonfpFieldNumbers[j++] = i;
            }
        }
        for (int i = 0; i < nonfpFieldNumbers.length; ++i) {
            this.loadedFields[nonfpFieldNumbers[i]] = false;
        }
    }

    @Override
    public void markFieldsAsLoaded(int[] fieldNumbers) {
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = true;
        }
    }

    protected void markPKFieldsAsLoaded() {
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                this.loadedFields[pkPositions[i]] = true;
            }
        }
    }

    protected void updateLevel2CacheForFields(int[] fieldNumbers) {
        String updateMode = this.myEC.getStringProperty("datanucleus.cache.level2.updatemode");
        if (updateMode != null && updateMode.equalsIgnoreCase("commit-only")) {
            return;
        }
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && !this.myEC.isObjectModifiedInTransaction(this.myID)) {
            CachedPC cachedPC = l2cache.get(this.myID);
            if (cachedPC != null) {
                int[] cacheFieldsToLoad = fieldNumbers;
                CachedPC copyCachedPC = cachedPC.getCopy();
                if (NucleusLogger.CACHE.isDebugEnabled()) {
                    NucleusLogger.CACHE.debug(Localiser.msg("026033", IdentityUtils.getPersistableIdentityForId(this.myID), StringUtils.intArrayToString(cacheFieldsToLoad)));
                }
                this.provideFields(cacheFieldsToLoad, this.constructL2CachePopulateFieldManager(this, copyCachedPC));
                this.myEC.getNucleusContext().getLevel2Cache().put(this.getInternalObjectId(), copyCachedPC);
            } else {
                this.myEC.putObjectIntoLevel2Cache(this, false);
            }
        }
    }

    protected int[] loadFieldsFromLevel2Cache(int[] fieldNumbers) {
        int[] cacheFieldsToLoad;
        CachedPC cachedPC;
        if (fieldNumbers == null || fieldNumbers.length == 0 || this.myEC.isFlushing() || this.myLC.isDeleted() || this.isDeleting() || this.myEC.getTransaction().isCommitting()) {
            return fieldNumbers;
        }
        if (!this.myEC.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.cache.level2.loadfields", true)) {
            return fieldNumbers;
        }
        Level2Cache l2cache = this.myEC.getNucleusContext().getLevel2Cache();
        if (l2cache != null && this.myEC.getNucleusContext().isClassCacheable(this.cmd) && (cachedPC = l2cache.get(this.myID)) != null && (cacheFieldsToLoad = ClassUtils.getFlagsSetTo(cachedPC.getLoadedFields(), fieldNumbers, true)) != null && cacheFieldsToLoad.length > 0) {
            if (NucleusLogger.CACHE.isDebugEnabled()) {
                NucleusLogger.CACHE.debug(Localiser.msg("026034", IdentityUtils.getPersistableIdentityForId(this.myID), StringUtils.intArrayToString(cacheFieldsToLoad)));
            }
            L2CacheRetrieveFieldManager l2RetFM = this.constructL2CacheRetrieveFieldManager(this, cachedPC);
            this.replaceFields(cacheFieldsToLoad, l2RetFM);
            int[] fieldsNotLoaded = l2RetFM.getFieldsNotLoaded();
            if (fieldsNotLoaded != null) {
                for (int i = 0; i < fieldsNotLoaded.length; ++i) {
                    this.loadedFields[fieldsNotLoaded[i]] = false;
                }
            }
        }
        return ClassUtils.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
    }

    @Override
    public void loadFieldsInFetchPlan(FetchPlanState state) {
        if ((this.flags & 0x2000) != 0) {
            return;
        }
        this.flags |= 0x2000;
        try {
            this.loadUnloadedFieldsInFetchPlan();
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
            if (fieldNumbers != null && fieldNumbers.length > 0) {
                this.replaceFields(fieldNumbers, new LoadFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state));
                this.updateLevel2CacheForFields(fieldNumbers);
            }
        }
        finally {
            this.flags &= 0xFFFFDFFF;
        }
    }

    @Override
    public void loadFieldFromDatastore(int fieldNumber) {
        int[] nArray;
        if (fieldNumber >= 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = fieldNumber;
        } else {
            nArray = new int[]{};
        }
        this.loadFieldsFromDatastore(nArray);
    }

    protected void loadFieldsFromDatastore(int[] fieldNumbers) {
        VersionMetaData vermd;
        if (this.myLC.isNew() && this.myLC.isPersistent() && !this.isFlushedNew()) {
            return;
        }
        if ((this.flags & 0x8000) != 0) {
            String className = this.getStoreManager().getClassNameForObjectID(this.myID, this.myEC.getClassLoaderResolver(), this.myEC);
            if (!this.getObject().getClass().getName().equals(className)) {
                this.myEC.removeObjectFromLevel1Cache(this.myID);
                this.myEC.removeObjectFromLevel2Cache(this.myID);
                throw new NucleusObjectNotFoundException("Object with id " + IdentityUtils.getPersistableIdentityForId(this.myID) + " was created without validating of type " + this.getObject().getClass().getName() + " but is actually of type " + className);
            }
            this.flags &= 0xFFFF7FFF;
        }
        int[] fieldNumbersToFetch = fieldNumbers;
        if (this.cmd.isVersioned() && (vermd = this.cmd.getVersionMetaDataForClass()) != null && vermd.getMemberName() != null) {
            int verFieldNum = this.cmd.getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber();
            boolean versionPresent = false;
            for (int i = 0; i < fieldNumbers.length; ++i) {
                if (fieldNumbers[i] != verFieldNum) continue;
                versionPresent = true;
                break;
            }
            if (!versionPresent) {
                int[] tmpFieldNumbers = new int[fieldNumbers.length + 1];
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    tmpFieldNumbers[i] = fieldNumbers[i];
                }
                tmpFieldNumbers[fieldNumbers.length] = verFieldNum;
                fieldNumbersToFetch = tmpFieldNumbers;
            }
        }
        this.getStoreManager().getPersistenceHandler().fetchObject(this, fieldNumbersToFetch);
    }

    protected int[] getFieldNumbersOfLoadedOrDirtyFields(boolean[] loadedFields, boolean[] dirtyFields) {
        int numFields = 0;
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            ++numFields;
        }
        int[] fieldNumbers = new int[numFields];
        int n = 0;
        int[] allFieldNumbers = this.cmd.getAllMemberPositions();
        for (int i = 0; i < loadedFields.length; ++i) {
            if (!loadedFields[i] && !dirtyFields[i]) continue;
            fieldNumbers[n++] = allFieldNumbers[i];
        }
        return fieldNumbers;
    }

    @Override
    public boolean[] getDirtyFields() {
        boolean[] copy = new boolean[this.dirtyFields.length];
        System.arraycopy(this.dirtyFields, 0, copy, 0, this.dirtyFields.length);
        return copy;
    }

    @Override
    public int[] getDirtyFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.dirtyFields, true);
    }

    @Override
    public boolean[] getLoadedFields() {
        return (boolean[])this.loadedFields.clone();
    }

    @Override
    public int[] getLoadedFieldNumbers() {
        return ClassUtils.getFlagsSetTo(this.loadedFields, true);
    }

    @Override
    public boolean getAllFieldsLoaded() {
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[] getDirtyFieldNames() {
        int[] dirtyFieldNumbers = ClassUtils.getFlagsSetTo(this.dirtyFields, true);
        if (dirtyFieldNumbers != null && dirtyFieldNumbers.length > 0) {
            String[] dirtyFieldNames = new String[dirtyFieldNumbers.length];
            for (int i = 0; i < dirtyFieldNumbers.length; ++i) {
                dirtyFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(dirtyFieldNumbers[i]).getName();
            }
            return dirtyFieldNames;
        }
        return null;
    }

    @Override
    public String[] getLoadedFieldNames() {
        int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, true);
        if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
            String[] loadedFieldNames = new String[loadedFieldNumbers.length];
            for (int i = 0; i < loadedFieldNumbers.length; ++i) {
                loadedFieldNames[i] = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(loadedFieldNumbers[i]).getName();
            }
            return loadedFieldNames;
        }
        return null;
    }

    @Override
    public boolean isFieldLoaded(int fieldNumber) {
        return this.loadedFields[fieldNumber];
    }

    @Override
    public void storeFieldValue(int fieldNumber, Object value) {
        if (!this.loadedFields[fieldNumber]) {
            this.setAssociatedValue("MEMBER_VALUE.STORED." + fieldNumber, value);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026037", this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName(), this));
            }
        }
    }

    protected void clearFieldsByNumbers(int[] fieldNumbers) {
        this.replaceFields(fieldNumbers, HOLLOWFIELDMANAGER);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            this.loadedFields[fieldNumbers[i]] = false;
            this.dirtyFields[fieldNumbers[i]] = false;
        }
    }

    protected void clearDirtyFlags() {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields);
    }

    protected void clearDirtyFlags(int[] fieldNumbers) {
        this.dirty = false;
        ClassUtils.clearFlags(this.dirtyFields, fieldNumbers);
    }

    @Override
    public boolean isEmbedded() {
        return (this.flags & 0x80000) != 0;
    }

    @Override
    public void providedBooleanField(Persistable ignored, int fieldNumber, boolean currentValue) {
        this.currFM.storeBooleanField(fieldNumber, currentValue);
    }

    @Override
    public void providedByteField(Persistable ignored, int fieldNumber, byte currentValue) {
        this.currFM.storeByteField(fieldNumber, currentValue);
    }

    @Override
    public void providedCharField(Persistable ignored, int fieldNumber, char currentValue) {
        this.currFM.storeCharField(fieldNumber, currentValue);
    }

    @Override
    public void providedDoubleField(Persistable ignored, int fieldNumber, double currentValue) {
        this.currFM.storeDoubleField(fieldNumber, currentValue);
    }

    @Override
    public void providedFloatField(Persistable ignored, int fieldNumber, float currentValue) {
        this.currFM.storeFloatField(fieldNumber, currentValue);
    }

    @Override
    public void providedIntField(Persistable ignored, int fieldNumber, int currentValue) {
        this.currFM.storeIntField(fieldNumber, currentValue);
    }

    @Override
    public void providedLongField(Persistable ignored, int fieldNumber, long currentValue) {
        this.currFM.storeLongField(fieldNumber, currentValue);
    }

    @Override
    public void providedShortField(Persistable ignored, int fieldNumber, short currentValue) {
        this.currFM.storeShortField(fieldNumber, currentValue);
    }

    @Override
    public void providedStringField(Persistable ignored, int fieldNumber, String currentValue) {
        this.currFM.storeStringField(fieldNumber, currentValue);
    }

    @Override
    public void providedObjectField(Persistable ignored, int fieldNumber, Object currentValue) {
        this.currFM.storeObjectField(fieldNumber, currentValue);
    }

    @Override
    public boolean replacingBooleanField(Persistable ignored, int fieldNumber) {
        boolean value = this.currFM.fetchBooleanField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public byte replacingByteField(Persistable ignored, int fieldNumber) {
        byte value = this.currFM.fetchByteField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public char replacingCharField(Persistable ignored, int fieldNumber) {
        char value = this.currFM.fetchCharField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public double replacingDoubleField(Persistable ignored, int fieldNumber) {
        double value = this.currFM.fetchDoubleField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public float replacingFloatField(Persistable ignored, int fieldNumber) {
        float value = this.currFM.fetchFloatField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public int replacingIntField(Persistable ignored, int fieldNumber) {
        int value = this.currFM.fetchIntField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public long replacingLongField(Persistable ignored, int fieldNumber) {
        long value = this.currFM.fetchLongField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public short replacingShortField(Persistable ignored, int fieldNumber) {
        short value = this.currFM.fetchShortField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public String replacingStringField(Persistable ignored, int fieldNumber) {
        String value = this.currFM.fetchStringField(fieldNumber);
        this.loadedFields[fieldNumber] = true;
        return value;
    }

    @Override
    public Object replacingObjectField(Persistable ignored, int fieldNumber) {
        try {
            Object value = this.currFM.fetchObjectField(fieldNumber);
            this.loadedFields[fieldNumber] = true;
            return value;
        }
        catch (AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException eodge) {
            return null;
        }
    }

    @Override
    public void registerTransactional() {
        this.myEC.addStateManagerToCache(this);
    }

    @Override
    public void setAssociatedValue(Object key, Object value) {
        this.myEC.setStateManagerAssociatedValue(this, key, value);
    }

    @Override
    public Object getAssociatedValue(Object key) {
        return this.myEC.getStateManagerAssociatedValue(this, key);
    }

    @Override
    public void removeAssociatedValue(Object key) {
        this.myEC.removeStateManagerAssociatedValue(this, key);
    }

    @Override
    public boolean containsAssociatedValue(Object key) {
        return this.myEC.containsStateManagerAssociatedValue(this, key);
    }

    @Override
    public void enlistInTransaction() {
        if (!this.myEC.getTransaction().isActive()) {
            return;
        }
        this.myEC.enlistInTransaction(this);
        if (this.persistenceFlags == 1 && this.areFieldsLoaded(this.cmd.getDFGMemberPositions())) {
            this.persistenceFlags = (byte)-1;
            this.myPC.dnReplaceFlags();
        }
    }

    @Override
    public void evictFromTransaction() {
        this.myEC.evictFromTransaction(this);
        this.persistenceFlags = 1;
        this.myPC.dnReplaceFlags();
    }

    protected void replaceStateManager(final Persistable pc, final StateManager sm) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    pc.dnReplaceStateManager(sm);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new NucleusUserException(Localiser.msg("026000"), e).setFatal();
        }
    }

    @Override
    public StateManager replacingStateManager(Persistable pc, StateManager sm) {
        if (this.myLC == null) {
            throw new NucleusException("Null LifeCycleState").setFatal();
        }
        if (this.myLC.stateType() == 11) {
            return sm;
        }
        if (pc == this.myPC) {
            if (sm == null) {
                return null;
            }
            if (sm == this) {
                return this;
            }
            if (this.myEC == ((DNStateManager)sm).getExecutionContext()) {
                NucleusLogger.PERSISTENCE.debug("StateManagerImpl.replacingStateManager this=" + this + " sm=" + sm + " with same EC");
                ((DNStateManager)sm).disconnect();
                return this;
            }
            throw this.myEC.getApiAdapter().getUserExceptionForException(Localiser.msg("026003"), null);
        }
        if (pc == (this.savedState != null ? this.savedState.getPC() : null)) {
            return null;
        }
        return sm;
    }

    @Override
    public void replaceManagedPC(Persistable pc) {
        if (pc == null) {
            return;
        }
        this.replaceStateManager(pc, this);
        this.replaceStateManager(this.myPC, null);
        this.myPC = pc;
        this.myEC.putObjectIntoLevel1Cache(this);
    }

    @Override
    public boolean isDirty(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDirty();
    }

    @Override
    public boolean isTransactional(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isTransactional();
    }

    @Override
    public boolean isPersistent(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isPersistent();
    }

    @Override
    public boolean isNew(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isNew();
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted(this.myPC);
    }

    @Override
    public boolean isDeleted(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return false;
        }
        return this.myLC.isDeleted();
    }

    @Override
    public Object getVersion(Persistable pc) {
        if (pc == this.myPC) {
            VersionMetaData vermd;
            if (this.transactionalVersion == null && this.cmd.isVersioned() && (vermd = this.cmd.getVersionMetaDataForClass()) != null && vermd.getStrategy() != VersionStrategy.NONE && (this.myLC.stateType() == 2 || this.myLC.stateType() == 4)) {
                if (vermd.getMemberName() != null) {
                    this.loadFieldFromDatastore(this.cmd.getMetaDataForMember(vermd.getMemberName()).getAbsoluteFieldNumber());
                } else {
                    this.loadFieldsFromDatastore(new int[0]);
                }
            }
            return this.transactionalVersion;
        }
        return null;
    }

    @Override
    public boolean isVersionLoaded() {
        if (this.cmd.isVersioned()) {
            return this.transactionalVersion != null;
        }
        return true;
    }

    @Override
    public Object getVersion() {
        return this.getVersion(this.myPC);
    }

    @Override
    public Object getTransactionalVersion() {
        return this.getTransactionalVersion(this.myPC);
    }

    @Override
    public void clearFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
        }
        finally {
            this.clearFieldsByNumbers(this.cmd.getAllMemberPositions());
            this.clearDirtyFlags();
            if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.persistenceFlags = 1;
            this.myPC.dnReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
        }
    }

    @Override
    public void clearNonPrimaryKeyFields() {
        try {
            this.getCallbackHandler().preClear(this.myPC);
        }
        finally {
            int[] nonPKMemberPosns = this.cmd.getNonPKMemberPositions();
            int[] nonPkScoFields = ClassUtils.getFlagsSetTo(this.cmd.getSCOMutableMemberFlags(), ClassUtils.getFlagsSetTo(this.loadedFields, nonPKMemberPosns, true), true);
            if (nonPkScoFields != null) {
                this.provideFields(nonPkScoFields, new UnsetOwnerFieldManager());
            }
            this.clearFieldsByNumbers(nonPKMemberPosns);
            this.clearDirtyFlags(nonPKMemberPosns);
            if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
                ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
            }
            this.persistenceFlags = 1;
            this.myPC.dnReplaceFlags();
            this.getCallbackHandler().postClear(this.myPC);
        }
    }

    @Override
    public void clearLoadedFlags() {
        if (this.myEC.getStoreManager() instanceof ObjectReferencingStoreManager) {
            ((ObjectReferencingStoreManager)((Object)this.myEC.getStoreManager())).notifyObjectIsOutdated(this);
        }
        this.persistenceFlags = 1;
        this.myPC.dnReplaceFlags();
        ClassUtils.clearFlags(this.loadedFields);
    }

    @Override
    public byte replacingFlags(Persistable pc) {
        if (pc != this.myPC) {
            return 0;
        }
        return this.persistenceFlags;
    }

    @Override
    public Object provideField(int fieldNumber) {
        return this.provideField(this.myPC, fieldNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object provideField(Persistable pc, int fieldNumber) {
        Object obj;
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                pc.dnProvideField(fieldNumber);
                obj = this.currFM.fetchObjectField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provideFields(int[] fieldNumbers, FieldManager fm) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                this.myPC.dnProvideFields(fieldNumbers);
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    @Override
    public void setBooleanField(Persistable pc, int fieldNumber, boolean currentValue, boolean newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue ? Boolean.TRUE : Boolean.FALSE, true);
        }
    }

    @Override
    public void setByteField(Persistable pc, int fieldNumber, byte currentValue, byte newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setCharField(Persistable pc, int fieldNumber, char currentValue, char newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, Character.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, Character.valueOf(currentValue));
                }
                this.updateField(pc, fieldNumber, Character.valueOf(newValue));
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, Character.valueOf(newValue), true);
        }
    }

    @Override
    public void setDoubleField(Persistable pc, int fieldNumber, double currentValue, double newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setFloatField(Persistable pc, int fieldNumber, float currentValue, float newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, Float.valueOf(newValue), true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, Float.valueOf(currentValue));
                }
                this.updateField(pc, fieldNumber, Float.valueOf(newValue));
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, Float.valueOf(newValue), true);
        }
    }

    @Override
    public void setIntField(Persistable pc, int fieldNumber, int currentValue, int newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setLongField(Persistable pc, int fieldNumber, long currentValue, long newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setShortField(Persistable pc, int fieldNumber, short currentValue, short newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || currentValue != newValue) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setStringField(Persistable pc, int fieldNumber, String currentValue, String newValue) {
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            if (!this.loadedFields[fieldNumber] || !(currentValue != null ? currentValue.equals(newValue) : newValue == null)) {
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, currentValue);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (!this.myEC.getTransaction().isActive()) {
                    this.myEC.processNontransactionalUpdate();
                }
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    @Override
    public void setObjectField(Persistable pc, int fieldNumber, Object currentValue, Object newValue) {
        DNStateManager currentSM;
        if (currentValue != null && currentValue != newValue && currentValue instanceof Persistable && (currentSM = this.myEC.findStateManager(currentValue)) != null && currentSM.isEmbedded()) {
            this.myEC.removeEmbeddedOwnerRelation(this, fieldNumber, currentSM);
        }
        if (pc != this.myPC) {
            this.replaceField(pc, fieldNumber, newValue, true);
            this.disconnectClone(pc);
        } else if (this.myLC != null) {
            if (this.cmd.isVersioned() && this.transactionalVersion == null) {
                this.loadUnloadedFieldsInFetchPlanAndVersion();
            }
            boolean loadedOldValue = false;
            Object oldValue = currentValue;
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            ClassLoaderResolver clr = this.myEC.getClassLoaderResolver();
            RelationType relationType = mmd.getRelationType(clr);
            this.myEC.removeObjectFromLevel2Cache(this.myID);
            if (!this.loadedFields[fieldNumber] && currentValue == null) {
                if (this.myEC.getManageRelations() && (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI)) {
                    this.loadField(fieldNumber);
                    loadedOldValue = true;
                    oldValue = this.provideField(fieldNumber);
                } else if (relationType != RelationType.NONE && newValue == null && (mmd.isDependent() || mmd.isCascadeRemoveOrphans())) {
                    this.loadField(fieldNumber);
                    loadedOldValue = true;
                    oldValue = this.provideField(fieldNumber);
                } else if (this.cmd.getSCOContainerMemberFlags()[fieldNumber] && !mmd.isSerialized()) {
                    this.loadField(fieldNumber);
                    oldValue = this.provideField(fieldNumber);
                }
            }
            boolean equal = false;
            boolean equalButContainerRefChanged = false;
            if (oldValue == null && newValue == null) {
                equal = true;
            } else if (oldValue != null && newValue != null) {
                if (RelationType.isRelationSingleValued(relationType)) {
                    if (oldValue == newValue) {
                        equal = true;
                    }
                } else if (oldValue.equals(newValue)) {
                    equal = true;
                    if (oldValue instanceof SCOContainer && ((SCOContainer)oldValue).getValue() != newValue && !(newValue instanceof SCO)) {
                        equalButContainerRefChanged = true;
                    }
                }
            }
            boolean needsSCOUpdating = false;
            if (!this.loadedFields[fieldNumber] || !equal || equalButContainerRefChanged || mmd.hasArray()) {
                SCO sco;
                Object owner;
                String key;
                if (this.cmd.getIdentityType() == IdentityType.NONDURABLE && relationType == RelationType.NONE && !this.containsAssociatedValue(key = "FIELD_VALUE.ORIGINAL." + fieldNumber)) {
                    this.setAssociatedValue(key, oldValue);
                }
                if (oldValue instanceof SCO) {
                    if (oldValue instanceof SCOContainer) {
                        ((SCOContainer)oldValue).load();
                    }
                    if (!equalButContainerRefChanged) {
                        ((SCO)oldValue).unsetOwner();
                    }
                }
                if (newValue instanceof SCO && (owner = (sco = (SCO)newValue).getOwner()) != null) {
                    throw this.myEC.getApiAdapter().getUserExceptionForException(Localiser.msg("026007", sco.getFieldName(), owner), null);
                }
                this.updateField(pc, fieldNumber, newValue);
                if (this.cmd.getSCOMutableMemberFlags()[fieldNumber] && !(newValue instanceof SCO)) {
                    needsSCOUpdating = true;
                }
            } else if (loadedOldValue) {
                this.updateField(pc, fieldNumber, newValue);
            }
            if (!equal) {
                if (RelationType.isBidirectional(relationType) && this.myEC.getManageRelations()) {
                    this.myEC.getRelationshipManager(this).relationChange(fieldNumber, oldValue, newValue);
                }
                if (this.myEC.operationQueueIsActive()) {
                    this.myEC.addOperationToQueue(new UpdateMemberOperation(this, fieldNumber, newValue, oldValue));
                }
            } else if (equalButContainerRefChanged) {
                ((SCOContainer)oldValue).setValue(newValue);
                newValue = oldValue;
                needsSCOUpdating = false;
                this.replaceField(fieldNumber, oldValue);
            }
            if (needsSCOUpdating) {
                newValue = SCOUtils.wrapAndReplaceSCOField(this, fieldNumber, newValue, oldValue, true);
            }
            if (oldValue != null && newValue == null && RelationType.isRelationSingleValued(relationType) && (mmd.isDependent() || mmd.isCascadeRemoveOrphans()) && this.myEC.getApiAdapter().isPersistent(oldValue)) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026026", oldValue, mmd.getFullFieldName()));
                this.myEC.deleteObjectInternal(oldValue);
            }
            if (!this.myEC.getTransaction().isActive()) {
                this.myEC.processNontransactionalUpdate();
            }
        } else {
            this.replaceField(pc, fieldNumber, newValue, true);
        }
    }

    protected void updateField(Persistable pc, int fieldNumber, Object value) {
        boolean wasDirty = this.dirty;
        if ((this.flags & 0x400000) == 0 && (this.flags & 0x200000) == 0) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[fieldNumber] = true;
            this.loadedFields[fieldNumber] = true;
        }
        this.replaceField(pc, fieldNumber, value, true);
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (!((this.flags & 0x400000) != 0 || (this.flags & 0x200000) != 0 || this.isFlushing() || this.myLC.isTransactional() && !this.myLC.isPersistent())) {
            this.myEC.markDirty(this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceField(Persistable pc, int fieldNumber, Object value) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = new SingleValueFieldManager();
            try {
                this.currFM.storeObjectField(fieldNumber, value);
                pc.dnReplaceField(fieldNumber);
            }
            finally {
                this.currFM = prevFM;
            }
            if (this.containsAssociatedValue("MEMBER_VALUE.STORED." + fieldNumber)) {
                this.removeAssociatedValue("MEMBER_VALUE.STORED." + fieldNumber);
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    protected boolean disconnectClone(Persistable pc) {
        if (this.isDetaching()) {
            return false;
        }
        if (pc != this.myPC) {
            NucleusLogger.PERSISTENCE.warn("StateManager.disconnectClone : Please let developers know how you got this - myPC=" + StringUtils.toJVMIDString(this.myPC) + " other=" + StringUtils.toJVMIDString(pc), new Exception());
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026001", StringUtils.toJVMIDString(pc), this));
            }
            pc.dnReplaceFlags();
            this.replaceStateManager(pc, null);
            return true;
        }
        return false;
    }

    @Override
    public void retrieveDetachState(DNStateManager sm) {
        if (sm.getObject() instanceof Detachable) {
            ((StateManagerImpl)sm).flags |= 0x80;
            ((Detachable)sm.getObject()).dnReplaceDetachedState();
            ((StateManagerImpl)sm).flags &= 0xFFFFFF7F;
        }
    }

    @Override
    public void resetDetachState() {
        if (this.getObject() instanceof Detachable) {
            this.flags |= 0x40;
            try {
                ((Detachable)((Object)this.getObject())).dnReplaceDetachedState();
            }
            finally {
                this.flags &= 0xFFFFFFBF;
            }
        }
    }

    @Override
    public Object[] replacingDetachedState(Detachable pc, Object[] currentState) {
        if ((this.flags & 0x40) != 0) {
            return null;
        }
        if ((this.flags & 0x80) != 0) {
            BitSet theLoadedFields = (BitSet)currentState[2];
            for (int i = 0; i < this.loadedFields.length; ++i) {
                this.loadedFields[i] = theLoadedFields.get(i);
            }
            BitSet theModifiedFields = (BitSet)currentState[3];
            for (int i = 0; i < this.dirtyFields.length; ++i) {
                this.dirtyFields[i] = theModifiedFields.get(i);
            }
            this.setVersion(currentState[1]);
            return currentState;
        }
        Object[] state = new Object[4];
        state[0] = this.myID;
        state[1] = this.getVersion(this.myPC);
        BitSet loadedState = new BitSet();
        for (int i = 0; i < this.loadedFields.length; ++i) {
            if (this.loadedFields[i]) {
                loadedState.set(i);
                continue;
            }
            loadedState.clear(i);
        }
        state[2] = loadedState;
        BitSet modifiedState = new BitSet();
        for (int i = 0; i < this.dirtyFields.length; ++i) {
            if (this.dirtyFields[i]) {
                modifiedState.set(i);
                continue;
            }
            modifiedState.clear(i);
        }
        state[3] = modifiedState;
        return state;
    }

    @Override
    public void makeDirty(int fieldNumber) {
        if ((this.flags & 0x100000) == 0) {
            ExecutionContext.EmbeddedOwnerRelation embeddedRel;
            boolean wasDirty = this.preWriteField(fieldNumber);
            this.postWriteField(wasDirty);
            if (this.isEmbedded() && (embeddedRel = this.myEC.getOwnerInformationForEmbedded(this)) != null) {
                StateManagerImpl ownerSM = (StateManagerImpl)embeddedRel.getOwnerSM();
                if ((ownerSM.flags & 0x100) == 0) {
                    ownerSM.makeDirty(embeddedRel.getOwnerMemberNum());
                }
            }
        }
    }

    @Override
    public void makeDirty(Persistable pc, String fieldName) {
        if (!this.disconnectClone(pc)) {
            int fieldNumber = this.cmd.getAbsolutePositionOfMember(fieldName);
            if (fieldNumber == -1) {
                throw this.myEC.getApiAdapter().getUserExceptionForException(Localiser.msg("026002", fieldName, this.cmd.getFullClassName()), null);
            }
            this.makeDirty(fieldNumber);
        }
    }

    @Override
    public Object getInternalObjectId() {
        if (this.myID != null) {
            return this.myID;
        }
        if (this.myInternalID == null) {
            this.myInternalID = new IdentityReference(this.myPC);
        }
        return this.myInternalID;
    }

    @Override
    public Object getObjectId(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return null;
        }
        try {
            return this.getExternalObjectId();
        }
        catch (NucleusException ne) {
            throw this.myEC.getApiAdapter().getApiExceptionForNucleusException(ne);
        }
    }

    @Override
    public Object getTransactionalObjectId(Persistable pc) {
        return this.getObjectId(pc);
    }

    @Override
    public Object getExternalObjectId() {
        block5: {
            block4: {
                if (this.myID != null) {
                    return this.myID;
                }
                if (this.isEmbedded()) {
                    return null;
                }
                if (this.cmd.getIdentityType() != IdentityType.DATASTORE) break block4;
                if (this.isFlushing() || this.isFlushedNew() || (this.flags & 0x400000) != 0 || (this.flags & 0x200000) != 0 || this.myLC.stateType() != 1 || !this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, -1)) break block5;
                this.flush();
                break block5;
            }
            if (this.cmd.getIdentityType() == IdentityType.APPLICATION && !this.isFlushing() && !this.isFlushedNew() && (this.flags & 0x400000) == 0 && (this.flags & 0x200000) == 0 && this.myLC.stateType() == 1) {
                int[] pkMemberNumbers = this.cmd.getPKMemberPositions();
                for (int i = 0; i < pkMemberNumbers.length; ++i) {
                    if (!this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, pkMemberNumbers[i])) continue;
                    this.flush();
                    break;
                }
            }
        }
        return this.myID;
    }

    private void setIdentity(boolean afterPreStore) {
        if (this.isEmbedded()) {
            return;
        }
        boolean idSet = false;
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            if (this.cmd.getDatastoreIdentityMetaData() == null || !this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, -1)) {
                this.myID = this.myEC.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
                idSet = true;
            }
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            boolean idSetInDatastore = false;
            int[] pkMemberNumbers = this.cmd.getPKMemberPositions();
            for (int i = 0; i < pkMemberNumbers.length; ++i) {
                int pkMemberNumber = pkMemberNumbers[i];
                AbstractMemberMetaData pkMmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkMemberNumber);
                if (this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, pkMemberNumber)) {
                    idSetInDatastore = true;
                    break;
                }
                if (pkMemberNumbers.length != 1 || !afterPreStore) continue;
                try {
                    if (this.provideField(pkMemberNumber) != null) continue;
                    throw new NucleusUserException(Localiser.msg("026017", this.cmd.getFullClassName(), pkMmd.getName())).setFatal();
                }
                catch (Exception e) {
                    return;
                }
            }
            if (!idSetInDatastore) {
                this.myID = this.myEC.newObjectId(this.cmd.getFullClassName(), (Object)this.myPC);
                idSet = true;
            }
        }
        if (this.myInternalID != this.myID && this.myID != null && (idSet || this.myEC.getApiAdapter().getIdForObject(this.myPC) != null)) {
            this.myEC.replaceObjectId(this.myPC, this.myInternalID, this.myID);
            this.myInternalID = this.myID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPostStoreNewObjectId(Object id) {
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            this.myID = IdentityUtils.isDatastoreIdentity(id) ? id : this.myEC.getNucleusContext().getIdentityManager().getDatastoreId(this.cmd.getFullClassName(), id);
        } else if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.myID = null;
                int[] pkMemberNumbers = this.cmd.getPKMemberPositions();
                for (int i = 0; i < pkMemberNumbers.length; ++i) {
                    AbstractMemberMetaData pkMmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkMemberNumbers[i]);
                    if (!pkMmd.isPrimaryKey() || !this.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, pkMemberNumbers[i])) continue;
                    this.replaceField(this.myPC, pkMemberNumbers[i], TypeConversionHelper.convertTo(id, pkMmd.getType()), false);
                }
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.error(e);
            }
            finally {
                this.myID = this.myEC.getNucleusContext().getIdentityManager().getApplicationId(this.getObject(), this.cmd);
            }
        }
        if (this.myInternalID != this.myID && this.myID != null) {
            this.myEC.replaceObjectId(this.myPC, this.myInternalID, this.myID);
            this.myInternalID = this.myID;
        }
    }

    @Override
    public void loadFieldValues(FieldValues fv) {
        FetchPlanForClass origFetchPlan = this.myFP;
        FetchPlan loadFetchPlan = fv.getFetchPlanForLoading();
        if (loadFetchPlan != null) {
            this.myFP = loadFetchPlan.getFetchPlanForClass(this.cmd);
        }
        boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
        if (this.loadedFields.length == 0) {
            callPostLoad = true;
        }
        fv.fetchFields(this);
        if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.postLoad();
        }
        this.myFP = origFetchPlan;
    }

    protected void loadSpecifiedFields(int[] fieldNumbers) {
        if (this.myEC.getApiAdapter().isDetached(this.myPC)) {
            return;
        }
        int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
        if (unloadedFieldNumbers != null && !this.isEmbedded()) {
            this.loadFieldsFromDatastore(unloadedFieldNumbers);
            this.updateLevel2CacheForFields(unloadedFieldNumbers);
        }
    }

    @Override
    public void loadField(int fieldNumber) {
        if (this.loadedFields[fieldNumber]) {
            return;
        }
        this.loadSpecifiedFields(new int[]{fieldNumber});
    }

    @Override
    public boolean loadStoredField(int fieldNumber) {
        String assocValueKey = "MEMBER_VALUE.STORED." + fieldNumber;
        boolean hasStored = this.containsAssociatedValue(assocValueKey);
        if (hasStored) {
            AbstractMemberMetaData mmd;
            DNStateManager memberSM;
            Object memberValue = this.getAssociatedValue(assocValueKey);
            Persistable member = this.myEC.findObject(memberValue, false);
            DNStateManager dNStateManager = memberSM = member != null ? this.myEC.findStateManager(member) : null;
            if (memberSM != null && !memberSM.isDeleted() && (mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getType().isAssignableFrom(member.getClass())) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("026038", mmd.getName(), this));
                }
                this.replaceField(this.myPC, fieldNumber, member);
            }
            this.removeAssociatedValue(assocValueKey);
            this.updateLevel2CacheForFields(new int[]{fieldNumber});
        }
        return hasStored;
    }

    @Override
    public void loadUnloadedRelationFields() {
        int[] fieldsConsidered = this.cmd.getRelationMemberPositions(this.myEC.getClassLoaderResolver());
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, fieldsConsidered, false);
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        if (this.preDeleteLoadedFields != null && (this.myLC.isDeleted() && this.myEC.isFlushing() || (this.flags & 0x100000) != 0)) {
            fieldNumbers = ClassUtils.getFlagsSetTo(this.preDeleteLoadedFields, fieldNumbers, false);
        }
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
            }
            int[] secondClassMutableFieldNumbers = this.cmd.getSCOMutableMemberPositions();
            for (int i = 0; i < secondClassMutableFieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(secondClassMutableFieldNumbers[i]);
                if (mmd.getRelationType(this.myEC.getClassLoaderResolver()) == RelationType.NONE) continue;
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
    }

    @Override
    public void loadUnloadedFields() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), false);
        if (fieldNumbers == null || fieldNumbers.length == 0) {
            return;
        }
        if (this.preDeleteLoadedFields != null && (this.myLC.isDeleted() && this.myEC.isFlushing() || (this.flags & 0x100000) != 0)) {
            fieldNumbers = ClassUtils.getFlagsSetTo(this.preDeleteLoadedFields, fieldNumbers, false);
        }
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
            }
            int[] secondClassMutableFieldNumbers = this.cmd.getSCOMutableMemberPositions();
            for (int i = 0; i < secondClassMutableFieldNumbers.length; ++i) {
                SingleValueFieldManager sfv = new SingleValueFieldManager();
                this.provideFields(new int[]{secondClassMutableFieldNumbers[i]}, sfv);
                Object value = sfv.fetchObjectField(i);
                if (!(value instanceof SCOContainer)) continue;
                ((SCOContainer)value).load();
            }
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
    }

    @Override
    public void loadUnloadedFieldsInFetchPlan() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
    }

    protected void loadUnloadedFieldsInFetchPlanAndVersion() {
        if (!this.cmd.isVersioned()) {
            this.loadUnloadedFieldsInFetchPlan();
        } else {
            int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
            if (fieldNumbers == null) {
                fieldNumbers = new int[]{};
            }
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad && fieldNumbers.length > 0 && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
    }

    @Override
    public void loadUnloadedFieldsOfClassInFetchPlan(FetchPlan fetchPlan) {
        FetchPlanForClass fpc = fetchPlan.getFetchPlanForClass(this.cmd);
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, fpc.getMemberNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            boolean callPostLoad = fpc.isToCallPostLoadFetchPlan(this.loadedFields);
            int[] unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers);
            if (unloadedFieldNumbers != null) {
                this.loadFieldsFromDatastore(unloadedFieldNumbers);
                this.updateLevel2CacheForFields(unloadedFieldNumbers);
            }
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
    }

    @Override
    public void refreshFieldsInFetchPlan() {
        int[] fieldNumbers = this.myFP.getMemberNumbers();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags(fieldNumbers);
            ClassUtils.clearFlags(this.loadedFields, fieldNumbers);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.setTransactionalVersion(null);
            this.loadFieldsFromDatastore(fieldNumbers);
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver())) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    Object value;
                    AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                    RelationType relationType = fmd.getRelationType(this.myEC.getClassLoaderResolver());
                    if (relationType == RelationType.NONE || !fmd.isCascadeRefresh() || (value = this.provideField(fieldNumbers[i])) == null) continue;
                    if (fmd.hasContainer()) {
                        ApiAdapter api = this.getExecutionContext().getApiAdapter();
                        Object containerHandler = this.myEC.getTypeManager().getContainerHandler(fmd.getType());
                        for (Object object : containerHandler.getAdapter((Object)value)) {
                            if (!api.isPersistable(object)) continue;
                            this.getExecutionContext().refreshObject(object);
                        }
                        continue;
                    }
                    if (!(value instanceof Persistable)) continue;
                    this.myEC.refreshObject(value);
                }
            }
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
            this.getCallbackHandler().postRefresh(this.myPC);
        }
    }

    @Override
    public void refreshLoadedFields() {
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), true);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            this.clearDirtyFlags();
            ClassUtils.clearFlags(this.loadedFields);
            this.markPKFieldsAsLoaded();
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            this.loadFieldsFromDatastore(fieldNumbers);
            this.updateLevel2CacheForFields(fieldNumbers);
            if (callPostLoad) {
                this.postLoad();
            }
        }
    }

    @Override
    public boolean isLoaded(int fieldNumber) {
        return this.isLoaded(this.myPC, fieldNumber);
    }

    @Override
    public boolean isLoaded(Persistable pc, int fieldNumber) {
        try {
            if (this.disconnectClone(pc)) {
                return true;
            }
            boolean checkRead = true;
            boolean beingDeleted = false;
            if (this.myLC.isDeleted() && this.myEC.isFlushing() || (this.flags & 0x100000) != 0) {
                checkRead = false;
                beingDeleted = true;
            }
            if (checkRead) {
                this.transitionReadField(this.loadedFields[fieldNumber]);
            }
            if (!this.loadedFields[fieldNumber]) {
                if (this.isEmbedded()) {
                    return true;
                }
                if (beingDeleted && this.preDeleteLoadedFields != null && this.preDeleteLoadedFields[fieldNumber]) {
                    return true;
                }
                if (!beingDeleted && this.myFP.hasMember(fieldNumber)) {
                    if (!this.loadStoredField(fieldNumber)) {
                        this.loadUnloadedFieldsInFetchPlan();
                        if (!this.loadedFields[fieldNumber]) {
                            this.loadStoredField(fieldNumber);
                        }
                    }
                } else if (!this.loadStoredField(fieldNumber)) {
                    this.loadSpecifiedFields(new int[]{fieldNumber});
                    if (!this.loadedFields[fieldNumber]) {
                        this.loadStoredField(fieldNumber);
                    }
                }
            }
            return true;
        }
        catch (NucleusException ne) {
            NucleusLogger.PERSISTENCE.warn("Exception thrown by StateManager.isLoaded for field=" + fieldNumber + " of " + this + " : " + StringUtils.getMessageFromRootCauseOfThrowable(ne));
            throw this.myEC.getApiAdapter().getApiExceptionForNucleusException(ne);
        }
    }

    @Override
    public void replaceFieldValue(int fieldNumber, Object newValue) {
        if (this.myLC.isDeleted()) {
            return;
        }
        boolean currentWasDirty = this.preWriteField(fieldNumber);
        this.replaceField(this.myPC, fieldNumber, newValue, true);
        this.postWriteField(currentWasDirty);
    }

    @Override
    public void replaceField(int fieldNumber, Object value) {
        this.replaceField(this.myPC, fieldNumber, value, false);
    }

    @Override
    public void replaceFieldMakeDirty(int fieldNumber, Object value) {
        this.replaceField(this.myPC, fieldNumber, value, true);
    }

    protected void replaceField(Persistable pc, int fieldNumber, Object value, boolean makeDirty) {
        if (this.isEmbedded()) {
            ExecutionContext.EmbeddedOwnerRelation ownerRel = this.myEC.getOwnerInformationForEmbedded(this);
            if (ownerRel != null) {
                Object ownerField;
                StateManagerImpl ownerSM = (StateManagerImpl)ownerRel.getOwnerSM();
                AbstractMemberMetaData ownerMmd = ownerSM.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(ownerRel.getOwnerMemberNum());
                if (ownerMmd.getCollection() != null) {
                    Object ownerField2 = ownerSM.provideField(ownerRel.getOwnerMemberNum());
                    if (ownerField2 instanceof SCOCollection) {
                        ((SCOCollection)ownerField2).updateEmbeddedElement(this.myPC, fieldNumber, value, makeDirty);
                    }
                } else if (ownerMmd.getMap() != null && (ownerField = ownerSM.provideField(ownerRel.getOwnerMemberNum())) instanceof SCOMap) {
                    if (ownerRel.getObjectType() == PersistableObjectType.EMBEDDED_MAP_KEY_PC) {
                        ((SCOMap)ownerField).updateEmbeddedKey(this.myPC, fieldNumber, value, makeDirty);
                    }
                    if (ownerRel.getObjectType() == PersistableObjectType.EMBEDDED_MAP_VALUE_PC) {
                        ((SCOMap)ownerField).updateEmbeddedValue(this.myPC, fieldNumber, value, makeDirty);
                    }
                }
                if ((ownerSM.flags & 0x100) == 0 && makeDirty) {
                    ownerSM.makeDirty(ownerRel.getOwnerMemberNum());
                }
            }
            this.replaceField(pc, fieldNumber, value);
        } else if (makeDirty && !this.myLC.isDeleted() && this.myEC.getTransaction().isActive()) {
            boolean wasDirty = this.preWriteField(fieldNumber);
            this.replaceField(pc, fieldNumber, value);
            this.postWriteField(wasDirty);
        } else {
            this.replaceField(pc, fieldNumber, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean replaceWhenDirty) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            try {
                int[] fieldsToReplace = fieldNumbers;
                if (!replaceWhenDirty) {
                    int numberToReplace = fieldNumbers.length;
                    for (int i = 0; i < fieldNumbers.length; ++i) {
                        if (!this.dirtyFields[fieldNumbers[i]]) continue;
                        --numberToReplace;
                    }
                    if (numberToReplace > 0 && numberToReplace != fieldNumbers.length) {
                        fieldsToReplace = new int[numberToReplace];
                        int n = 0;
                        for (int i = 0; i < fieldNumbers.length; ++i) {
                            if (this.dirtyFields[fieldNumbers[i]]) continue;
                            fieldsToReplace[n++] = fieldNumbers[i];
                        }
                    } else if (numberToReplace == 0) {
                        fieldsToReplace = null;
                    }
                }
                if (fieldsToReplace != null) {
                    this.myPC.dnReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    @Override
    public void replaceFields(int[] fieldNumbers, FieldManager fm) {
        this.replaceFields(fieldNumbers, fm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm) {
        try {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadLock();
            }
            FieldManager prevFM = this.currFM;
            this.currFM = fm;
            boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
            try {
                int[] fieldsToReplace = ClassUtils.getFlagsSetTo(this.loadedFields, fieldNumbers, false);
                if (fieldsToReplace != null && fieldsToReplace.length > 0) {
                    this.myPC.dnReplaceFields(fieldsToReplace);
                }
            }
            finally {
                this.currFM = prevFM;
            }
            if (callPostLoad && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
                this.postLoad();
            }
        }
        finally {
            if (this.myEC.getMultithreaded()) {
                this.myEC.threadUnlock();
            }
        }
    }

    @Override
    public void replaceAllLoadedSCOFieldsWithWrappers() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || (value = this.provideField(i)) instanceof SCO) continue;
            SCOUtils.wrapSCOField(this, i, value, true);
        }
    }

    @Override
    public void replaceAllLoadedSCOFieldsWithValues() {
        boolean[] scoMutableFieldFlags = this.cmd.getSCOMutableMemberFlags();
        for (int i = 0; i < scoMutableFieldFlags.length; ++i) {
            Object value;
            if (!scoMutableFieldFlags[i] || !this.loadedFields[i] || !((value = this.provideField(i)) instanceof SCO)) continue;
            SCOUtils.unwrapSCOField(this, i, (SCO)value);
        }
    }

    @Override
    public void updateOwnerFieldInEmbeddedField(int fieldNumber, Object value) {
        DNStateManager subSM;
        int ownerAbsFieldNum;
        AbstractMemberMetaData mmd;
        RelationType relationType;
        if (value != null && RelationType.isRelationSingleValued(relationType = (mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber)).getRelationType(this.myEC.getClassLoaderResolver())) && mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getOwnerMember() != null && (ownerAbsFieldNum = (subSM = this.myEC.findStateManager(value)).getClassMetaData().getAbsolutePositionOfMember(mmd.getEmbeddedMetaData().getOwnerMember())) >= 0) {
            this.flags |= 0x100;
            subSM.replaceFieldMakeDirty(ownerAbsFieldNum, this.myPC);
            this.flags &= 0xFFFFFEFF;
        }
    }

    @Override
    public void makePersistent() {
        if (this.myLC.isDeleted() && !this.myEC.getNucleusContext().getApiAdapter().allowPersistOfDeletedObject()) {
            return;
        }
        if ((this.flags & 0x400000) != 0 || (this.flags & 0x200000) != 0) {
            return;
        }
        if (this.myEC.operationQueueIsActive()) {
            this.myEC.addOperationToQueue(new PersistOperation(this));
        }
        if (this.dirty && !this.myLC.isDeleted() && this.myLC.isTransactional() && this.myEC.isDelayDatastoreOperationsEnabled()) {
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver())) {
                this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            }
            return;
        }
        this.getCallbackHandler().prePersist(this.myPC);
        if (this.isFlushedNew()) {
            this.registerTransactional();
            return;
        }
        if (this.isEmbedded()) {
            return;
        }
        if (this.myID == null) {
            this.setIdentity(false);
        }
        this.dirty = true;
        if (this.myEC.isDelayDatastoreOperationsEnabled()) {
            this.myEC.markDirty(this, false);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026028", StringUtils.toJVMIDString(this.myPC)));
            }
            this.registerTransactional();
            if (this.myLC.isTransactional() && this.myLC.isDeleted()) {
                this.myLC = this.myLC.transitionMakePersistent(this);
            }
            if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver())) {
                this.provideFields(this.cmd.getAllMemberPositions(), new PersistFieldManager(this, false));
            }
        } else {
            this.internalMakePersistent();
            this.registerTransactional();
        }
    }

    private void internalMakePersistent() {
        this.flags |= 0x400000;
        boolean[] tmpDirtyFields = (boolean[])this.dirtyFields.clone();
        try {
            this.getCallbackHandler().preStore(this.myPC);
            if (this.myID == null) {
                this.setIdentity(true);
            }
            this.clearDirtyFlags();
            this.getStoreManager().getPersistenceHandler().insertObject(this);
            this.setFlushedNew(true);
            this.getCallbackHandler().postStore(this.myPC);
        }
        catch (NotYetFlushedException ex) {
            this.dirtyFields = tmpDirtyFields;
            this.myEC.markDirty(this, false);
            this.dirty = true;
            throw ex;
        }
        finally {
            this.flags &= 0xFFBFFFFF;
            this.flags &= 0xFFDFFFFF;
        }
    }

    @Override
    public void makeTransactional() {
        block8: {
            this.preStateChange();
            try {
                if (this.myLC == null) {
                    StateManagerImpl thisSM = this;
                    this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(5);
                    try {
                        this.replaceStateManager(this.myPC, thisSM);
                    }
                    catch (SecurityException e) {
                        throw new NucleusUserException(e.getMessage());
                    }
                    catch (NucleusException ne) {
                        if (this.myEC.findStateManager(this.myEC.getObjectFromCache(this.myID)) == this) {
                            this.myEC.removeStateManagerFromCache(this);
                        }
                        throw ne;
                    }
                    this.flags |= 0x20000;
                    break block8;
                }
                this.myLC = this.myLC.transitionMakeTransactional(this, true);
            }
            finally {
                this.postStateChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeTransient(FetchPlanState state) {
        if ((this.flags & 8) != 0) {
            return;
        }
        try {
            this.flags |= 8;
            if (state == null) {
                int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getSCOMutableMemberPositions(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.provideFields(fieldNumbers, new UnsetOwnerFieldManager());
                }
            } else {
                this.loadUnloadedFieldsInFetchPlan();
                int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), true);
                if (fieldNumbers != null && fieldNumbers.length > 0) {
                    this.replaceFields(fieldNumbers, new MakeTransientFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state));
                }
            }
            this.preStateChange();
            try {
                this.myLC = this.myLC.transitionMakeTransient(this, state != null, this.myEC.isRunningDetachAllOnCommit());
            }
            finally {
                this.postStateChange();
            }
        }
        finally {
            this.flags &= 0xFFFFFFF7;
        }
    }

    @Override
    public void makeTransientForReachability() {
        this.getCallbackHandler().preDelete(this.myPC);
        this.internalDeletePersistent();
        this.getCallbackHandler().postDelete(this.myPC);
        this.dirty = true;
        this.preStateChange();
        try {
            this.myLC = this.myLC.transitionMakeTransient(this, false, true);
        }
        finally {
            this.postStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(FetchPlanState state) {
        if (this.myEC == null) {
            return;
        }
        ApiAdapter api = this.myEC.getApiAdapter();
        if (this.myLC.isDeleted() || api.isDetached(this.myPC) || this.isDetaching()) {
            return;
        }
        boolean detachable = api.isDetachable(this.myPC);
        if (detachable) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("010009", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth()));
            }
            this.getCallbackHandler().preDetach(this.myPC);
        }
        try {
            this.setDetaching(true);
            String detachedState = this.myEC.getNucleusContext().getConfiguration().getStringProperty(PropertyNames.PROPERTY_DETACH_DETACHED_STATE).toLowerCase();
            if (detachedState.equals("all")) {
                this.loadUnloadedFields();
            } else if (!detachedState.equals("loaded")) {
                if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if ((this.myEC.getFetchPlan().getDetachmentOptions() & 2) != 0) {
                    this.unloadNonFetchPlanFields();
                    int[] unloadedFields = ClassUtils.getFlagsSetTo(this.loadedFields, this.cmd.getAllMemberPositions(), false);
                    if (unloadedFields != null && unloadedFields.length > 0) {
                        Persistable dummyPC = this.myPC.dnNewInstance(this);
                        this.myPC.dnCopyFields(dummyPC, unloadedFields);
                        this.replaceStateManager(dummyPC, null);
                    }
                }
            }
            DetachFieldManager detachFieldManager = new DetachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state, false);
            for (int i = 0; i < this.loadedFields.length; ++i) {
                if (!this.loadedFields[i]) continue;
                try {
                    detachFieldManager.fetchObjectField(i);
                    continue;
                }
                catch (AbstractFetchDepthFieldManager.EndOfFetchPlanGraphException eofpge) {
                    Object value = this.provideField(i);
                    if (!api.isPersistable(value)) continue;
                    DNStateManager valueSM = this.myEC.findStateManager(value);
                    if (api.isDetached(value) || valueSM != null && valueSM.isDetaching()) continue;
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug(Localiser.msg("026032", IdentityUtils.getPersistableIdentityForId(this.myID), this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(i).getName()));
                    }
                    this.unloadField(i);
                }
            }
            if (detachable) {
                this.myLC = this.myLC.transitionDetach(this);
                this.myPC.dnReplaceFlags();
                ((Detachable)((Object)this.myPC)).dnReplaceDetachedState();
                this.getCallbackHandler().postDetach(this.myPC, this.myPC);
                Persistable toCheckPC = this.myPC;
                Object toCheckID = this.myID;
                this.disconnect();
                if (!toCheckPC.dnIsDetached()) {
                    throw new NucleusUserException(Localiser.msg("026025", toCheckPC.getClass().getName(), toCheckID));
                }
            } else {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("026031", IdentityUtils.getPersistableIdentityForId(this.myID)));
                this.makeTransient(null);
            }
        }
        finally {
            this.setDetaching(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistable detachCopy(FetchPlanState state) {
        Persistable referencedPC;
        Persistable detachedPC;
        if (this.myLC.isDeleted()) {
            throw new NucleusUserException(Localiser.msg("026023", this.myPC.getClass().getName(), this.myID));
        }
        if (this.myEC.getApiAdapter().isDetached(this.myPC)) {
            throw new NucleusUserException(Localiser.msg("026024", this.myPC.getClass().getName(), this.myID));
        }
        if (this.dirty) {
            this.myEC.flushInternal(false);
        }
        if (this.isDetaching()) {
            return this.getReferencedPC();
        }
        DetachState detachState = (DetachState)state;
        DetachState.Entry existingDetached = detachState.getDetachedCopyEntry(this.myPC);
        if (existingDetached == null) {
            detachedPC = this.myPC.dnNewInstance(this);
            detachState.setDetachedCopyEntry(this.myPC, detachedPC);
        } else {
            detachedPC = (Persistable)existingDetached.getDetachedCopyObject();
            if (existingDetached.checkCurrentState()) {
                return detachedPC;
            }
        }
        this.myEC.setAttachDetachReferencedObject(this, detachedPC);
        boolean detachable = this.myEC.getApiAdapter().isDetachable(this.myPC);
        Persistable persistable = referencedPC = this.getReferencedPC();
        synchronized (persistable) {
            int[] detachFieldNums = this.getFieldsNumbersToDetach();
            if (detachable) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    int[] fieldsToLoad = null;
                    if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                        fieldsToLoad = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
                    }
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("010010", StringUtils.toJVMIDString(this.myPC), "" + state.getCurrentFetchDepth(), StringUtils.toJVMIDString(detachedPC), StringUtils.intArrayToString(detachFieldNums), StringUtils.intArrayToString(fieldsToLoad)));
                }
                this.getCallbackHandler().preDetach(this.myPC);
            }
            try {
                this.setDetaching(true);
                if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) != 0) {
                    this.loadUnloadedFieldsInFetchPlan();
                }
                if (this.myLC == this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4) || this.myLC == this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(9)) {
                    this.myLC = this.myLC.transitionReadField(this, true);
                }
                StateManagerImpl smDetachedPC = new StateManagerImpl(this.myEC, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(), this.getVersion(this.myPC));
                this.myEC.setAttachDetachReferencedObject(smDetachedPC, this.myPC);
                if (existingDetached != null) {
                    smDetachedPC.retrieveDetachState(smDetachedPC);
                }
                smDetachedPC.replaceFields(detachFieldNums, new DetachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.myFP, state, true));
                this.myEC.setAttachDetachReferencedObject(smDetachedPC, null);
                if (detachable) {
                    detachedPC.dnReplaceFlags();
                    ((Detachable)((Object)detachedPC)).dnReplaceDetachedState();
                } else {
                    smDetachedPC.makeTransient(null);
                }
                this.replaceStateManager(detachedPC, null);
            }
            catch (Exception e) {
                NucleusLogger.PERSISTENCE.warn("DETACH ERROR : Error thrown while detaching " + StringUtils.toJVMIDString(this.myPC) + " (id=" + this.myID + "). Provide a testcase that demonstrates this", e);
            }
            finally {
                this.setDetaching(false);
                referencedPC = null;
            }
            if (detachable && !this.myEC.getApiAdapter().isDetached(detachedPC)) {
                throw new NucleusUserException(Localiser.msg("026025", detachedPC.getClass().getName(), this.myID));
            }
            if (detachable) {
                this.getCallbackHandler().postDetach(this.myPC, detachedPC);
            }
        }
        return detachedPC;
    }

    void setDetaching(boolean flag) {
        this.flags = flag ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isDetaching() {
        return (this.flags & 0x10) != 0;
    }

    private int[] getFieldsNumbersToDetach() {
        String detachedState = this.myEC.getNucleusContext().getConfiguration().getStringProperty(PropertyNames.PROPERTY_DETACH_DETACHED_STATE).toLowerCase();
        if (detachedState.equals("all")) {
            return this.cmd.getAllMemberPositions();
        }
        if (detachedState.equals("loaded")) {
            return this.getLoadedFieldNumbers();
        }
        if ((this.myEC.getFetchPlan().getDetachmentOptions() & 2) == 0) {
            if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) == 0) {
                return this.getLoadedFieldNumbers();
            }
            int[] fieldsToDetach = this.myFP.getMemberNumbers();
            int[] allFieldNumbers = this.cmd.getAllMemberPositions();
            int[] loadedFieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, allFieldNumbers, true);
            if (loadedFieldNumbers != null && loadedFieldNumbers.length > 0) {
                int i;
                boolean[] flds = new boolean[allFieldNumbers.length];
                for (i = 0; i < fieldsToDetach.length; ++i) {
                    flds[fieldsToDetach[i]] = true;
                }
                for (i = 0; i < loadedFieldNumbers.length; ++i) {
                    flds[loadedFieldNumbers[i]] = true;
                }
                fieldsToDetach = ClassUtils.getFlagsSetTo(flds, true);
            }
            return fieldsToDetach;
        }
        if ((this.myEC.getFetchPlan().getDetachmentOptions() & 1) == 0) {
            return ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), true);
        }
        return this.myFP.getMemberNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Persistable detachedPC) {
        if (this.isAttaching()) {
            return;
        }
        this.setAttaching(true);
        try {
            this.getCallbackHandler().preAttach(this.myPC);
            StateManagerImpl detachedSM = new StateManagerImpl(this.myEC, this.cmd);
            detachedSM.initialiseForDetached(detachedPC, this.myID, (Object)null);
            this.myEC.putObjectIntoLevel1Cache(this);
            int[] nonPKFieldNumbers = this.cmd.getNonPKMemberPositions();
            if (nonPKFieldNumbers != null && nonPKFieldNumbers.length > 0) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("026035", IdentityUtils.getPersistableIdentityForId(this.getInternalObjectId()), StringUtils.intArrayToString(nonPKFieldNumbers)));
                }
                detachedSM.provideFields(nonPKFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.cmd.getNonPKMemberFlags(), true, true, false));
            }
            this.replaceStateManager(detachedPC, null);
            this.getCallbackHandler().postAttach(this.myPC, this.myPC);
        }
        finally {
            this.setAttaching(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(boolean embedded) {
        if (this.isAttaching()) {
            return;
        }
        this.setAttaching(true);
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myEC.getBooleanProperty(PropertyNames.PROPERTY_ATTACH_SAME_DATASTORE).booleanValue()) {
                try {
                    this.locate();
                    persistent = true;
                }
                catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {}
            } else {
                persistent = true;
            }
            this.getCallbackHandler().preAttach(this.myPC);
            this.replaceStateManager(this.myPC, this);
            this.retrieveDetachState(this);
            if (!persistent) {
                this.makePersistent();
            }
            this.myLC = this.myLC.transitionAttach(this);
            this.myEC.putObjectIntoLevel1Cache(this);
            int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(this.loadedFields, this.dirtyFields);
            if (attachFieldNumbers != null) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(Localiser.msg("026035", IdentityUtils.getPersistableIdentityForId(this.getInternalObjectId()), StringUtils.intArrayToString(attachFieldNumbers)));
                }
                this.provideFields(attachFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), this.dirtyFields, persistent, true, false));
            }
            this.getCallbackHandler().postAttach(this.myPC, this.myPC);
        }
        finally {
            this.setAttaching(false);
        }
    }

    @Override
    public Persistable attachCopy(Persistable detachedPC, boolean embedded) {
        if (this.isAttaching()) {
            return this.myPC;
        }
        this.setAttaching(true);
        try {
            boolean persistent = false;
            if (embedded) {
                persistent = true;
            } else if (!this.myEC.getBooleanProperty(PropertyNames.PROPERTY_ATTACH_SAME_DATASTORE).booleanValue()) {
                try {
                    this.locate();
                    persistent = true;
                }
                catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {}
            } else {
                persistent = true;
            }
            this.getCallbackHandler().preAttach(detachedPC);
            if (this.myEC.getApiAdapter().isDeleted(detachedPC)) {
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            if (!(this.myEC.getTransaction().getOptimistic() || this.myLC != this.myEC.getApiAdapter().getLifeCycleState(4) && this.myLC != this.myEC.getApiAdapter().getLifeCycleState(9))) {
                this.myLC = this.myLC.transitionMakeTransactional(this, persistent);
            }
            StateManagerImpl smDetachedPC = null;
            if (persistent) {
                int[] unloadedFieldNumbers;
                int[] noncontainerFieldNumbers = this.cmd.getSCONonContainerMemberPositions();
                int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, noncontainerFieldNumbers, false);
                if (fieldNumbers != null && fieldNumbers.length > 0 && (unloadedFieldNumbers = this.loadFieldsFromLevel2Cache(fieldNumbers)) != null) {
                    this.loadFieldsFromDatastore(unloadedFieldNumbers);
                    this.updateLevel2CacheForFields(unloadedFieldNumbers);
                }
                smDetachedPC = new StateManagerImpl(this.myEC, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(), (Object)null);
                this.myEC.setAttachDetachReferencedObject(smDetachedPC, this.myPC);
                this.myEC.setAttachDetachReferencedObject(this, detachedPC);
                this.retrieveDetachState(smDetachedPC);
            } else {
                this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(1);
                this.replaceStateManager(detachedPC, this);
                this.myPC.dnCopyFields(detachedPC, this.cmd.getAllMemberPositions());
                this.replaceStateManager(detachedPC, null);
                smDetachedPC = new StateManagerImpl(this.myEC, this.cmd);
                smDetachedPC.initialiseForDetached(detachedPC, this.getExternalObjectId(), (Object)null);
                this.myEC.setAttachDetachReferencedObject(smDetachedPC, this.myPC);
                this.myEC.setAttachDetachReferencedObject(this, detachedPC);
                this.retrieveDetachState(smDetachedPC);
                this.internalAttachCopy(smDetachedPC, smDetachedPC.getLoadedFields(), smDetachedPC.getDirtyFields(), persistent, smDetachedPC.myVersion, false);
                this.makePersistent();
            }
            this.internalAttachCopy(smDetachedPC, smDetachedPC.getLoadedFields(), smDetachedPC.getDirtyFields(), persistent, smDetachedPC.myVersion, true);
            this.replaceStateManager(detachedPC, null);
            this.myEC.setAttachDetachReferencedObject(smDetachedPC, null);
            this.myEC.setAttachDetachReferencedObject(this, null);
            this.getCallbackHandler().postAttach(this.myPC, detachedPC);
        }
        catch (NucleusException ne) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026036", IdentityUtils.getPersistableIdentityForId(this.getInternalObjectId()), ne.getMessage()), ne);
            }
            throw ne;
        }
        finally {
            this.setAttaching(false);
        }
        return this.myPC;
    }

    void setAttaching(boolean flag) {
        this.flags = flag ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public boolean isAttaching() {
        return (this.flags & 0x20) != 0;
    }

    private void internalAttachCopy(DNStateManager detachedSM, boolean[] loadedFields, boolean[] dirtyFields, boolean persistent, Object version, boolean cascade) {
        int[] attachFieldNumbers = this.getFieldNumbersOfLoadedOrDirtyFields(loadedFields, dirtyFields);
        this.setVersion(version);
        if (attachFieldNumbers != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(Localiser.msg("026035", IdentityUtils.getPersistableIdentityForId(this.getInternalObjectId()), StringUtils.intArrayToString(attachFieldNumbers)));
            }
            detachedSM.provideFields(attachFieldNumbers, new AttachFieldManager(this, this.cmd.getSCOMutableMemberFlags(), dirtyFields, persistent, cascade, true));
        }
    }

    @Override
    public void deletePersistent() {
        if (!this.myLC.isDeleted()) {
            if (this.myEC.isDelayDatastoreOperationsEnabled()) {
                if (this.myEC.operationQueueIsActive()) {
                    this.myEC.addOperationToQueue(new DeleteOperation(this));
                }
                this.getCallbackHandler().preDelete(this.myPC);
                this.myEC.markDirty(this, false);
                if (this.myLC.stateType() == 2 || this.myLC.stateType() == 3 || this.myLC.stateType() == 4 || this.myLC.stateType() == 9 || this.myLC.stateType() == 10) {
                    this.loadUnloadedRelationFields();
                }
                this.flags |= 0x200;
                if (this.cmd.hasRelations(this.myEC.getClassLoaderResolver())) {
                    this.provideFields(this.cmd.getAllMemberPositions(), new DeleteFieldManager(this));
                }
                this.dirty = true;
                this.preStateChange();
                try {
                    this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                    System.arraycopy(this.loadedFields, 0, this.preDeleteLoadedFields, 0, this.loadedFields.length);
                    this.myLC = this.myLC.transitionDeletePersistent(this);
                }
                finally {
                    this.flags &= 0xFFFFFDFF;
                    this.postStateChange();
                }
            }
            this.getCallbackHandler().preDelete(this.myPC);
            this.dirty = true;
            this.preStateChange();
            try {
                this.preDeleteLoadedFields = new boolean[this.loadedFields.length];
                System.arraycopy(this.loadedFields, 0, this.preDeleteLoadedFields, 0, this.loadedFields.length);
                this.myLC = this.myLC.transitionDeletePersistent(this);
            }
            finally {
                this.postStateChange();
            }
            this.internalDeletePersistent();
            this.getCallbackHandler().postDelete(this.myPC);
        }
    }

    @Override
    public boolean becomingDeleted() {
        return (this.flags & 0x200) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate() {
        if (this.myLC.isTransactional()) return;
        int[] fieldNumbers = ClassUtils.getFlagsSetTo(this.loadedFields, this.myFP.getMemberNumbers(), false);
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fieldNumbers = ClassUtils.getFlagsSetTo(this.cmd.getNonPKMemberFlags(), fieldNumbers, true);
        }
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fieldNumbers = ClassUtils.getFlagsSetTo(this.cmd.getSCOMutableMemberFlags(), fieldNumbers, false);
        }
        boolean versionNeedsLoading = false;
        if (this.cmd.isVersioned() && this.transactionalVersion == null) {
            versionNeedsLoading = true;
        }
        if (fieldNumbers != null && fieldNumbers.length > 0 || versionNeedsLoading) {
            if ((this.flags & 0x40000) != 0) return;
            try {
                this.flags |= 0x40000;
                this.transitionReadField(false);
                fieldNumbers = this.myFP.getMemberNumbers();
                if (fieldNumbers == null && !versionNeedsLoading) return;
                boolean callPostLoad = this.myFP.isToCallPostLoadFetchPlan(this.loadedFields);
                this.setTransactionalVersion(null);
                this.loadFieldsFromDatastore(fieldNumbers);
                if (!callPostLoad || !this.areFieldsLoaded(fieldNumbers)) return;
                this.postLoad();
                return;
            }
            finally {
                this.flags &= 0xFFFBFFFF;
            }
        } else {
            this.locate();
            this.transitionReadField(false);
        }
    }

    protected boolean preWriteField(int fieldNumber) {
        boolean wasDirty = this.dirty;
        if ((this.flags & 0x400000) == 0 && (this.flags & 0x200000) == 0) {
            if (!wasDirty) {
                this.getCallbackHandler().preDirty(this.myPC);
            }
            this.transitionWriteField();
            this.dirty = true;
            this.dirtyFields[fieldNumber] = true;
            this.loadedFields[fieldNumber] = true;
        }
        return wasDirty;
    }

    protected void postWriteField(boolean wasDirty) {
        if (this.dirty && !wasDirty) {
            this.getCallbackHandler().postDirty(this.myPC);
        }
        if (!((this.flags & 0x400000) != 0 || (this.flags & 0x200000) != 0 || this.isFlushing() || this.myLC.isTransactional() && !this.myLC.isPersistent())) {
            if (this.isDetaching() && this.getReferencedPC() == null) {
                return;
            }
            this.myEC.markDirty(this, true);
        }
    }

    protected void preStateChange() {
        this.flags |= 0x800;
    }

    protected void postStateChange() {
        this.flags &= 0xFFFFF7FF;
        if (this.isPostLoadPending() && this.areFieldsLoaded(this.myFP.getMemberNumbers())) {
            this.setPostLoadPending(false);
            this.postLoad();
        }
    }

    void setPostLoadPending(boolean flag) {
        this.flags = flag ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    protected boolean isPostLoadPending() {
        return (this.flags & 0x1000) != 0;
    }

    private void postLoad() {
        if (this.isChangingState()) {
            this.setPostLoadPending(true);
        } else {
            if (this.persistenceFlags == 1 && this.myLC.isTransactional()) {
                this.persistenceFlags = (byte)-1;
                this.myPC.dnReplaceFlags();
            }
            this.getCallbackHandler().postLoad(this.myPC);
        }
    }

    @Override
    public void preSerialize(Persistable pc) {
        if (this.disconnectClone(pc)) {
            return;
        }
        this.retrieve(false);
        this.myLC = this.myLC.transitionSerialize(this);
        if (!this.isStoringPC() && pc instanceof Detachable && !this.myLC.isDeleted() && this.myLC.isPersistent()) {
            if (this.myLC.isDirty()) {
                this.flush();
            }
            ((Detachable)((Object)pc)).dnReplaceDetachedState();
        }
    }

    @Override
    public void setStoringPC() {
        this.flags |= 0x10000;
    }

    @Override
    public void unsetStoringPC() {
        this.flags &= 0xFFFEFFFF;
    }

    protected boolean isStoringPC() {
        return (this.flags & 0x10000) != 0;
    }

    @Override
    public void flush() {
        if (this.dirty) {
            if (this.isFlushing()) {
                return;
            }
            if ((this.flags & 0x400000) != 0 || (this.flags & 0x200000) != 0) {
                return;
            }
            this.setFlushing(true);
            try {
                if (this.myLC.stateType() == 1 && !this.isFlushedNew()) {
                    if (!this.isEmbedded()) {
                        this.internalMakePersistent();
                    } else {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                        this.getCallbackHandler().postStore(this.myPC);
                    }
                    this.dirty = false;
                } else if (this.myLC.stateType() == 8) {
                    this.getCallbackHandler().preDelete(this.myPC);
                    if (!this.isEmbedded()) {
                        this.internalDeletePersistent();
                    }
                    this.getCallbackHandler().postDelete(this.myPC);
                } else if (this.myLC.stateType() == 7) {
                    if (this.isFlushedNew()) {
                        this.getCallbackHandler().preDelete(this.myPC);
                        if (!this.isEmbedded()) {
                            this.internalDeletePersistent();
                        }
                        this.setFlushedNew(false);
                        this.getCallbackHandler().postDelete(this.myPC);
                    } else {
                        this.dirty = false;
                    }
                } else {
                    if (!this.isDeleting()) {
                        this.getCallbackHandler().preStore(this.myPC);
                        if (this.myID == null) {
                            this.setIdentity(true);
                        }
                    }
                    if (!this.isEmbedded()) {
                        int[] dirtyFieldNumbers = ClassUtils.getFlagsSetTo(this.dirtyFields, true);
                        if (dirtyFieldNumbers == null) {
                            throw new NucleusException(Localiser.msg("026010")).setFatal();
                        }
                        if (this.myEC.getNucleusContext().isClassCacheable(this.getClassMetaData())) {
                            this.myEC.markFieldsForUpdateInLevel2Cache(this.getInternalObjectId(), this.dirtyFields);
                        }
                        this.getStoreManager().getPersistenceHandler().updateObject(this, dirtyFieldNumbers);
                        this.myEC.putObjectIntoLevel1Cache(this);
                    }
                    this.clearDirtyFlags();
                    this.getCallbackHandler().postStore(this.myPC);
                }
            }
            finally {
                this.setFlushing(false);
            }
        }
    }

    @Override
    public void saveFields() {
        if (this.savedState == null) {
            this.savedState = new SavedState(this.myPC.dnNewInstance(this), (boolean[])this.loadedFields.clone(), this.persistenceFlags);
            this.savedState.getPC().dnCopyFields(this.myPC, this.cmd.getAllMemberPositions());
        } else {
            this.savedState.getPC().dnCopyFields(this.myPC, this.cmd.getAllMemberPositions());
            this.savedState.setPersistenceFlags(this.persistenceFlags);
            this.savedState.setLoadedFields((boolean[])this.loadedFields.clone());
        }
    }

    @Override
    public void restoreFields() {
        if (this.savedState != null) {
            this.loadedFields = this.savedState.getLoadedFields();
            this.persistenceFlags = this.savedState.getPersistenceFlags();
            this.myPC.dnReplaceFlags();
            this.myPC.dnCopyFields(this.savedState.getPC(), this.cmd.getAllMemberPositions());
            this.savedState = null;
            this.clearDirtyFlags();
        }
    }

    @Override
    public void clearSavedFields() {
        this.savedState = null;
    }

    private static String convertPCToString(Object pc, AbstractClassMetaData cmd) {
        StringBuilder str = new StringBuilder();
        str.append(StringUtils.toJVMIDString(pc));
        if (pc == null) {
            return str.toString();
        }
        str.append(" [");
        str.append("dnStateManager=").append(StateManagerImpl.peekField(pc, "dnStateManager"));
        Object flagsObj = StateManagerImpl.peekField(pc, "dnFlags");
        if (flagsObj instanceof Byte) {
            switch ((Byte)flagsObj) {
                case 1: {
                    str.append(", dnFlags=LOAD_REQUIRED");
                    break;
                }
                case -1: {
                    str.append(", dnFlags=READ_OK");
                    break;
                }
                case 0: {
                    str.append(", dnFlags=READ_WRITE_OK");
                    break;
                }
                default: {
                    str.append(", dnFlags=???");
                    break;
                }
            }
        } else {
            str.append(", dnFlags=").append(flagsObj);
        }
        Class<?> c = pc.getClass();
        do {
            AbstractMemberMetaData[] mmds;
            for (AbstractMemberMetaData mmd : mmds = cmd.getManagedMembers()) {
                str.append(", ").append(mmd.getName());
                str.append("=");
                str.append(StateManagerImpl.peekField(pc, mmd.getName()));
            }
            c = c.getSuperclass();
            cmd = cmd.getSuperAbstractClassMetaData();
        } while (c != null && Persistable.class.isAssignableFrom(c));
        str.append("]");
        return str.toString();
    }

    public void log(NucleusLogger log) {
        log.debug("StateManager[" + StringUtils.toJVMIDString(this) + "]");
        log.debug("    myEC=" + this.myEC);
        log.debug("    myID=" + this.myID);
        log.debug("    myLC=" + this.myLC);
        log.debug("    cmd=" + this.cmd);
        log.debug("    fieldCount=" + this.cmd.getMemberCount());
        log.debug("    dirty=" + this.dirty);
        log.debug("    flushing=" + this.isFlushing());
        log.debug("    changingState=" + this.isChangingState());
        log.debug("    postLoadPending=" + this.isPostLoadPending());
        log.debug("    disconnecting=" + ((this.flags & 2) != 0));
        log.debug("    loadedFields=" + StringUtils.booleanArrayToString(this.loadedFields));
        log.debug("    dirtyFields=" + StringUtils.booleanArrayToString(this.dirtyFields));
        log.debug("    getSecondClassMutableFields()=" + StringUtils.booleanArrayToString(this.cmd.getSCOMutableMemberFlags()));
        log.debug("    getAllFieldNumbers()=" + StringUtils.intArrayToString(this.cmd.getAllMemberPositions()));
        log.debug("    secondClassMutableFieldNumbers=" + StringUtils.intArrayToString(this.cmd.getSCOMutableMemberPositions()));
        switch (this.persistenceFlags) {
            case 1: {
                log.debug("    persistenceFlags=LOAD_REQUIRED");
                break;
            }
            case -1: {
                log.debug("    persistenceFlags=READ_OK");
                break;
            }
            case 0: {
                log.debug("    persistenceFlags=READ_WRITE_OK");
                break;
            }
            default: {
                log.debug("    persistenceFlags=???");
            }
        }
        log.debug("    myPC=" + StateManagerImpl.convertPCToString(this.myPC, this.cmd));
        if (this.savedState != null) {
            switch (this.savedState.getPersistenceFlags()) {
                case 1: {
                    log.debug("    savedState.persistableFlags=LOAD_REQUIRED");
                    break;
                }
                case -1: {
                    log.debug("    savedState.persistableFlags=READ_OK");
                    break;
                }
                case 0: {
                    log.debug("    savedState.persistableFlags=READ_WRITE_OK");
                    break;
                }
                default: {
                    log.debug("    savedState.persistableFlags=???");
                }
            }
            log.debug("    savedState.loadedFields=" + StringUtils.booleanArrayToString(this.savedState.getLoadedFields()));
            log.debug("    savedState.PC= " + StateManagerImpl.convertPCToString(this.savedState.getPC(), this.cmd));
        }
    }

    protected static Object peekField(Object obj, String fieldName) {
        try {
            Object value = obj.getClass().getDeclaredField(fieldName).get(obj);
            if (value instanceof Persistable) {
                return StringUtils.toJVMIDString(value);
            }
            return value;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public void updateFieldAfterInsert(Object pc, int fieldNumber) {
    }

    @Override
    public void initialiseForHollowAppId(FieldValues fv, Class pcClass) {
        if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
            throw new NucleusUserException("This constructor is only for objects using application identity.").setFatal();
        }
        this.myLC = this.myEC.getNucleusContext().getApiAdapter().getLifeCycleState(4);
        this.persistenceFlags = 1;
        this.myPC = HELPER.newInstance(pcClass, this);
        if (this.myPC == null) {
            if (!HELPER.getRegisteredClasses().contains(pcClass)) {
                throw new NucleusUserException(Localiser.msg("026018", pcClass.getName())).setFatal();
            }
            throw new NucleusUserException(Localiser.msg("026019", pcClass.getName())).setFatal();
        }
        this.loadFieldValues(fv);
        this.myID = this.myEC.getNucleusContext().getIdentityManager().getApplicationId(this.myPC, this.cmd);
    }

    @Override
    public void checkInheritance(FieldValues fv) {
        ClassLoaderResolver clr = this.myEC.getClassLoaderResolver();
        String className = this.getStoreManager().getClassNameForObjectID(this.myID, clr, this.myEC);
        if (className == null) {
            throw new NucleusObjectNotFoundException(Localiser.msg("026013", IdentityUtils.getPersistableIdentityForId(this.myID)), this.myID);
        }
        if (!this.cmd.getFullClassName().equals(className)) {
            Class pcClass;
            try {
                pcClass = clr.classForName(className, this.myID.getClass().getClassLoader(), true);
                this.cmd = this.myEC.getMetaDataManager().getMetaDataForClass(pcClass, clr);
            }
            catch (ClassNotResolvedException e) {
                NucleusLogger.PERSISTENCE.warn(Localiser.msg("026014", IdentityUtils.getPersistableIdentityForId(this.myID)));
                throw new NucleusUserException(Localiser.msg("026014", IdentityUtils.getPersistableIdentityForId(this.myID)), e);
            }
            if (this.cmd == null) {
                throw new NucleusUserException(Localiser.msg("026012", pcClass)).setFatal();
            }
            if (this.cmd.getIdentityType() != IdentityType.APPLICATION) {
                throw new NucleusUserException("This method should only be used for objects using application identity.").setFatal();
            }
            this.myFP = this.myEC.getFetchPlan().getFetchPlanForClass(this.cmd);
            int fieldCount = this.cmd.getMemberCount();
            this.dirtyFields = new boolean[fieldCount];
            this.loadedFields = new boolean[fieldCount];
            this.myPC = HELPER.newInstance(pcClass, this);
            if (this.myPC == null) {
                throw new NucleusUserException(Localiser.msg("026018", this.cmd.getFullClassName())).setFatal();
            }
            this.loadFieldValues(fv);
            this.myID = this.myEC.getNucleusContext().getIdentityManager().getApplicationId(this.myPC, this.cmd);
        }
    }
}

