package io.github.qsy7.csv.plugins.index.map;

import io.github.qsy7.csv.api.model.CSVRecord;
import io.github.qsy7.csv.api.model.CSVRecordPK;
import io.github.qsy7.csv.api.service.reader.CSVReader;
import io.github.qsy7.index.api.model.index.IndexableRecord;
import java.util.Iterator;
import java.util.function.Function;

/** Maps a CSVRecord to an IndexableRecord (which can be ingested by the indexService) */
public class IndexRecordToCSVIndexRecordMap implements Function<IndexableRecord, CSVRecord> {
  protected final CSVReader csvReader;

  public IndexRecordToCSVIndexRecordMap(CSVReader csvReader) {
    this.csvReader = csvReader;
  }

  @Override
  public CSVRecord apply(IndexableRecord indexableRecord) {
    // TODO: this requires the entity id to be an int
    final Integer index = (Integer) indexableRecord.getEntityReference().getEntityId();

    final Iterator<String[]> csvIterator = csvReader.iterator();
    String[] data = null;
    int i = 0;
    while (csvIterator.hasNext() && i < index) {
      data = csvIterator.next();
      i++;
    }

    if (i != index) {
      throw new RuntimeException("Record not found:" + index);
    }

    return new CSVRecord(
        new CSVRecordPK(indexableRecord.getEntityReference().getEntityType().getName(), index),
        csvReader.getHeaders(),
        data);
  }
}
