/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.enumeration;

import io.github.qsy7.encryption.enumeration.CipherMode;
import io.github.qsy7.encryption.enumeration.PaddingType;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.property.ConfigurableProperty;

public enum EncryptionAlgorithm implements ConfigurableProperty
{
    AES("AES", new CipherMode[]{CipherMode.CBC, CipherMode.ECB}, new PaddingType[]{PaddingType.NoPadding, PaddingType.PKCS5Padding}, 128, 256, 512),
    DES("DES", new CipherMode[]{CipherMode.CBC, CipherMode.ECB}, new PaddingType[]{PaddingType.NoPadding, PaddingType.PKCS5Padding}, 56),
    DESede("DESede", new CipherMode[]{CipherMode.CBC, CipherMode.ECB}, new PaddingType[]{PaddingType.NoPadding, PaddingType.PKCS5Padding}, 168),
    MessageDigest("MD", new CipherMode[]{CipherMode.CBC, CipherMode.ECB}, new PaddingType[]{PaddingType.NoPadding, PaddingType.PKCS5Padding}, 2, 5),
    RSA("RSA", new CipherMode[]{CipherMode.ECB}, new PaddingType[]{PaddingType.PKCS1Padding, PaddingType.OAEPWithSHA_1AndMGF1Padding, PaddingType.OAEPWithSHA_256AndMGF1Padding}, 1024, 2048),
    SHA("SHA", new CipherMode[]{CipherMode.CBC, CipherMode.ECB}, new PaddingType[]{PaddingType.NoPadding, PaddingType.PKCS5Padding}, 0, 1, 256, 384, 512);

    private final String algorithmName;
    private final CipherMode[] cipherModes;
    private final PaddingType[] paddingTypes;
    private final int[] supportedSizes;

    /*
     * WARNING - void declaration
     */
    private EncryptionAlgorithm(String string2, CipherMode[] cipherModeArray, PaddingType[] paddingTypeArray, int ... nArray) {
        void supportedSizes;
        void paddingTypes;
        void cipherModes;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"<init>", (Object[])new Object[]{string, n, string2, cipherModeArray, paddingTypeArray, nArray});
        EncryptionAlgorithm encryptionAlgorithm = this;
        String string3 = string;
        int n2 = n;
        String string4 = string2;
        CipherMode[] cipherModeArray2 = cipherModeArray;
        PaddingType[] paddingTypeArray2 = paddingTypeArray;
        int[] nArray2 = nArray;
        encryptionAlgorithm.algorithmName = cipherModes;
        encryptionAlgorithm.cipherModes = paddingTypes;
        encryptionAlgorithm.paddingTypes = supportedSizes;
        encryptionAlgorithm.supportedSizes = nArray2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"<init>", (Object[])new Object[]{string, n, string2, cipherModeArray, paddingTypeArray, nArray}, null, (long)l);
    }

    public String getAlgorithmName() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getAlgorithmName", (Object[])new Object[0]);
        Object object = this;
        object = object.algorithmName;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getAlgorithmName", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public CipherMode[] getCipherModes() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getCipherModes", (Object[])new Object[0]);
        CipherMode[] cipherModeArray = this;
        cipherModeArray = cipherModeArray.cipherModes;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getCipherModes", (Object[])new Object[0], (Object)cipherModeArray, (long)l);
        return cipherModeArray;
    }

    public PaddingType[] getPaddingTypes() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getPaddingTypes", (Object[])new Object[0]);
        PaddingType[] paddingTypeArray = this;
        paddingTypeArray = paddingTypeArray.paddingTypes;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getPaddingTypes", (Object[])new Object[0], (Object)paddingTypeArray, (long)l);
        return paddingTypeArray;
    }

    public int[] getSupportedSizes() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getSupportedSizes", (Object[])new Object[0]);
        Object object = this;
        object = object.supportedSizes;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.enumeration.EncryptionAlgorithm", (String)"getSupportedSizes", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }
}

