// Generated by delombok at Fri Jan 12 23:33:02 EST 2024
package io.github.qsy7.encryption.impl.digest;

import io.github.qsy7.encryption.enumeration.DigestAlgorithm;
import io.github.qsy7.encryption.impl.EncryptionConfiguration;
import io.github.qsy7.encryption.service.DigestService;
import java.lang.reflect.InvocationTargetException;

public enum DigestMapping {
  SHA_1(DigestAlgorithm.SHA_1, SHA1DigestService.class), SHA_256(DigestAlgorithm.SHA_256, SHA256DigestService.class), SHA_512(DigestAlgorithm.SHA_512, SHA512DigestService.class);
  private final DigestAlgorithm digestAlgorithm;
  private final Class<? extends DigestService> digestServiceClass;

  public DigestService get(EncryptionConfiguration encryptionConfiguration) {
    try {
      return digestServiceClass.getConstructor(EncryptionConfiguration.class).newInstance(encryptionConfiguration);
    } catch (InstantiationException | IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
      throw new RuntimeException("Application is mis-configured, unable to create digest service.");
    }
  }

  public static DigestMapping get(DigestAlgorithm digestAlgorithm) {
    // Arrays.stream(values()).findFirst(digestMapping -> digestMapping.)
    for (final DigestMapping digestMapping : values()) {
      if (digestMapping.getDigestAlgorithm().equals(digestAlgorithm)) return digestMapping;
    }
    throw new IllegalArgumentException("No provider found for algorithm:");
  }

  @java.lang.SuppressWarnings("all")
  public DigestAlgorithm getDigestAlgorithm() {
    return this.digestAlgorithm;
  }

  @java.lang.SuppressWarnings("all")
  public Class<? extends DigestService> getDigestServiceClass() {
    return this.digestServiceClass;
  }

  @java.lang.SuppressWarnings("all")
  private DigestMapping(final DigestAlgorithm digestAlgorithm, final Class<? extends DigestService> digestServiceClass) {
    this.digestAlgorithm = digestAlgorithm;
    this.digestServiceClass = digestServiceClass;
  }
}
