/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.enumeration.EncryptionAlgorithm;
import io.github.qsy7.encryption.property.IVFilePath;
import io.github.qsy7.encryption.property.KeyFilePath;
import io.github.qsy7.encryption.service.SaltService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

@Singleton
public class RuntimeEncryptionConfiguration {
    protected final String keyFilePath;
    protected final String ivFilePath;
    protected byte[] keyData;
    protected byte[] ivData;
    protected final SaltService saltService;
    protected Key key;
    protected IvParameterSpec iv;

    /*
     * WARNING - void declaration
     */
    @Inject
    public RuntimeEncryptionConfiguration(@Property(value=KeyFilePath.class) String string, @Property(value=IVFilePath.class) String string2, SaltService saltService) throws IOException {
        void saltService2;
        void ivFilePath;
        void keyFilePath;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"<init>", (Object[])new Object[]{string, string2, saltService});
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        String string3 = string;
        String string4 = string2;
        SaltService saltService3 = saltService;
        runtimeEncryptionConfiguration.keyFilePath = keyFilePath;
        runtimeEncryptionConfiguration.ivFilePath = ivFilePath;
        runtimeEncryptionConfiguration.saltService = saltService2;
        runtimeEncryptionConfiguration.setupKey();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"<init>", (Object[])new Object[]{string, string2, saltService}, null, (long)l);
    }

    protected void setupKey() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"setupKey", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration2 = runtimeEncryptionConfiguration;
        try {
            if (new File(runtimeEncryptionConfiguration2.keyFilePath).exists()) {
                runtimeEncryptionConfiguration2.keyData = new byte[32];
                runtimeEncryptionConfiguration2.ivData = new byte[16];
                IOUtils.read((InputStream)new FileInputStream(runtimeEncryptionConfiguration2.keyFilePath), (byte[])runtimeEncryptionConfiguration2.keyData);
                IOUtils.read((InputStream)new FileInputStream(runtimeEncryptionConfiguration2.ivFilePath), (byte[])runtimeEncryptionConfiguration2.ivData);
            } else {
                runtimeEncryptionConfiguration2.keyData = runtimeEncryptionConfiguration2.saltService.generate(32);
                try (FileOutputStream fos = new FileOutputStream(new File(runtimeEncryptionConfiguration2.keyFilePath));){
                    fos.write(runtimeEncryptionConfiguration2.keyData);
                }
                runtimeEncryptionConfiguration2.ivData = runtimeEncryptionConfiguration2.saltService.generate(16);
                fos = new FileOutputStream(new File(runtimeEncryptionConfiguration2.ivFilePath));
                try {
                    fos.write(runtimeEncryptionConfiguration2.ivData);
                }
                finally {
                    fos.close();
                }
            }
            runtimeEncryptionConfiguration2.key = new SecretKeySpec(runtimeEncryptionConfiguration2.keyData, EncryptionAlgorithm.AES.getAlgorithmName());
            runtimeEncryptionConfiguration2.iv = new IvParameterSpec(runtimeEncryptionConfiguration2.ivData);
            runtimeEncryptionConfiguration2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (runtimeEncryptionConfiguration2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"setupKey", (Object[])new Object[0], (Throwable)((Object)runtimeEncryptionConfiguration2));
        }
        if (runtimeEncryptionConfiguration2 != null) {
            throw runtimeEncryptionConfiguration2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"setupKey", (Object[])new Object[0], null, (long)l);
    }

    public String getKeyFilePath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getKeyFilePath", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).keyFilePath;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public String getIvFilePath() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getIvFilePath", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).ivFilePath;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public byte[] getKeyData() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getKeyData", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).keyData;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public byte[] getIvData() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getIvData", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).ivData;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public SaltService getSaltService() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getSaltService", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration2 = runtimeEncryptionConfiguration;
        try {
            runtimeEncryptionConfiguration2 = runtimeEncryptionConfiguration2.saltService;
            return runtimeEncryptionConfiguration2;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public Key getKey() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getKey", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).key;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public IvParameterSpec getIv() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.encryption.impl.RuntimeEncryptionConfiguration", (String)"getIv", (Object[])new Object[0]);
        RuntimeEncryptionConfiguration runtimeEncryptionConfiguration = this;
        Object object = runtimeEncryptionConfiguration;
        try {
            object = ((RuntimeEncryptionConfiguration)object).iv;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }
}

