/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.file.impl.service;

import io.github.qsy7.encryption.api.service.CompressionService;
import io.github.qsy7.encryption.service.DigestService;
import io.github.qsy7.encryption.service.EncryptionService;
import io.github.qsy7.file.api.service.FileStorageService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.IOUtils;

public abstract class AbstractFileStorageService
implements FileStorageService {
    protected final CompressionService compressionService;
    protected final EncryptionService encryptionService;
    protected final DigestService digestService;
    protected final boolean nop;
    protected final boolean debug;

    /*
     * WARNING - void declaration
     */
    protected AbstractFileStorageService(CompressionService compressionService, EncryptionService encryptionService, DigestService digestService, boolean bl, boolean bl2) {
        void debug;
        void nop;
        void digestService2;
        void encryptionService2;
        void compressionService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"<init>", (Object[])new Object[]{compressionService, encryptionService, digestService, bl, bl2});
        AbstractFileStorageService abstractFileStorageService = this;
        CompressionService compressionService3 = compressionService;
        EncryptionService encryptionService3 = encryptionService;
        DigestService digestService3 = digestService;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        abstractFileStorageService.compressionService = compressionService2;
        abstractFileStorageService.encryptionService = encryptionService2;
        abstractFileStorageService.digestService = digestService2;
        abstractFileStorageService.nop = nop;
        abstractFileStorageService.debug = debug;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"<init>", (Object[])new Object[]{compressionService, encryptionService, digestService, bl, bl2}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public io.github.qsy7.file.api.model.File put(io.github.qsy7.file.api.model.File file) throws IOException, NoSuchAlgorithmException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"put", (Object[])new Object[]{file});
        AbstractFileStorageService abstractFileStorageService = this;
        io.github.qsy7.file.api.model.File file2 = file;
        AbstractFileStorageService abstractFileStorageService2 = abstractFileStorageService;
        io.github.qsy7.file.api.model.File file3 = file2;
        try {
            void file4;
            File sourceFile = new File(file4.getSource());
            String digest = abstractFileStorageService2.digestService.compute(sourceFile);
            file4.setChecksum(digest);
            abstractFileStorageService2 = abstractFileStorageService2.storeReference((io.github.qsy7.file.api.model.File)file4, sourceFile);
            return abstractFileStorageService2;
        }
        finally {
            file3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected io.github.qsy7.file.api.model.File storeReference(io.github.qsy7.file.api.model.File file, File file2) throws IOException {
        void v0;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"storeReference", (Object[])new Object[]{file, file2});
        AbstractFileStorageService abstractFileStorageService = this;
        io.github.qsy7.file.api.model.File file3 = file;
        File file4 = file2;
        AbstractFileStorageService abstractFileStorageService2 = abstractFileStorageService;
        io.github.qsy7.file.api.model.File file5 = file3;
        File file6 = file4;
        try {
            void file7;
            try {
                v0 = file7;
            }
            catch (RuntimeException e) {
                void sourceFile;
                File replacedFile = !abstractFileStorageService2.debug ? abstractFileStorageService2.compressAndEncrypt((io.github.qsy7.file.api.model.File)file7, (File)sourceFile) : null;
                abstractFileStorageService2.doPut((io.github.qsy7.file.api.model.File)file7);
                if (replacedFile != null) {
                    replacedFile.delete();
                }
                v0 = file7;
            }
        }
        catch (Throwable throwable) {
            abstractFileStorageService2 = null;
        }
        abstractFileStorageService2 = v0;
        file5 = null;
        if (file5 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"storeReference", (Object[])new Object[]{file3, file4}, (Throwable)file5);
        }
        if (file5 != null) {
            throw file5;
        }
        abstractFileStorageService = abstractFileStorageService2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"storeReference", (Object[])new Object[]{file, file2}, (Object)abstractFileStorageService, (long)l);
        return abstractFileStorageService;
    }

    /*
     * Unable to fully structure code
     */
    protected File compressAndEncrypt(io.github.qsy7.file.api.model.File var1_1, File var2_2) throws IOException {
        var3_3 = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"compressAndEncrypt", (Object[])new Object[]{var1_1, var2_2});
        var5_4 = this;
        var6_5 = var1_1;
        var7_6 = var2_2;
        var8_7 = var5_4;
        var9_8 = var6_5;
        var10_10 = var7_6;
        try {
            compressedAndEncryptedFile = File.createTempFile("encrypted", "xz");
            inputStream = new FileInputStream((File)sourceFile);
            try {
                outputStream = var8_7.compressionService.getCompressionStream(var8_7.encryptionService.getEncryptionStream((OutputStream)new FileOutputStream(compressedAndEncryptedFile)));
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                    file.setSource(compressedAndEncryptedFile.getAbsolutePath());
                    sourceFile.delete();
                    var14_15 = compressedAndEncryptedFile;
                    ** if (outputStream == null) goto lbl-1000
                }
                catch (Throwable var14_16) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable var15_18) {
                            var14_16.addSuppressed(var15_18);
                        }
                    }
                    throw var14_16;
                }
lbl-1000:
                // 1 sources

                {
                    outputStream.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            finally {
                inputStream.close();
            }
            var8_7 = var14_15;
            return var8_7;
        }
        finally {
            var9_8 = null;
        }
    }

    protected abstract void doPut(io.github.qsy7.file.api.model.File var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public io.github.qsy7.file.api.model.File put(File file) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"put", (Object[])new Object[]{file});
        AbstractFileStorageService abstractFileStorageService = this;
        File file2 = file;
        AbstractFileStorageService abstractFileStorageService2 = abstractFileStorageService;
        File file3 = file2;
        try {
            void file4;
            io.github.qsy7.file.api.model.File wFile = new io.github.qsy7.file.api.model.File(file4.getAbsolutePath());
            abstractFileStorageService2 = abstractFileStorageService2.put(wFile);
            return abstractFileStorageService2;
        }
        finally {
            file3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void get(io.github.qsy7.file.api.model.File file) throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"get", (Object[])new Object[]{file});
        AbstractFileStorageService abstractFileStorageService = this;
        io.github.qsy7.file.api.model.File file2 = file;
        AbstractFileStorageService abstractFileStorageService2 = abstractFileStorageService;
        io.github.qsy7.file.api.model.File file3 = file2;
        try {
            void file4;
            abstractFileStorageService2.doGet((io.github.qsy7.file.api.model.File)file4);
            File sourceFile = new File(file4.getSource());
            if (!abstractFileStorageService2.debug) {
                File decryptedAndDecompressedFile = File.createTempFile("decrypted", "xz");
                try (InputStream inputStream = abstractFileStorageService2.compressionService.getDecompressionStream(abstractFileStorageService2.encryptionService.getDecryptionStream((InputStream)new FileInputStream(sourceFile)));
                     FileOutputStream outputStream = new FileOutputStream(decryptedAndDecompressedFile);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    outputStream.flush();
                    file4.setSource(decryptedAndDecompressedFile.getAbsolutePath());
                    sourceFile.delete();
                }
            }
            abstractFileStorageService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (abstractFileStorageService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"get", (Object[])new Object[]{file2}, (Throwable)((Object)abstractFileStorageService2));
        }
        if (abstractFileStorageService2 != null) {
            throw abstractFileStorageService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.file.impl.service.AbstractFileStorageService", (String)"get", (Object[])new Object[]{file}, null, (long)l);
    }

    protected abstract void doGet(io.github.qsy7.file.api.model.File var1) throws Exception;
}

