// Generated by delombok at Fri Apr 08 15:25:29 EDT 2022
package io.github.qsy7.linux.builder.impl.service.hostname;

import io.github.qsy7.linux.builder.api.service.HostnameService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class AbstractLinuxHostnameService implements HostnameService {
  protected final String rootDirectory;

  @Override
  public void set(String hostname) throws IOException {
    doSet(hostname);
    updateHosts(hostname);
  }

  protected abstract void doSet(final String hostname) throws IOException;

  protected File getHostnameFile() {
    return (new File(rootDirectory + "/etc/conf.d/hostname"));
  }

  protected void updateHosts(final String hostname) throws IOException {
    final List<String> lines = IOUtils.readLines(new BufferedInputStream(new FileInputStream("/etc/hosts")), "UTF-8");
    final List<String> updated = new ArrayList<>();
    for (final String line : lines) {
      if (line != null && (line.endsWith("localhost") || line.endsWith("localhost6"))) {
        updated.add(line + " " + hostname);
      } else {
        updated.add(line);
      }
    }
    FileUtils.write(new File("/etc/hosts"), String.join("\n", updated));
  }

  @java.lang.SuppressWarnings("all")
  public AbstractLinuxHostnameService(final String rootDirectory) {
    this.rootDirectory = rootDirectory;
  }
}
