package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.StringConfigurer;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.io.FileNotFoundException;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = StringConfigurer.class,
    configurationClass = StringConfiguration.class)
public class DevpiModule extends PipModule {
  @Inject
  public DevpiModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      ShellExecutionService shellExecutionService,
      ShellCommandBuilder shellCommandBuilder)
      throws FileNotFoundException {
    super(
        buildService,
        buildConfiguration,
        distributionConfiguration,
        shellExecutionService,
        shellCommandBuilder);
  }

  @Override
  protected String[] getArguments() {
    return (new String[] {
      pipConfiguration.getVirtualEnvPath() + "/bin/pip",
      "install",
      "--upgrade",
      "-q",
      "-i",
      pipConfiguration.getIndexUrl()
    });
  }
}
