package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.GoPath;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.StringConfigurer;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.model.ShellCommandEnvironmentProperty;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = StringConfigurer.class,
    configurationClass = StringConfiguration.class)
public class GoModule extends AbstractSingleModule<StringConfiguration> {
  protected final ShellExecutionService shellExecutionService;
  protected final ShellCommandBuilder shellCommandBuilder;
  protected final String goPath;

  @Inject
  public GoModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      ShellExecutionService shellExecutionService,
      ShellCommandBuilder shellCommandBuilder,
      @Property(GoPath.class) String goPath) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.shellExecutionService = shellExecutionService;
    this.shellCommandBuilder = shellCommandBuilder;
    this.goPath = goPath;
  }

  @Override
  public void document() {}

  protected void doRun() throws Exception {
    final String[] goPackages = configuration.getContent().split("\n");

    final ShellCommandEnvironmentProperty goPathEnvironmentProperty =
        new ShellCommandEnvironmentProperty();

    // TODO: inject this or expand the configuration to allow this as an option
    goPathEnvironmentProperty.setKey(GoPath.ENVIRONMENT_KEY);
    goPathEnvironmentProperty.setValue(goPath);

    final ShellCommand shellCommand =
        shellCommandBuilder
            .buildChroot()
            .withChrootPath(buildConfiguration.getRootDirectory())
            .withCommandLine(String.join(" ", getArguments(goPackages)));
    shellCommand.getShellCommandEnvironmentProperties().add(goPathEnvironmentProperty);
    goPathEnvironmentProperty.setShellCommand(shellCommand);
    shellExecutionService.run(shellCommand);
  }

  protected String[] getArguments(final String[] goPackages) {
    final List<String> arguments = new ArrayList<>();
    arguments.add("go");
    arguments.add("get");
    arguments.add("-u");

    arguments.addAll(getGoPackages(goPackages));

    return (arguments.toArray(new String[arguments.size()]));
  }

  protected List<String> getGoPackages(final String[] goPackages) {
    return Arrays.stream(goPackages)
        .filter(goPackage -> !isEmpty(goPackage) && !isComment(goPackage))
        .collect(Collectors.toList());
  }

  protected boolean isComment(final String goPackage) {
    return goPackage.startsWith("#");
  }

  protected boolean isEmpty(final String goPackage) {
    return goPackage == null || goPackage.isEmpty();
  }
}
