// Generated by delombok at Fri Apr 08 15:25:29 EDT 2022
package io.github.qsy7.linux.builder.impl.service.util.configuration;

import io.github.qsy7.linux.builder.api.model.configuration.Configurable;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.module.AbstractCollectionModule;
import java.io.File;

/**
 * Creates a configuration object from a module and its configuration. Automatically determines the
 * appropriate utility to use to load the configuration.
 */
public class ConfigurationUtil {
  public static Configurable read(final File moduleConfigurationFile, final Class moduleClass) throws Exception {
    ModuleSupports moduleSupports = (ModuleSupports) moduleClass.getAnnotation(ModuleSupports.class);
    return (moduleSupports.configurer().getDeclaredConstructor().newInstance().read(moduleConfigurationFile, moduleSupports.configurationClass(), isCollection(moduleClass)));
  }

  private static boolean isCollection(final Class moduleClass) {
    return AbstractCollectionModule.class.isAssignableFrom(moduleClass);
  }

  @java.lang.SuppressWarnings("all")
  private ConfigurationUtil() {
  }
}
