package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.Chown;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = YamlConfigurer.class,
    configurationClass = Chown.class)
public class ChownModule extends AbstractCollectionModule<Chown> {
  protected final ShellExecutionService shellExecutionService;
  protected final ShellCommandBuilder shellCommandBuilder;

  @Inject
  public ChownModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      ShellExecutionService shellExecutionService,
      ShellCommandBuilder shellCommandBuilder) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.shellExecutionService = shellExecutionService;
    this.shellCommandBuilder = shellCommandBuilder;
  }

  @Override
  public void document() {}

  protected void doRun(final Chown chown) throws Exception {
    shellExecutionService.run(
        shellCommandBuilder
            .buildChroot()
            .withChrootPath(buildConfiguration.getRootDirectory())
            .withCommandLine(String.join(" ", getArguments(chown))));
  }

  protected String[] getArguments(final Chown chown) {
    final List<String> arguments = new ArrayList<>();
    arguments.add("chown");

    if (chown.isRecursive()) {
      arguments.add("-R");
    }

    final StringBuilder buffer = new StringBuilder();
    if (chown.getOwner() != null && !chown.getOwner().isEmpty()) {
      buffer.append(chown.getOwner());
    }
    buffer.append(":");

    if (chown.getGroup() != null && !chown.getGroup().isEmpty()) {
      buffer.append(chown.getGroup());
    }

    arguments.add(buffer.toString());
    arguments.add(chown.getPath());

    return (arguments.toArray(new String[arguments.size()]));
  }
}
