/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.runlevel;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.Runlevel;
import io.github.qsy7.linux.builder.api.service.RunlevelManagementService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

public class SystemDRunlevelManagementService
implements RunlevelManagementService {
    protected final ShellExecutionService shellExecutionService;
    protected final ShellCommandBuilder shellCommandBuilder;
    protected final String rootDirectory;

    /*
     * WARNING - void declaration
     */
    @Inject
    public SystemDRunlevelManagementService(ShellExecutionService shellExecutionService, ShellCommandBuilder shellCommandBuilder, BuildConfiguration buildConfiguration) {
        void buildConfiguration2;
        void shellCommandBuilder2;
        void shellExecutionService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"<init>", (Object[])new Object[]{shellExecutionService, shellCommandBuilder, buildConfiguration});
        SystemDRunlevelManagementService systemDRunlevelManagementService = this;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        shellExecutionService2.shellExecutionService = shellCommandBuilder2;
        shellExecutionService2.shellCommandBuilder = buildConfiguration2;
        shellExecutionService2.rootDirectory = buildConfiguration3.getRootDirectory();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"<init>", (Object[])new Object[]{shellExecutionService, shellCommandBuilder, buildConfiguration}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void add(Runlevel runlevel) throws Exception {
        void runlevelFile;
        void runlevel2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"add", (Object[])new Object[]{runlevel});
        SystemDRunlevelManagementService systemDRunlevelManagementService = this;
        Runlevel runlevel3 = runlevel;
        File file = runlevel2.getRunlevelTargetFile(runlevel3);
        if (!file.exists()) {
            runlevel2.writeTarget((Runlevel)runlevelFile, file);
        }
        runlevel2.shellExecutionService.run(runlevel2.shellCommandBuilder.buildChroot().withChrootPath(runlevel2.rootDirectory).withCommandLine("systemctl enable " + runlevelFile.getServiceName()));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"add", (Object[])new Object[]{runlevel}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected File getRunlevelTargetFile(Runlevel runlevel) {
        void runlevel2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"getRunlevelTargetFile", (Object[])new Object[]{runlevel});
        Object object = this;
        Runlevel runlevel3 = runlevel;
        object = new File(runlevel2.rootDirectory + "/etc/systemd/system/" + runlevel3.getRunlevel() + ".target");
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"getRunlevelTargetFile", (Object[])new Object[]{runlevel}, (Object)object, (long)l);
        return object;
    }

    protected File getRunlevelTargetWantsFile(File file) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"getRunlevelTargetWantsFile", (Object[])new Object[]{file});
        Object object = this;
        File file2 = file;
        object = new File(file2.getAbsolutePath() + ".wants");
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"getRunlevelTargetWantsFile", (Object[])new Object[]{file}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void writeTarget(Runlevel runlevel, File file) throws IOException {
        void targetLines;
        void targetFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"writeTarget", (Object[])new Object[]{runlevel, file});
        SystemDRunlevelManagementService systemDRunlevelManagementService = this;
        Runlevel runlevel2 = runlevel;
        File file2 = file;
        List<String> list = Arrays.asList("[Unit]", "Description=" + targetFile.getRunlevel() + " target", "Requires=multi-user.target", "After=multi-user.target", "AllowIsolate=yes");
        FileUtils.writeLines((File)targetLines, list);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"writeTarget", (Object[])new Object[]{runlevel, file}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void remove(Runlevel runlevel) throws Exception {
        void runlevel2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"remove", (Object[])new Object[]{runlevel});
        SystemDRunlevelManagementService systemDRunlevelManagementService = this;
        Runlevel runlevel3 = runlevel;
        runlevel2.shellExecutionService.run(runlevel2.shellCommandBuilder.buildChroot().withChrootPath(runlevel2.rootDirectory).withCommandLine("systemctl disable " + runlevel3.getServiceName()));
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.runlevel.SystemDRunlevelManagementService", (String)"remove", (Object[])new Object[]{runlevel}, null, (long)l);
    }
}

