/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.scm;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.impl.service.scm.SCMTagPatchWriterService;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.ssh.api.model.SCMTag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;

public class DefaultSCMTagPatchWriterService
implements SCMTagPatchWriterService {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
    private static final String TAG_TEMPLATE = "# auto-generated via linux-builder @ %s\n\nbuilddate: %s\nvariant: %s\nscm tag: %s\nscm date: %s\nscm version ID: %s\nscm commit message: %s\n";
    protected final String localRepositoryPath;

    /*
     * WARNING - void declaration
     */
    public DefaultSCMTagPatchWriterService(String string) {
        void localRepositoryPath;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"<init>", (Object[])new Object[]{string});
        DefaultSCMTagPatchWriterService defaultSCMTagPatchWriterService = this;
        String string2 = string;
        localRepositoryPath.localRepositoryPath = string2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"<init>", (Object[])new Object[]{string}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(BuildConfiguration buildConfiguration, SCMTag sCMTag) throws IOException {
        void contents;
        void patchFile;
        void scmTag;
        void buildConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"write", (Object[])new Object[]{buildConfiguration, sCMTag});
        DefaultSCMTagPatchWriterService defaultSCMTagPatchWriterService = this;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        SCMTag sCMTag2 = sCMTag;
        File file = new File(buildConfiguration2.localRepositoryPath + File.separator + "patches" + File.separator + "system" + File.separator + "scm-timestamp.patch");
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        File file2 = new File(file.getAbsolutePath() + File.separator + "build" + File.separator + "files" + File.separator + "etc" + File.separator + "system");
        String string = String.format(TAG_TEMPLATE, DefaultSCMTagPatchWriterService.getSystemVersion(), scmTag.getBuildDate().format(DATE_TIME_FORMATTER), scmTag.getVariant(), patchFile.getTag(), patchFile.getCommitDate().format(DATE_TIME_FORMATTER), patchFile.getScmVersionId(), patchFile.getCommitMessage());
        contents.getParentFile().mkdirs();
        FileUtils.write((File)contents, (CharSequence)string, (Charset)Charset.defaultCharset());
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"write", (Object[])new Object[]{buildConfiguration, sCMTag}, null, (long)l);
    }

    private static final String getSystemVersion() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"getSystemVersion", (Object[])new Object[0]);
        String string = DefaultSCMTagPatchWriterService.class.getPackage().getImplementationVersion();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.scm.DefaultSCMTagPatchWriterService", (String)"getSystemVersion", (Object[])new Object[0], (Object)string, (long)l);
        return string;
    }
}

