/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.util;

import io.github.qsy7.linux.builder.api.model.patch.Patch;
import io.github.qsy7.linux.builder.api.model.patch.PatchEdge;
import io.github.qsy7.linux.builder.impl.service.util.IOUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DependencyManagementUtil {
    /*
     * WARNING - void declaration
     */
    public static Patch getPatchByName(String string, String string2, String string3) throws IOException {
        Patch patch2;
        String string4;
        long l;
        block1: {
            void patches;
            void patchName;
            void variant;
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatchByName", (Object[])new Object[]{string, string2, string3});
            string4 = string;
            String string5 = string2;
            String string6 = string3;
            List<Patch> list = DependencyManagementUtil.getOrderedSystemPatches((String)variant, (String)patchName);
            for (Patch patch2 : list) {
                if (!patch2.getName().equals(patches)) continue;
                break block1;
            }
            throw new IllegalStateException("Patch : " + (String)patches + " not found.");
        }
        string4 = patch2;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatchByName", (Object[])new Object[]{string, string2, string3}, (Object)string4, (long)l);
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> getSystemPatches(String string, String string2) throws IOException {
        void systemPatchset;
        void variant;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getSystemPatches", (Object[])new Object[]{string, string2});
        Object object = string;
        String string3 = string2;
        File file = new File((String)variant + File.separator + "systems" + File.separator + string3 + File.separator + "patches");
        List<String> list = IOUtil.readLines(file.getAbsolutePath());
        HashSet<String> hashSet = new HashSet<String>();
        for (String string4 : systemPatchset) {
            if (!string4.endsWith(".patch")) {
                hashSet.addAll(DependencyManagementUtil.getPatches(new File((String)variant + File.separator + "patches" + File.separator + string4)));
                continue;
            }
            hashSet.add(new File((String)variant + File.separator + "patches" + File.separator + string4).getAbsolutePath());
        }
        object = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getSystemPatches", (Object[])new Object[]{string, string2}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Patch> getSystemPatchInstances(String string, String string2, String string3) throws IOException {
        void variant;
        void system;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getSystemPatchInstances", (Object[])new Object[]{string, string2, string3});
        Object object = string;
        String string4 = string2;
        String string5 = string3;
        HashSet<Patch> hashSet = new HashSet<Patch>();
        for (String string6 : DependencyManagementUtil.getSystemPatches((String)system, (String)variant)) {
            void systemPatches;
            hashSet.add(new Patch(DependencyManagementUtil.getPatchName(string6), string6, DependencyManagementUtil.doesVariantExist(string6, (String)systemPatches)));
        }
        object = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getSystemPatchInstances", (Object[])new Object[]{string, string2, string3}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Patch> getOrderedSystemPatches(String string, String string2) throws IOException {
        void sortedPatches;
        void systemPatches;
        void variant;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getOrderedSystemPatches", (Object[])new Object[]{string, string2});
        Object object = string;
        String string3 = string2;
        Set<Patch> set = DependencyManagementUtil.getSystemPatchInstances((String)variant, "base", string3);
        set.addAll(DependencyManagementUtil.getSystemPatchInstances((String)variant, (String)systemPatches, (String)systemPatches));
        DependencyManagementUtil.setupDependencies(set);
        List<Patch> list = DependencyManagementUtil.sortPatches(DependencyManagementUtil.prepareFirstLevel(set));
        DependencyManagementUtil.checkForCycle((Set<Patch>)sortedPatches);
        Collections.reverse(list);
        object = list;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getOrderedSystemPatches", (Object[])new Object[]{string, string2}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static void setupDependencies(Set<Patch> set) throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"setupDependencies", (Object[])new Object[]{set});
        Set<Patch> set2 = set;
        for (Patch patch : set2) {
            File file = new File(patch.getPath() + File.separator + "dependencies");
            if (!file.exists()) continue;
            List<String> list = IOUtil.readLines(file.getAbsolutePath());
            for (String string : list) {
                void dependencyFile;
                dependencyFile.addDependency(DependencyManagementUtil.getPatch(set2, string));
            }
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"setupDependencies", (Object[])new Object[]{set}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Patch> prepareFirstLevel(Set<Patch> set) {
        void firstLevel;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"prepareFirstLevel", (Object[])new Object[]{set});
        Set<Patch> set2 = set;
        HashSet<Patch> hashSet = new HashSet<Patch>();
        for (Patch patch : firstLevel) {
            if (patch.getInEdges().size() != 0) continue;
            hashSet.add(patch);
        }
        set2 = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"prepareFirstLevel", (Object[])new Object[]{set}, set2, (long)l);
        return set2;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Patch> sortPatches(Set<Patch> set) {
        void sortedPatches;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"sortPatches", (Object[])new Object[]{set});
        Collection<Object> collection = set;
        ArrayList arrayList = new ArrayList();
        while (!sortedPatches.isEmpty()) {
            void patch;
            Patch patch2 = (Patch)sortedPatches.iterator().next();
            sortedPatches.remove(patch2);
            patch.add(patch2);
            for (PatchEdge patchEdge : patch2.getOutEdges()) {
                void edgePatch;
                void patchEdge2;
                Patch patch3 = patchEdge.getTo();
                patchEdge2.remove();
                patch3.getInEdges().remove(edgePatch);
                if (!patch3.getInEdges().isEmpty()) continue;
                sortedPatches.add(patch3);
            }
        }
        collection = arrayList;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"sortPatches", (Object[])new Object[]{set}, collection, (long)l);
        return collection;
    }

    private static void checkForCycle(Set<Patch> set) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"checkForCycle", (Object[])new Object[]{set});
        Set<Patch> set2 = set;
        for (Patch patch : set2) {
            if (patch.getInEdges().isEmpty()) continue;
            throw new IllegalStateException("Cycle detected, blew up.");
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"checkForCycle", (Object[])new Object[]{set}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    private static Patch getPatch(Set<Patch> patch, String string) {
        Patch patch22;
        Patch patch3;
        long l;
        block1: {
            void systemPatchName;
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatch", (Object[])new Object[]{patch, string});
            patch3 = patch;
            String string2 = string;
            for (Patch patch22 : systemPatchName) {
                if (!patch22.getName().equals(string2)) continue;
                break block1;
            }
            throw new IllegalStateException("Unable to resolve dependency for:" + string2);
        }
        patch3 = patch22;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatch", (Object[])new Object[]{patch, string}, (Object)patch3, (long)l);
        return patch3;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean doesVariantExist(String string, String string2) {
        void variant;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"doesVariantExist", (Object[])new Object[]{string, string2});
        String string3 = string;
        String string4 = string2;
        boolean bl = new File((String)variant + File.separator + "variants" + File.separator + string4).exists();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"doesVariantExist", (Object[])new Object[]{string, string2}, (Object)bl, (long)l);
        return bl;
    }

    private static final String getPatchName(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatchName", (Object[])new Object[]{string});
        String string2 = string;
        String[] stringArray = string2.split("/");
        String string3 = stringArray[stringArray.length - 1];
        string2 = string3.replace(".patch", "");
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatchName", (Object[])new Object[]{string}, (Object)string2, (long)l);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> getPatches(File file) {
        void patchFiles;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatches", (Object[])new Object[]{file});
        Serializable serializable = file;
        HashSet<String> hashSet = new HashSet<String>();
        for (File file2 : patchFiles.listFiles()) {
            if (!file2.isDirectory()) continue;
            if (file2.getAbsolutePath().endsWith(".patch")) {
                hashSet.add(file2.getAbsolutePath());
                continue;
            }
            hashSet.addAll(DependencyManagementUtil.getPatches(file2));
        }
        serializable = hashSet;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"getPatches", (Object[])new Object[]{file}, (Object)serializable, (long)l);
        return serializable;
    }

    private DependencyManagementUtil() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"<init>", (Object[])new Object[0]);
        DependencyManagementUtil dependencyManagementUtil = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.DependencyManagementUtil", (String)"<init>", (Object[])new Object[0], null, (long)l);
    }
}

