/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.util.module;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.linux.builder.api.model.BuildPhase;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.Configurable;
import io.github.qsy7.linux.builder.api.model.patch.Patch;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.api.service.Module;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.module.AbstractModule;
import io.github.qsy7.linux.builder.impl.service.util.configuration.ConfigurationUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.reflections.Reflections;

public class ModuleFactory {
    protected final BuildConfiguration buildConfiguration;
    protected final DistributionConfiguration distributionConfiguration;
    protected final Set<Class<? extends Module>> allClasses;
    protected final Map<String, Class<? extends Module>> extensionToClassMapping;
    protected final Reflections reflections;

    /*
     * WARNING - void declaration
     */
    @Inject
    public ModuleFactory(BuildConfiguration buildConfiguration, DistributionConfiguration distributionConfiguration, Reflections reflections) {
        void reflections2;
        void distributionConfiguration2;
        void buildConfiguration2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"<init>", (Object[])new Object[]{buildConfiguration, distributionConfiguration, reflections});
        ModuleFactory moduleFactory = this;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        Reflections reflections3 = reflections;
        buildConfiguration2.buildConfiguration = distributionConfiguration2;
        buildConfiguration2.distributionConfiguration = reflections2;
        buildConfiguration2.reflections = reflections3;
        buildConfiguration2.allClasses = new HashSet<Class<? extends Module>>();
        buildConfiguration2.extensionToClassMapping = new HashMap<String, Class<? extends Module>>();
        buildConfiguration2.onSetup();
        buildConfiguration2.setupMapping();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"<init>", (Object[])new Object[]{buildConfiguration, distributionConfiguration, reflections}, null, (long)l);
    }

    @PostConstruct
    protected void onSetup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"onSetup", (Object[])new Object[0]);
        ModuleFactory moduleFactory = this;
        moduleFactory.allClasses.addAll(moduleFactory.reflections.getSubTypesOf(Module.class));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"onSetup", (Object[])new Object[0], null, (long)l);
    }

    protected void setupMapping() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"setupMapping", (Object[])new Object[0]);
        ModuleFactory moduleFactory = this;
        for (Class<? extends Module> clazz : moduleFactory.allClasses) {
            moduleFactory.extensionToClassMapping.put(ModuleFactory.getExtension(clazz), clazz);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"setupMapping", (Object[])new Object[0], null, (long)l);
    }

    private static List<String> splitByCamelCase(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"splitByCamelCase", (Object[])new Object[]{string});
        Object object = string;
        object = Arrays.asList(((String)object).split("(?<=[a-z0-9])(?=[A-Z])"));
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"splitByCamelCase", (Object[])new Object[]{string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static String getExtension(Class<? extends Module> clazz) {
        void parts;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getExtension", (Object[])new Object[]{clazz});
        Object object = clazz;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ModuleFactory.splitByCamelCase(parts.getSimpleName())) {
            arrayList.add(string.toLowerCase());
        }
        arrayList.remove(arrayList.size() - 1);
        object = String.join((CharSequence)"-", arrayList);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getExtension", (Object[])new Object[]{clazz}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public List<Module> produceModules(BuildService buildService, Patch patch, BuildPhase buildPhase) throws Exception {
        void buildPhaseFile;
        void patch2;
        void buildPhase2;
        void buildService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase});
        Object object = this;
        BuildService buildService3 = buildService;
        Patch patch3 = patch;
        BuildPhase buildPhase3 = buildPhase;
        File file = buildService2.getBuildPhaseFile((Patch)buildPhase2, buildPhase3);
        object = buildService2.produceModules((BuildService)patch2, (Patch)buildPhase2, (BuildPhase)buildPhaseFile, file);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Module> produceModules(BuildService buildService, Patch patch, BuildPhase buildPhase, File file) throws Exception {
        Object v0;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase, file});
        ModuleFactory moduleFactory = this;
        BuildService buildService2 = buildService;
        Patch patch2 = patch;
        BuildPhase buildPhase2 = buildPhase;
        File file2 = file;
        if (file2 != null && file2.exists()) {
            void files;
            void modules;
            ArrayList arrayList = new ArrayList();
            Object[] objectArray = modules.listFiles();
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                void buildPhase3;
                void buildPhaseFile;
                void buildService3;
                files.add(buildService3.getModuleInstance((File)object, (BuildPhase)buildPhaseFile, buildPhase3.getName()));
            }
            v0 = files;
        } else {
            v0 = null;
        }
        moduleFactory = v0;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase, file}, (Object)moduleFactory, (long)l);
        return moduleFactory;
    }

    /*
     * WARNING - void declaration
     */
    public List<Module> produceModules(BuildService buildService, Patch patch, BuildPhase buildPhase, String string) throws Exception {
        void patch2;
        void variant;
        void buildPhase2;
        void buildService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase, string});
        Object object = this;
        BuildService buildService3 = buildService;
        Patch patch3 = patch;
        BuildPhase buildPhase3 = buildPhase;
        String string2 = string;
        File file = buildService2.getBuildPhaseFileForVariant((Patch)buildPhase2, (BuildPhase)variant, string2);
        object = buildService2.produceModules((BuildService)patch2, (Patch)buildPhase2, (BuildPhase)variant, file);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"produceModules", (Object[])new Object[]{buildService, patch, buildPhase, string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected File getBuildPhaseFileForVariant(Patch patch, BuildPhase buildPhase, String string) {
        void variant;
        void buildPhase2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getBuildPhaseFileForVariant", (Object[])new Object[]{patch, buildPhase, string});
        Object object = this;
        Patch patch2 = patch;
        BuildPhase buildPhase3 = buildPhase;
        String string2 = string;
        object = new File(buildPhase2.getPath() + File.separator + "variants" + File.separator + string2 + File.separator + variant.name().toLowerCase());
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getBuildPhaseFileForVariant", (Object[])new Object[]{patch, buildPhase, string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected File getBuildPhaseFile(Patch patch, BuildPhase buildPhase) {
        void buildPhase2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getBuildPhaseFile", (Object[])new Object[]{patch, buildPhase});
        Object object = this;
        Patch patch2 = patch;
        BuildPhase buildPhase3 = buildPhase;
        object = new File(buildPhase2.getPath() + File.separator + buildPhase3.name().toLowerCase());
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getBuildPhaseFile", (Object[])new Object[]{patch, buildPhase}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected Module getModuleInstance(File file, BuildPhase buildPhase, String string) throws Exception {
        void patchName;
        void instance;
        void beanClass;
        void configuration;
        void buildPhase2;
        void moduleConfigurationFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleInstance", (Object[])new Object[]{file, buildPhase, string});
        Object object = this;
        File file2 = file;
        BuildPhase buildPhase3 = buildPhase;
        String string2 = string;
        Class clazz = moduleConfigurationFile.getModuleClass((File)buildPhase2);
        Configurable configurable = ConfigurationUtil.read((File)buildPhase2, clazz);
        AbstractModule abstractModule = (AbstractModule)ApplicationHelper.getApplicationInstance().getInjector().getInstance((Class)configuration, new AnnotationLiteral[0]);
        abstractModule.setPatchName((String)beanClass);
        abstractModule.setFilename(buildPhase2.getAbsolutePath());
        abstractModule.setConfiguration(instance);
        abstractModule.setBuildPhase((BuildPhase)patchName);
        abstractModule.onSetup();
        object = abstractModule;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleInstance", (Object[])new Object[]{file, buildPhase, string}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Class getModuleClass(File file) {
        void moduleConfigurationFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleClass", (Object[])new Object[]{file});
        Object object = this;
        File file2 = file;
        Class<? extends Module> clazz = moduleConfigurationFile.extensionToClassMapping.get(ModuleFactory.getFileExtension(file2));
        if (clazz == null) {
            void moduleClass;
            throw new IllegalArgumentException("No module class found for: " + (File)moduleClass + ", check the spelling of the extension");
        }
        object = clazz;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleClass", (Object[])new Object[]{file}, (Object)object, (long)l);
        return object;
    }

    private static String getModuleExtension(File file) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleExtension", (Object[])new Object[]{file});
        Object object = file;
        String[] stringArray = ((File)object).getName().split("\\.");
        object = stringArray[stringArray.length - 1].replace("-", "");
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getModuleExtension", (Object[])new Object[]{file}, (Object)object, (long)l);
        return object;
    }

    private static String getFileExtension(File file) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getFileExtension", (Object[])new Object[]{file});
        Object object = file;
        String[] stringArray = ((File)object).getName().split("\\.");
        object = stringArray[stringArray.length - 1];
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.util.module.ModuleFactory", (String)"getFileExtension", (Object[])new Object[]{file}, (Object)object, (long)l);
        return object;
    }
}

