package io.github.qsy7.data.pipe.impl;

import io.github.qsy7.data.pipe.api.filter.AbstractFilterConfiguration;
import io.github.qsy7.data.pipe.api.filter.Filter;

public abstract class AbstractFilter<
        RecordType, FilterConfigurationType extends AbstractFilterConfiguration>
    implements Filter<RecordType, FilterConfigurationType> {
  protected FilterConfigurationType filterConfiguration;

  @Override
  public void configure(FilterConfigurationType filterConfiguration) {
    this.filterConfiguration = filterConfiguration;

    doConfigure();
  }

  protected abstract void doConfigure();
}
