package io.github.qsy7.data.pipe.impl;

import io.github.qsy7.data.pipe.api.sink.AbstractSourceConfiguration;
import io.github.qsy7.data.pipe.api.source.Source;
import java.io.Serializable;

public abstract class AbstractSource<
        RecordType extends Serializable,
        SourceConfigurationType extends AbstractSourceConfiguration>
    implements Source<RecordType, SourceConfigurationType> {
  protected SourceConfigurationType sourceConfiguration;

  public void configure(SourceConfigurationType sourceConfiguration) {
    this.sourceConfiguration = sourceConfiguration;
    doConfigure();
  }

  protected abstract void doConfigure();
}
