// Generated by delombok at Fri Apr 08 14:57:57 EDT 2022
package io.github.qsy7.queue.api.enumeration;

import java.util.Arrays;

public enum ActionType {
  Cancel("Job Executions in one of these states may be cancelled.", new ExecutionState[] {ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running}), Assign("Job Executions in one of these states may be assigned to a worker", new ExecutionState[] {ExecutionState.Queued}), RecurringAssign("Job Executions in one of these states may be assigned to a worker (for recurring jobs only)", new ExecutionState[] {ExecutionState.Completed, ExecutionState.Cancelled, ExecutionState.Aborted, ExecutionState.Exception}), Aborted("Job Executions in one of these states may be aborted, provided the current time is > the" + " timeoutDateTime for the execution", new ExecutionState[] {ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running});
  private final String description;
  private final ExecutionState[] supportedExecutionStates;

  public boolean isSupported(ExecutionState executionState) {
    return Arrays.stream(supportedExecutionStates).filter(supportedExecutionState -> supportedExecutionState.equals(executionState)).count() > 0;
  }

  @java.lang.SuppressWarnings("all")
  public String getDescription() {
    return this.description;
  }

  @java.lang.SuppressWarnings("all")
  public ExecutionState[] getSupportedExecutionStates() {
    return this.supportedExecutionStates;
  }

  @java.lang.SuppressWarnings("all")
  private ActionType(final String description, final ExecutionState[] supportedExecutionStates) {
    this.description = description;
    this.supportedExecutionStates = supportedExecutionStates;
  }
}
