// Generated by delombok at Sat Jan 13 17:06:53 EST 2024
package io.github.qsy7.queue.api.model;

import java.time.LocalDateTime;
import javax.jdo.annotations.PersistenceCapable;

/**
 * A QueuedJob represents an instance of a scheduled queuedJob execution 1. what executor should be
 * used 2. what parameter (entityReference) should be used: TODO: support multiple resources 3. when
 * to run (immediately, @ date/time, or cron expression)
 */
@PersistenceCapable
public class QueuedJob extends AbstractQueued {
  protected ScheduleInstance scheduleInstance;

  /**
   * Used for jobs that run once "NOW"
   */
  public QueuedJob(Class jobExecutorClass) {
    this(jobExecutorClass, null);
  }

  public QueuedJob(Class jobExecutorClass, ScheduleInstance scheduleInstance) {
    this(jobExecutorClass, scheduleInstance, false);
  }

  public QueuedJob(Class jobExecutorClass, ScheduleInstance scheduleInstance, final boolean system) {
    this();
    this.jobExecutorClass = jobExecutorClass;
    this.scheduleInstance = scheduleInstance;
    this.queueDateTime = LocalDateTime.now();
    this.system = system;
  }

  @java.lang.SuppressWarnings("all")
  public QueuedJob() {
  }

  @java.lang.SuppressWarnings("all")
  public ScheduleInstance getScheduleInstance() {
    return this.scheduleInstance;
  }

  @java.lang.SuppressWarnings("all")
  public void setScheduleInstance(final ScheduleInstance scheduleInstance) {
    this.scheduleInstance = scheduleInstance;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof QueuedJob)) return false;
    final QueuedJob other = (QueuedJob) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$scheduleInstance = this.getScheduleInstance();
    final java.lang.Object other$scheduleInstance = other.getScheduleInstance();
    if (this$scheduleInstance == null ? other$scheduleInstance != null : !this$scheduleInstance.equals(other$scheduleInstance)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof QueuedJob;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $scheduleInstance = this.getScheduleInstance();
    result = result * PRIME + ($scheduleInstance == null ? 43 : $scheduleInstance.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "QueuedJob(scheduleInstance=" + this.scheduleInstance + ")";
  }
  //  public ExecutionState getJobState() {
  //    final ExecutionState jobState = super.getJobState();
  //
  //    if (scheduleInstance.isRecurring()) return RecurringJobStateMapping.translate(jobState);
  //
  //    return jobState;
  //  }
}
