/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.api.enumeration;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import java.util.Arrays;

public enum ActionType {
    Cancel("Job Executions in one of these states may be cancelled.", new ExecutionState[]{ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running}),
    Assign("Job Executions in one of these states may be assigned to a worker", new ExecutionState[]{ExecutionState.Queued}),
    RecurringAssign("Job Executions in one of these states may be assigned to a worker (for recurring jobs only)", new ExecutionState[]{ExecutionState.Completed, ExecutionState.Cancelled, ExecutionState.Aborted, ExecutionState.Exception}),
    Aborted("Job Executions in one of these states may be aborted, provided the current time is > the timeoutDateTime for the execution", new ExecutionState[]{ExecutionState.Queued, ExecutionState.Assigned, ExecutionState.Scheduled, ExecutionState.Running});

    private final String description;
    private final ExecutionState[] supportedExecutionStates;

    /*
     * WARNING - void declaration
     */
    public boolean isSupported(ExecutionState executionState) {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"isSupported", (Object[])new Object[]{executionState});
        ActionType actionType = this;
        ExecutionState executionState2 = executionState;
        ActionType actionType2 = actionType;
        ExecutionState executionState3 = executionState2;
        try {
            void executionState4;
            bl = Arrays.stream(actionType2.supportedExecutionStates).filter(arg_0 -> ActionType.lambda$isSupported$0((ExecutionState)executionState4, arg_0)).count() > 0L;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        executionState3 = null;
        if (executionState3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"isSupported", (Object[])new Object[]{executionState2}, (Throwable)((Object)executionState3));
        }
        if (executionState3 != null) {
            throw executionState3;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"isSupported", (Object[])new Object[]{executionState}, (Object)bl2, (long)l);
        return bl2;
    }

    public String getDescription() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getDescription", (Object[])new Object[0]);
        ActionType actionType = this;
        Object object = actionType;
        try {
            object = object.description;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public ExecutionState[] getSupportedExecutionStates() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"getSupportedExecutionStates", (Object[])new Object[0]);
        ExecutionState[] executionStateArray = this;
        ExecutionState[] executionStateArray2 = executionStateArray;
        try {
            executionStateArray2 = executionStateArray2.supportedExecutionStates;
            return executionStateArray2;
        }
        finally {
            Throwable throwable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ActionType(String string2, ExecutionState[] executionStateArray) {
        void supportedExecutionStates;
        void description;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"<init>", (Object[])new Object[]{string, n, string2, executionStateArray});
        ActionType actionType = this;
        String string3 = string;
        int n2 = n;
        String string4 = string2;
        ExecutionState[] executionStateArray2 = executionStateArray;
        actionType.description = description;
        actionType.supportedExecutionStates = supportedExecutionStates;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.enumeration.ActionType", (String)"<init>", (Object[])new Object[]{string, n, string2, executionStateArray}, null, (long)l);
    }

    private static /* synthetic */ boolean lambda$isSupported$0(ExecutionState executionState, ExecutionState supportedExecutionState) {
        return supportedExecutionState.equals((Object)executionState);
    }
}

