// Generated by delombok at Mon Dec 16 16:49:23 EST 2019
package io.github.qsy7.queue.impl.worker.enumeration;

import io.github.qsy7.queue.api.annotation.scheduling.AtDateAndTime;
import io.github.qsy7.queue.api.annotation.scheduling.Cron;
import io.github.qsy7.queue.api.annotation.scheduling.FixedDelay;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.model.QueuedJob;
import io.github.qsy7.queue.impl.worker.builder.AtDateAndTimeScheduleInstanceBuilder;
import io.github.qsy7.queue.impl.worker.builder.CronScheduleInstanceBuilder;
import io.github.qsy7.queue.impl.worker.builder.FixedDelayScheduleInstanceBuilder;
import io.github.qsy7.queue.impl.worker.builder.ScheduleInstanceBuilder;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public enum ScheduleType {
  Now(null, null) {
    public void queue(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, QueuedJob queuedJob, AbstractRunnable runnable) {
      scheduledThreadPoolExecutor.submit(runnable);
    }
  },
  AtDateTimeSchedule(AtDateAndTime.class, new AtDateAndTimeScheduleInstanceBuilder()) {
    public void queue(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, QueuedJob queuedJob, AbstractRunnable runnable) {
      scheduledThreadPoolExecutor.schedule(runnable, queuedJob.getScheduleInstance().getInitialDelay(), queuedJob.getScheduleInstance().getUnits());
    }
  },
  CronSchedule(Cron.class, new CronScheduleInstanceBuilder()) {
    public void queue(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, QueuedJob queuedJob, AbstractRunnable runnable) {
      throw new UnsupportedOperationException("Not implemented");
    }
  },
  FixedDelaySchedule(FixedDelay.class, new FixedDelayScheduleInstanceBuilder()) {
    public void queue(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, QueuedJob queuedJob, AbstractRunnable runnable) {
      scheduledThreadPoolExecutor.scheduleWithFixedDelay(runnable, queuedJob.getScheduleInstance().getInitialDelay(), queuedJob.getScheduleInstance().getFixedDelay(), queuedJob.getScheduleInstance().getUnits());
    }
  };
  private final Class annotationClass;
  private final ScheduleInstanceBuilder scheduleInstanceBuilder;

  ScheduleType(Class annotationClass, ScheduleInstanceBuilder scheduleInstanceBuilder) {
    this.annotationClass = annotationClass;
    this.scheduleInstanceBuilder = scheduleInstanceBuilder;
  }

  public static ScheduleType get(final Class annotationClass) {
    for (final ScheduleType scheduleType : values()) {
      if (scheduleType.annotationClass.equals(annotationClass)) return scheduleType;
    }
    throw new IllegalStateException(annotationClass + " is not currently supported.");
  }

  public abstract void queue(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, QueuedJob queuedJob, AbstractRunnable runnable);

  @java.lang.SuppressWarnings("all")
  public Class getAnnotationClass() {
    return this.annotationClass;
  }

  @java.lang.SuppressWarnings("all")
  public ScheduleInstanceBuilder getScheduleInstanceBuilder() {
    return this.scheduleInstanceBuilder;
  }
}
