/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.worker;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.property.api.enumeration.NoOperation;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.job.RunningFuture;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.model.Worker;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.impl.worker.builder.JobBuilder;
import io.github.qsy7.queue.impl.worker.property.ExecutorServiceShutdownTimeoutUnits;
import io.github.qsy7.queue.impl.worker.property.ExecutorServiceShutdownTimeoutValue;
import io.github.qsy7.queue.impl.worker.scheduler.Scheduler;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class DefaultJobWorkerService
implements JobWorkerService,
AutoCloseable {
    protected final boolean noOperation;
    protected final long shutdownTimeout;
    protected final TimeUnit shutdownTimeoutUnits;
    protected final JobBuilder jobBuilder;
    protected final Worker worker;
    protected final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    protected boolean shutdown;
    protected final Set<RunningFuture> runningFutures;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultJobWorkerService(@Property(value=NoOperation.class) boolean bl, @Property(value=ExecutorServiceShutdownTimeoutValue.class) long l, @Property(value=ExecutorServiceShutdownTimeoutUnits.class) TimeUnit timeUnit, JobBuilder jobBuilder, Worker worker) {
        void jobBuilder2;
        void shutdownTimeoutUnits;
        AutoCloseable autoCloseable = this;
        boolean bl2 = bl;
        long l2 = l;
        TimeUnit timeUnit2 = timeUnit;
        JobBuilder jobBuilder3 = jobBuilder;
        Worker worker2 = worker;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"<init>", (Object[])new Object[]{bl2, l2, timeUnit2, jobBuilder3, worker2});
        DefaultJobWorkerService defaultJobWorkerService = autoCloseable;
        boolean bl3 = bl2;
        long l4 = l2;
        TimeUnit timeUnit3 = timeUnit2;
        JobBuilder jobBuilder4 = jobBuilder3;
        Worker worker3 = worker2;
        defaultJobWorkerService.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2);
        defaultJobWorkerService.runningFutures = new ConcurrentSkipListSet<RunningFuture>();
        defaultJobWorkerService.noOperation = shutdownTimeoutUnits;
        defaultJobWorkerService.shutdownTimeout = jobBuilder2;
        defaultJobWorkerService.shutdownTimeoutUnits = timeUnit3;
        defaultJobWorkerService.jobBuilder = jobBuilder4;
        defaultJobWorkerService.worker = worker3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"<init>", (Object[])new Object[]{bl2, l2, timeUnit2, jobBuilder3, worker2}, null, (long)l3);
        autoCloseable = this;
        CloseableUtil.addAutoCloseable((AutoCloseable)autoCloseable);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"close", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        defaultJobWorkerService.scheduledThreadPoolExecutor.shutdown();
        try {
            if (!defaultJobWorkerService.scheduledThreadPoolExecutor.awaitTermination(defaultJobWorkerService.shutdownTimeout, defaultJobWorkerService.shutdownTimeoutUnits)) {
                defaultJobWorkerService.updateCancelledJobs();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Error during shutdown", interruptedException);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    protected void updateCancelledJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"updateCancelledJobs", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        defaultJobWorkerService.scheduledThreadPoolExecutor.shutdownNow().stream().forEach(runnable -> this.handleRemovalOfRunnable((Runnable)runnable));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"updateCancelledJobs", (Object[])new Object[0], null, (long)l);
    }

    protected void handleRemovalOfRunnable(Runnable runnable) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"handleRemovalOfRunnable", (Object[])new Object[]{runnable});
        DefaultJobWorkerService defaultJobWorkerService = this;
        Runnable runnable2 = runnable;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"handleRemovalOfRunnable", (Object[])new Object[]{runnable}, null, (long)l);
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        if (defaultJobWorkerService.isShutdown()) {
            throw new IllegalStateException("Executor service is shutting down");
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractQueued queue(AbstractQueued abstractQueued) {
        AbstractQueued abstractQueued2;
        void queued;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"queue", (Object[])new Object[]{abstractQueued});
        DefaultJobWorkerService defaultJobWorkerService = this;
        AbstractQueued abstractQueued3 = abstractQueued;
        queued.checkIfShutdown();
        if (queued.isNoOperation()) {
            abstractQueued2 = abstractQueued3;
        } else {
            queued.doQueue(abstractQueued3);
            abstractQueued2 = abstractQueued3;
        }
        defaultJobWorkerService = abstractQueued2;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"queue", (Object[])new Object[]{abstractQueued}, (Object)defaultJobWorkerService, (long)l);
        return defaultJobWorkerService;
    }

    /*
     * WARNING - void declaration
     */
    protected void doQueue(AbstractQueued abstractQueued) {
        void runnable;
        void scheduler;
        void queued;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"doQueue", (Object[])new Object[]{abstractQueued});
        DefaultJobWorkerService defaultJobWorkerService = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        AbstractRunnable abstractRunnable = queued.jobBuilder.prepareCallableJob(abstractQueued2);
        Scheduler scheduler2 = null;
        Future future = scheduler2.schedule(queued.scheduledThreadPoolExecutor, (AbstractRunnable)scheduler, runnable);
        RunningFuture runningFuture = new RunningFuture(future, runnable.getId().intValue(), runnable.getCurrentJobExecution().getId().intValue(), scheduler.hashCode());
        queued.runningFutures.add(runningFuture);
        scheduler.setRunningFuture(runningFuture);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"doQueue", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void cancel(AbstractQueued abstractQueued) {
        void queued;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{abstractQueued});
        DefaultJobWorkerService defaultJobWorkerService = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        Optional<RunningFuture> optional = queued.runningFutures.stream().filter(runningFuture -> runningFuture.getQueuedId() == abstractQueued2.getId().intValue()).findFirst();
        if (!optional.isPresent()) {
            void runningFutureOptional;
            throw new IllegalStateException("Requested queued is not present and must have already completed or failed:" + (AbstractQueued)runningFutureOptional);
        }
        optional.get().getFuture().cancel(true);
        queued.remove(optional.get());
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void cancel(JobExecution jobExecution) {
        void jobExecution2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{jobExecution});
        DefaultJobWorkerService defaultJobWorkerService = this;
        JobExecution jobExecution3 = jobExecution;
        Optional<RunningFuture> optional = jobExecution2.runningFutures.stream().filter(runningFuture -> runningFuture.getExecutionId() == jobExecution3.getId().intValue()).findFirst();
        if (!optional.isPresent()) {
            void runningFutureOptional;
            throw new IllegalStateException("Requested job execution is not present and must have already completed or failed:" + (JobExecution)runningFutureOptional);
        }
        optional.get().getFuture().cancel(true);
        jobExecution2.remove(optional.get());
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{jobExecution}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void remove(RunningFuture runningFuture) {
        void runningFuture2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"remove", (Object[])new Object[]{runningFuture});
        DefaultJobWorkerService defaultJobWorkerService = this;
        RunningFuture runningFuture3 = runningFuture;
        runningFuture2.runningFutures.remove(runningFuture3);
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"remove", (Object[])new Object[]{runningFuture}, null, (long)l);
    }

    public boolean isNoOperation() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isNoOperation", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        boolean bl = defaultJobWorkerService.noOperation;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isNoOperation", (Object[])new Object[0], (Object)bl, (long)l);
        return bl;
    }

    public long getShutdownTimeout() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeout", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        long l2 = defaultJobWorkerService.shutdownTimeout;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeout", (Object[])new Object[0], (Object)l2, (long)l);
        return l2;
    }

    public TimeUnit getShutdownTimeoutUnits() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeoutUnits", (Object[])new Object[0]);
        Object object = this;
        object = object.shutdownTimeoutUnits;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeoutUnits", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public JobBuilder getJobBuilder() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getJobBuilder", (Object[])new Object[0]);
        Object object = this;
        object = ((DefaultJobWorkerService)object).jobBuilder;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getJobBuilder", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public Worker getWorker() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getWorker", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        defaultJobWorkerService = defaultJobWorkerService.worker;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getWorker", (Object[])new Object[0], (Object)defaultJobWorkerService, (long)l);
        return defaultJobWorkerService;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getScheduledThreadPoolExecutor", (Object[])new Object[0]);
        AutoCloseable autoCloseable = this;
        autoCloseable = autoCloseable.scheduledThreadPoolExecutor;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getScheduledThreadPoolExecutor", (Object[])new Object[0], (Object)autoCloseable, (long)l);
        return autoCloseable;
    }

    public boolean isShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isShutdown", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        boolean bl = defaultJobWorkerService.shutdown;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isShutdown", (Object[])new Object[0], (Object)bl, (long)l);
        return bl;
    }

    public Set<RunningFuture> getRunningFutures() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getRunningFutures", (Object[])new Object[0]);
        Object object = this;
        object = ((DefaultJobWorkerService)object).runningFutures;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getRunningFutures", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }
}

