/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.worker;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.annotation.JobExecutionConfiguration;
import io.github.qsy7.queue.api.annotation.scheduling.FixedDelay;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.api.service.QueueService;

@Job(jobExecutionConfiguration=@JobExecutionConfiguration(system=true), fixedDelay={@FixedDelay(fixedDelay=60L)})
public class WorkerSchedulerRunnable
extends AbstractRunnable {
    protected final QueueService queueService;
    protected final JobWorkerService jobWorkerService;

    protected void doCall() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"doCall", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        workerSchedulerRunnable.markJobExecutionAsAborted();
        workerSchedulerRunnable.rescheduleJobs();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"doCall", (Object[])new Object[0], null, (long)l);
    }

    protected void markJobExecutionAsAborted() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        workerSchedulerRunnable.queueService.findAbortedJobExecutions().forEach(queuedJob -> this.markJobExecutionAsAborted((AbstractQueued)queuedJob));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void markJobExecutionAsAborted(AbstractQueued abstractQueued) {
        void queued;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[]{abstractQueued});
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        ((JobExecution)abstractQueued2.getJobExecutions().get(abstractQueued2.getJobExecutions().size() - 1)).setExecutionState(ExecutionState.Aborted);
        queued.queueService.update(abstractQueued2);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    protected void rescheduleJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"rescheduleJobs", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        workerSchedulerRunnable.queueService.findAssignable().forEach(queuedJob -> this.jobWorkerService.queue(queuedJob));
        workerSchedulerRunnable.queueService.findRecurringAssignable().forEach(queuedJob -> this.jobWorkerService.queue(queuedJob));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"rescheduleJobs", (Object[])new Object[0], null, (long)l);
    }

    public QueueService getQueueService() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getQueueService", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        workerSchedulerRunnable = workerSchedulerRunnable.queueService;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getQueueService", (Object[])new Object[0], (Object)((Object)workerSchedulerRunnable), (long)l);
        return workerSchedulerRunnable;
    }

    public JobWorkerService getJobWorkerService() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getJobWorkerService", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        workerSchedulerRunnable = workerSchedulerRunnable.jobWorkerService;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getJobWorkerService", (Object[])new Object[0], (Object)((Object)workerSchedulerRunnable), (long)l);
        return workerSchedulerRunnable;
    }

    /*
     * WARNING - void declaration
     */
    public WorkerSchedulerRunnable(QueueService queueService, JobWorkerService jobWorkerService) {
        void jobWorkerService2;
        void queueService2;
        Object object = this;
        QueueService queueService3 = queueService;
        JobWorkerService jobWorkerService3 = jobWorkerService;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"<init>", (Object[])new Object[]{queueService3, jobWorkerService3});
        WorkerSchedulerRunnable workerSchedulerRunnable = object;
        QueueService queueService4 = queueService3;
        JobWorkerService jobWorkerService4 = jobWorkerService3;
        queueService2.queueService = jobWorkerService2;
        queueService2.jobWorkerService = jobWorkerService4;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"<init>", (Object[])new Object[]{queueService3, jobWorkerService3}, null, (long)l);
        object = (AutoCloseable)((Object)this);
        CloseableUtil.addAutoCloseable((AutoCloseable)object);
    }
}

