/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.worker;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.annotation.JobExecutionConfiguration;
import io.github.qsy7.queue.api.annotation.scheduling.FixedDelay;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.api.service.QueueService;

@Job(jobExecutionConfiguration=@JobExecutionConfiguration(system=true), fixedDelay={@FixedDelay(fixedDelay=60L)})
public class WorkerSchedulerRunnable
extends AbstractRunnable {
    protected final QueueService queueService;
    protected final JobWorkerService jobWorkerService;

    protected void doCall() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"doCall", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        try {
            workerSchedulerRunnable2.markJobExecutionAsAborted();
            workerSchedulerRunnable2.rescheduleJobs();
            workerSchedulerRunnable2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (workerSchedulerRunnable2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"doCall", (Object[])new Object[0], (Throwable)((Object)workerSchedulerRunnable2));
        }
        if (workerSchedulerRunnable2 != null) {
            throw workerSchedulerRunnable2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"doCall", (Object[])new Object[0], null, (long)l);
    }

    protected void markJobExecutionAsAborted() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        try {
            workerSchedulerRunnable2.queueService.findAbortedJobExecutions().forEach(queuedJob -> this.markJobExecutionAsAborted((AbstractQueued)queuedJob));
            workerSchedulerRunnable2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (workerSchedulerRunnable2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[0], (Throwable)((Object)workerSchedulerRunnable2));
        }
        if (workerSchedulerRunnable2 != null) {
            throw workerSchedulerRunnable2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void markJobExecutionAsAborted(AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[]{abstractQueued});
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            ((JobExecution)queued.getJobExecutions().get(queued.getJobExecutions().size() - 1)).setExecutionState(ExecutionState.Aborted);
            workerSchedulerRunnable2.queueService.update((AbstractQueued)queued);
            workerSchedulerRunnable2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (workerSchedulerRunnable2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[]{abstractQueued2}, (Throwable)((Object)workerSchedulerRunnable2));
        }
        if (workerSchedulerRunnable2 != null) {
            throw workerSchedulerRunnable2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"markJobExecutionAsAborted", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    protected void rescheduleJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"rescheduleJobs", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        try {
            workerSchedulerRunnable2.queueService.findAssignable().forEach(queuedJob -> this.jobWorkerService.queue(queuedJob));
            workerSchedulerRunnable2.queueService.findRecurringAssignable().forEach(queuedJob -> this.jobWorkerService.queue(queuedJob));
            workerSchedulerRunnable2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (workerSchedulerRunnable2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"rescheduleJobs", (Object[])new Object[0], (Throwable)((Object)workerSchedulerRunnable2));
        }
        if (workerSchedulerRunnable2 != null) {
            throw workerSchedulerRunnable2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"rescheduleJobs", (Object[])new Object[0], null, (long)l);
    }

    public QueueService getQueueService() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getQueueService", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        try {
            workerSchedulerRunnable2 = workerSchedulerRunnable2.queueService;
            return workerSchedulerRunnable2;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public JobWorkerService getJobWorkerService() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"getJobWorkerService", (Object[])new Object[0]);
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        try {
            workerSchedulerRunnable2 = workerSchedulerRunnable2.jobWorkerService;
            return workerSchedulerRunnable2;
        }
        finally {
            Throwable throwable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public WorkerSchedulerRunnable(QueueService queueService, JobWorkerService jobWorkerService) {
        void jobWorkerService2;
        void queueService2;
        WorkerSchedulerRunnable workerSchedulerRunnable = this;
        QueueService queueService3 = queueService;
        JobWorkerService jobWorkerService3 = jobWorkerService;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"<init>", (Object[])new Object[]{queueService3, jobWorkerService3});
        WorkerSchedulerRunnable workerSchedulerRunnable2 = workerSchedulerRunnable;
        QueueService queueService4 = queueService3;
        JobWorkerService jobWorkerService4 = jobWorkerService3;
        workerSchedulerRunnable2.queueService = queueService2;
        workerSchedulerRunnable2.jobWorkerService = jobWorkerService2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.WorkerSchedulerRunnable", (String)"<init>", (Object[])new Object[]{queueService3, jobWorkerService3}, null, (long)l);
        CloseableUtil.addAutoCloseable((AutoCloseable)((AutoCloseable)((Object)this)));
    }
}

