package io.github.qsy7.shell.impl.service;

import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.dig.DigRequest;
import io.github.qsy7.shell.api.model.dig.DigRequestIPAddress;
import io.github.qsy7.shell.api.service.DigService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.DigTimeout;
import java.time.LocalDateTime;
import javax.inject.Inject;

public class DefaultDigService extends AbstractSingleShellCommandService<DigRequest>
    implements DigService {
  @Inject
  public DefaultDigService(
      ShellCommandBuilder shellCommandBuilder,
      ShellExecutionService shellExecutionService,
      @Property(DigTimeout.class) int timeout) {
    super(shellCommandBuilder, shellExecutionService, timeout);
  }

  protected void doAfter(DigRequest digRequest) {
    for (final CommandOutput commandOutput : digRequest.getShellCommand().getOutputs()) {
      digRequest.getDigRequestIPAddresses().add(getIPAddress(commandOutput, digRequest));
    }
  }

  protected DigRequestIPAddress getIPAddress(CommandOutput commandOutput, DigRequest digRequest) {
    return new DigRequestIPAddress(
        LocalDateTime.now(), new IPAddress(commandOutput.getOutput()), digRequest);
  }

  protected String getCommandLine(DigRequest digRequest) {
    return "dig -4 +short " + digRequest.getNetworkDiagnosticTest().getFqdn();
  }
}
