/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.model.ShellCommand;
import io.github.qsy7.shell.api.service.OutputCollector;
import io.github.qsy7.shell.impl.OutputCollectorConfiguration;
import io.github.qsy7.shell.impl.collector.InputConsumable;
import io.github.qsy7.shell.impl.collector.LoggerOutputCollector;
import io.github.qsy7.shell.impl.collector.ShellCommandOutputCollector;
import io.github.qsy7.timeout.TimeConstrainedMethodInvocation;
import io.github.qsy7.timeout.annotation.TimeConstrained;
import io.github.qsy7.timeout.impl.TimeConstrainedMethodCall;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.enterprise.util.AnnotationLiteral;

public abstract class AbstractProcessExecution
implements TimeConstrainedMethodInvocation,
AutoCloseable {
    protected final ShellCommand shellCommand;
    protected final Thread inputThread;
    protected final Thread errorThread;
    protected final OutputStream outputStream;
    protected final boolean requiresExplicitExit;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long interruptGracePeriodValue;

    /*
     * WARNING - void declaration
     */
    protected AbstractProcessExecution(ShellCommand shellCommand, InputStream inputStream, InputStream inputStream2, OutputStream outputStream, boolean bl, ChronoUnit chronoUnit, long l) {
        void interruptGracePeriodValue;
        void requiresExplicitExit;
        void outputStream2;
        void interruptGracePeriodUnits;
        void errorStream;
        void inputStream3;
        long l2 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"<init>", (Object[])new Object[]{shellCommand, inputStream, inputStream2, outputStream, bl, chronoUnit, l});
        AbstractProcessExecution abstractProcessExecution = this;
        ShellCommand shellCommand2 = shellCommand;
        InputStream inputStream4 = inputStream;
        InputStream inputStream5 = inputStream2;
        OutputStream outputStream3 = outputStream;
        boolean bl2 = bl;
        ChronoUnit chronoUnit2 = chronoUnit;
        long l3 = l;
        inputStream3.shellCommand = errorStream;
        inputStream3.outputStream = interruptGracePeriodUnits;
        inputStream3.inputThread = inputStream3.setupMonitoringThread((InputStream)outputStream2, false);
        inputStream3.errorThread = inputStream3.setupMonitoringThread((InputStream)requiresExplicitExit, true);
        inputStream3.requiresExplicitExit = interruptGracePeriodValue;
        inputStream3.interruptGracePeriodUnits = chronoUnit2;
        inputStream3.interruptGracePeriodValue = l3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"<init>", (Object[])new Object[]{shellCommand, inputStream, inputStream2, outputStream, bl, chronoUnit, l}, null, (long)l2);
    }

    /*
     * WARNING - void declaration
     */
    public Thread setupMonitoringThread(InputStream inputStream, boolean bl) {
        void inputStream2;
        void isError;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setupMonitoringThread", (Object[])new Object[]{inputStream, bl});
        Object object = this;
        InputStream inputStream3 = inputStream;
        boolean bl2 = bl;
        InputConsumable inputConsumable = new InputConsumable((InputStream)isError, bl2, inputStream2.getOutputCollectors());
        Thread thread = new Thread(inputConsumable);
        thread.start();
        object = thread;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setupMonitoringThread", (Object[])new Object[]{inputStream, bl}, (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected OutputCollector[] getOutputCollectors() {
        void outputCollectorConfiguration;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getOutputCollectors", (Object[])new Object[0]);
        OutputCollector[] outputCollectorArray = this;
        OutputCollectorConfiguration outputCollectorConfiguration2 = null;
        outputCollectorArray = outputCollectorConfiguration2 == null ? outputCollectorConfiguration.registerDefaultOutputCollectors() : outputCollectorConfiguration.registerConfiguredOutputCollectors(outputCollectorConfiguration2);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getOutputCollectors", (Object[])new Object[0], (Object)outputCollectorArray, (long)l);
        return outputCollectorArray;
    }

    protected OutputCollector[] registerDefaultOutputCollectors() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerDefaultOutputCollectors", (Object[])new Object[0]);
        OutputCollector[] outputCollectorArray = this;
        outputCollectorArray = new OutputCollector[]{new ShellCommandOutputCollector(outputCollectorArray.shellCommand), new LoggerOutputCollector(outputCollectorArray.getClass(), outputCollectorArray.shellCommand.getCommandLine())};
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerDefaultOutputCollectors", (Object[])new Object[0], (Object)outputCollectorArray, (long)l);
        return outputCollectorArray;
    }

    /*
     * WARNING - void declaration
     */
    protected OutputCollector[] registerConfiguredOutputCollectors(OutputCollectorConfiguration outputCollectorConfiguration) {
        void i;
        void outputCollectors;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerConfiguredOutputCollectors", (Object[])new Object[]{outputCollectorConfiguration});
        AbstractProcessExecution abstractProcessExecution = this;
        OutputCollectorConfiguration outputCollectorConfiguration2 = outputCollectorConfiguration;
        OutputCollector[] outputCollectorArray = new OutputCollector[outputCollectorConfiguration2.getOutputCollectorClasses().size()];
        int n = 0;
        for (Class<? extends OutputCollector> clazz : outputCollectors.getOutputCollectorClasses()) {
            i[n++] = (OutputCollector)ApplicationHelper.getApplicationInstance().getInjector().getInstance(clazz, new AnnotationLiteral[0]);
        }
        abstractProcessExecution = i;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"registerConfiguredOutputCollectors", (Object[])new Object[]{outputCollectorConfiguration}, (Object)abstractProcessExecution, (long)l);
        return abstractProcessExecution;
    }

    /*
     * WARNING - void declaration
     */
    protected void setTimeout() throws Exception {
        void timeout;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setTimeout", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        int n = abstractProcessExecution.getTimeout();
        if (timeout.getTimeout() > 0) {
            timeout.doSetTimeout(n);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setTimeout", (Object[])new Object[0], null, (long)l);
    }

    protected abstract void doSetTimeout(int var1) throws Exception;

    protected abstract int getTimeout();

    protected abstract int getReturnCode() throws InterruptedException;

    /*
     * WARNING - void declaration
     */
    protected void kill(Exception exception) throws IOException, InterruptedException {
        void e;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"kill", (Object[])new Object[]{exception});
        AbstractProcessExecution abstractProcessExecution = this;
        Exception exception2 = exception;
        e.outputStream.write(3);
        e.outputStream.flush();
        Thread.sleep(1000L);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"kill", (Object[])new Object[]{exception}, null, (long)l);
    }

    @TimeConstrained
    public void run() throws IOException, InterruptedException {
        Object object;
        TimeConstrainedMethodCall timeConstrainedMethodCall;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"run", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        TimeConstrainedMethodInvocation timeConstrainedMethodInvocation = abstractProcessExecution;
        if (timeConstrainedMethodInvocation.getAllowedExecutionDuration() == null) {
            timeConstrainedMethodCall = null;
        } else {
            object = timeConstrainedMethodInvocation.getAllowedExecutionDuration();
            timeConstrainedMethodCall = new TimeConstrainedMethodCall((Duration)object);
        }
        timeConstrainedMethodInvocation = timeConstrainedMethodCall;
        object = abstractProcessExecution;
        ((AbstractProcessExecution)object).doRun();
        ((AbstractProcessExecution)object).setReturnCode();
        ((AbstractProcessExecution)object).syncInputs();
        if (timeConstrainedMethodInvocation != null) {
            timeConstrainedMethodInvocation.cancelInterruption();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"run", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"close", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        abstractProcessExecution.inputThread.interrupt();
        abstractProcessExecution.errorThread.interrupt();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    public Duration getAllowedExecutionDuration() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getAllowedExecutionDuration", (Object[])new Object[0]);
        Object object = this;
        object = Duration.of(((AbstractProcessExecution)object).getTimeout(), ChronoUnit.SECONDS);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"getAllowedExecutionDuration", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    protected void doRun() throws IOException, InterruptedException {
        void e;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"doRun", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        try {
            abstractProcessExecution.setTimeout();
            if (abstractProcessExecution.requiresExplicitExit) {
                abstractProcessExecution.exitAfterCompletionOfCommand();
            }
        }
        catch (IOException iOException) {
            if (e.exitedButNotCleanly(iOException)) {
                e.kill(iOException);
            }
        }
        catch (Exception exception) {
            e.kill(exception);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"doRun", (Object[])new Object[0], null, (long)l);
    }

    protected void exitAfterCompletionOfCommand() throws IOException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitAfterCompletionOfCommand", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        abstractProcessExecution.outputStream.write("\nexit\n".getBytes(Charset.defaultCharset()));
        abstractProcessExecution.outputStream.flush();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitAfterCompletionOfCommand", (Object[])new Object[0], null, (long)l);
    }

    protected boolean exitedButNotCleanly(Exception exception) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitedButNotCleanly", (Object[])new Object[]{exception});
        AbstractProcessExecution abstractProcessExecution = this;
        Exception exception2 = exception;
        boolean bl = !exception2.getMessage().contains("Stream closed") && !exception2.getMessage().contains("Broken pipe");
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"exitedButNotCleanly", (Object[])new Object[]{exception}, (Object)bl, (long)l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void setReturnCode() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setReturnCode", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        try {
            abstractProcessExecution.shellCommand.setReturnCode(abstractProcessExecution.getReturnCode());
        }
        catch (Exception exception) {
            void e;
            e.shellCommand.setReturnCode(-1);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"setReturnCode", (Object[])new Object[0], null, (long)l);
    }

    protected void syncInputs() throws InterruptedException {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"syncInputs", (Object[])new Object[0]);
        AbstractProcessExecution abstractProcessExecution = this;
        abstractProcessExecution.inputThread.join();
        abstractProcessExecution.errorThread.join();
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.AbstractProcessExecution", (String)"syncInputs", (Object[])new Object[0], null, (long)l);
    }
}

