/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.MountAction;
import io.github.qsy7.shell.api.enumeration.VFSType;
import io.github.qsy7.shell.api.model.MountCommand;
import io.github.qsy7.shell.api.model.MountPoint;
import io.github.qsy7.shell.api.service.MountService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.impl.property.MountTimeout;
import io.github.qsy7.shell.impl.service.AbstractMultipleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DefaultMountService
extends AbstractMultipleShellCommandService<MountCommand>
implements MountService {
    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultMountService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=MountTimeout.class) int n) {
        void timeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultMountService defaultMountService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellCommandBuilder2, (ShellExecutionService)shellExecutionService2, (int)timeout);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBefore(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBefore", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        try {
            void mountCommand4;
            super.doBefore(mountCommand4);
            mountCommand4.setTimeout(defaultMountService2.timeout);
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBefore", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBefore", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doBeforeEach(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBeforeEach", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        try {
            void mountCommand4;
            if (MountAction.Mount.equals((Object)mountCommand4.getMountAction())) {
                defaultMountService2.prepareDevice(mountCommand4.getMountPoint());
                defaultMountService2.prepareTarget(mountCommand4.getMountPoint(), mountCommand4.getRootPath());
            }
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBeforeEach", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doBeforeEach", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareDevice(MountPoint mountPoint) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareDevice", (Object[])new Object[]{mountPoint});
        DefaultMountService defaultMountService = this;
        MountPoint mountPoint2 = mountPoint;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountPoint mountPoint3 = mountPoint2;
        try {
            File deviceFile;
            void mountPoint4;
            if (!"none".equals(mountPoint4.getDevice()) && !(deviceFile = new File(defaultMountService2.getDevice(mountPoint4.getDevice()))).exists()) {
                deviceFile.mkdirs();
            }
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareDevice", (Object[])new Object[]{mountPoint2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareDevice", (Object[])new Object[]{mountPoint}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void prepareTarget(MountPoint mountPoint, String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareTarget", (Object[])new Object[]{mountPoint, string});
        DefaultMountService defaultMountService = this;
        MountPoint mountPoint2 = mountPoint;
        String string2 = string;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountPoint mountPoint3 = mountPoint2;
        String string3 = string2;
        try {
            void mountPoint4;
            void rootPath;
            File mountPointFile = new File((String)rootPath + mountPoint4.getMountPoint());
            if (!mountPointFile.exists()) {
                mountPointFile.mkdirs();
            }
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareTarget", (Object[])new Object[]{mountPoint2, string2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"prepareTarget", (Object[])new Object[]{mountPoint, string}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String[] getCommandLines(MountCommand mountCommand) {
        String[] stringArray;
        MountCommand mountCommand2;
        String[] stringArray2;
        MountCommand mountCommand3;
        String[] stringArray3;
        long l;
        block9: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getCommandLines", (Object[])new Object[]{mountCommand});
            stringArray3 = this;
            mountCommand3 = mountCommand;
            stringArray2 = stringArray3;
            mountCommand2 = mountCommand3;
            try {
                void mountCommand4;
                if (MountAction.Unmount.equals((Object)mountCommand4.getMountAction())) {
                    if (VFSType.RBIND.equals((Object)mountCommand4.getMountPoint().getVfsType())) {
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = "umount -R " + mountCommand4.getRootPath() + mountCommand4.getMountPoint().getMountPoint();
                    } else {
                        String[] stringArray5 = new String[1];
                        stringArray = stringArray5;
                        stringArray5[0] = "umount " + mountCommand4.getRootPath() + mountCommand4.getMountPoint().getMountPoint();
                    }
                    break block9;
                }
                if (MountAction.Mount.equals((Object)mountCommand4.getMountAction())) {
                    ArrayList<String> commandLines = new ArrayList<String>();
                    for (List arguments : mountCommand4.getMountPoint().getVfsType().getArguments(mountCommand4.getMountPoint(), stringArray2.getDevice(mountCommand4.getMountPoint().getDevice()), mountCommand4.getRootPath())) {
                        commandLines.add(String.join((CharSequence)" ", arguments.toArray(new String[arguments.size()])));
                    }
                    stringArray = commandLines.toArray(new String[commandLines.size()]);
                    break block9;
                }
                throw new IllegalArgumentException("Remounting is not currently supported.");
            }
            catch (Throwable throwable) {
                stringArray2 = null;
            }
        }
        stringArray2 = stringArray;
        mountCommand2 = null;
        if (mountCommand2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getCommandLines", (Object[])new Object[]{mountCommand3}, (Throwable)mountCommand2);
        }
        if (mountCommand2 != null) {
            throw mountCommand2;
        }
        stringArray3 = stringArray2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getCommandLines", (Object[])new Object[]{mountCommand}, (Object)stringArray3, (long)l);
        return stringArray3;
    }

    /*
     * WARNING - void declaration
     */
    protected String getDevice(String string) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getDevice", (Object[])new Object[]{string});
        DefaultMountService defaultMountService = this;
        String string2 = string;
        DefaultMountService defaultMountService2 = defaultMountService;
        String string3 = string2;
        try {
            void device;
            defaultMountService2 = System.getProperty("~/") != null && !System.getProperty("~/").isEmpty() ? device.replace("~/", System.getProperty("~/") + File.separator) : device;
        }
        catch (Throwable throwable) {
            defaultMountService2 = null;
        }
        string3 = null;
        if (string3 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getDevice", (Object[])new Object[]{string2}, (Throwable)((Object)string3));
        }
        if (string3 != null) {
            throw string3;
        }
        defaultMountService = defaultMountService2;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"getDevice", (Object[])new Object[]{string}, (Object)defaultMountService, (long)l);
        return defaultMountService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doAfter", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        try {
            void mountCommand4;
            super.doAfter(mountCommand4);
            defaultMountService2.ensureTmpfsIsGloballyReadableAndWritable((MountCommand)mountCommand4);
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doAfter", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"doAfter", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureTmpfsIsGloballyReadableAndWritable(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritable", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        try {
            void mountCommand4;
            if (VFSType.TMPFS.equals((Object)mountCommand4.getMountPoint().getVfsType())) {
                defaultMountService2.ensureTmpfsIsGloballyReadableAndWritableCli((MountCommand)mountCommand4);
                defaultMountService2.ensureTmpfsIsGloballyReadableAndWritableNative((MountCommand)mountCommand4);
            }
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritable", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritable", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void ensureTmpfsIsGloballyReadableAndWritableNative(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableNative", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        try {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            try {
                void mountCommand4;
                Files.setPosixFilePermissions(new File(mountCommand4.getRootPath() + File.separator + mountCommand4.getMountPoint().getMountPoint()).toPath(), permissions);
            }
            catch (IOException e) {
                throw new RuntimeException("Error fixing permissions", e);
            }
            defaultMountService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableNative", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableNative", (Object[])new Object[]{mountCommand}, null, (long)l);
    }

    protected void ensureTmpfsIsGloballyReadableAndWritableCli(MountCommand mountCommand) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableCli", (Object[])new Object[]{mountCommand});
        DefaultMountService defaultMountService = this;
        MountCommand mountCommand2 = mountCommand;
        DefaultMountService defaultMountService2 = defaultMountService;
        MountCommand mountCommand3 = mountCommand2;
        defaultMountService2 = null;
        if (defaultMountService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableCli", (Object[])new Object[]{mountCommand2}, (Throwable)((Object)defaultMountService2));
        }
        if (defaultMountService2 != null) {
            throw defaultMountService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultMountService", (String)"ensureTmpfsIsGloballyReadableAndWritableCli", (Object[])new Object[]{mountCommand}, null, (long)l);
    }
}

