/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.IPAddress;
import io.github.qsy7.shell.api.model.traceroute.TracerouteHop;
import io.github.qsy7.shell.api.model.traceroute.TracerouteRequest;
import io.github.qsy7.shell.api.model.traceroute.TracrouteHopResponse;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.api.service.TracerouteService;
import io.github.qsy7.shell.impl.property.TracerouteTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultTracerouteService
extends AbstractSingleShellCommandService<TracerouteRequest>
implements TracerouteService {
    private static final Pattern TRACEROUTE_OUTPUT_PATTERN = Pattern.compile("^([\\d]{1,})  ([\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3})  (.*)$");

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultTracerouteService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, @Property(value=TracerouteTimeout.class) int n) {
        void timeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n});
        DefaultTracerouteService defaultTracerouteService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        int n2 = n;
        super((ShellCommandBuilder)shellCommandBuilder2, (ShellExecutionService)shellExecutionService2, (int)timeout);
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, n}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCommandLine(TracerouteRequest tracerouteRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"getCommandLine", (Object[])new Object[]{tracerouteRequest});
        DefaultTracerouteService defaultTracerouteService = this;
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        Object object = defaultTracerouteService;
        TracerouteRequest tracerouteRequest3 = tracerouteRequest2;
        try {
            void tracerouteRequest4;
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("sudo");
            arguments.add("traceroute");
            arguments.add("-I");
            if (tracerouteRequest4.isIpv4()) {
                arguments.add("-4");
            } else {
                arguments.add("-6");
            }
            if (tracerouteRequest4.getMaxHops() > 0) {
                arguments.add("-m");
                arguments.add(Integer.toString(tracerouteRequest4.getMaxHops()));
            }
            if (tracerouteRequest4.isNoFragment()) {
                arguments.add("-F");
            }
            if (tracerouteRequest4.getQueriesPerHop() > 0) {
                arguments.add("-q");
                arguments.add(Integer.toString(tracerouteRequest4.getQueriesPerHop()));
            }
            arguments.add("-n");
            arguments.add(tracerouteRequest4.getNetworkDiagnosticTest().getFqdn());
            object = String.join((CharSequence)" ", arguments.toArray(new String[arguments.size()]));
            return object;
        }
        finally {
            tracerouteRequest3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doAfter(TracerouteRequest tracerouteRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"doAfter", (Object[])new Object[]{tracerouteRequest});
        DefaultTracerouteService defaultTracerouteService = this;
        TracerouteRequest tracerouteRequest2 = tracerouteRequest;
        DefaultTracerouteService defaultTracerouteService2 = defaultTracerouteService;
        TracerouteRequest tracerouteRequest3 = tracerouteRequest2;
        try {
            void tracerouteRequest4;
            int index = 0;
            for (CommandOutput commandOutput : tracerouteRequest4.getShellCommand().getOutputs()) {
                if (index <= 0) continue;
                String line = commandOutput.getOutput().trim().replace("ms", "");
                Matcher matcher = TRACEROUTE_OUTPUT_PATTERN.matcher(line);
                if (matcher.matches()) {
                    TracerouteHop tracerouteHop = new TracerouteHop((TracerouteRequest)tracerouteRequest4, index, null, new IPAddress(matcher.group(2)));
                    tracerouteRequest4.getTracerouteHops().add(tracerouteHop);
                    int j = 0;
                    for (String hopTime : matcher.group(3).split("  ")) {
                        try {
                            tracerouteHop.getTracrouteHopResponses().add(new TracrouteHopResponse(j, Double.valueOf(hopTime).doubleValue(), tracerouteHop));
                        }
                        catch (NumberFormatException e) {
                            tracerouteHop.getTracrouteHopResponses().add(new TracrouteHopResponse(j, -1.0, tracerouteHop));
                        }
                        ++j;
                    }
                }
                ++index;
            }
            defaultTracerouteService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultTracerouteService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"doAfter", (Object[])new Object[]{tracerouteRequest2}, (Throwable)((Object)defaultTracerouteService2));
        }
        if (defaultTracerouteService2 != null) {
            throw defaultTracerouteService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultTracerouteService", (String)"doAfter", (Object[])new Object[]{tracerouteRequest}, null, (long)l);
    }
}

