/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.shell.impl.service;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.shell.api.enumeration.BatteryState;
import io.github.qsy7.shell.api.model.BatteryRequest;
import io.github.qsy7.shell.api.model.BatteryStatus;
import io.github.qsy7.shell.api.model.CommandOutput;
import io.github.qsy7.shell.api.model.Node;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import io.github.qsy7.shell.api.service.UpowerService;
import io.github.qsy7.shell.impl.property.UpowerTimeout;
import io.github.qsy7.shell.impl.service.AbstractSingleShellCommandService;
import io.github.qsy7.shell.impl.service.ShellCommandBuilder;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultUpowerService
extends AbstractSingleShellCommandService<BatteryRequest>
implements UpowerService {
    protected final Node node;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultUpowerService(ShellCommandBuilder shellCommandBuilder, ShellExecutionService shellExecutionService, Node node, @Property(value=UpowerTimeout.class) int n) {
        void node2;
        void timeout;
        void shellExecutionService2;
        void shellCommandBuilder2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, node, n});
        DefaultUpowerService defaultUpowerService = this;
        ShellCommandBuilder shellCommandBuilder3 = shellCommandBuilder;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        Node node3 = node;
        int n2 = n;
        super((ShellCommandBuilder)shellCommandBuilder2, (ShellExecutionService)shellExecutionService2, (int)timeout);
        defaultUpowerService.node = node2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"<init>", (Object[])new Object[]{shellCommandBuilder, shellExecutionService, node, n}, null, (long)l);
    }

    protected String getCommandLine() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"getCommandLine", (Object[])new Object[0]);
        DefaultUpowerService defaultUpowerService = this;
        Object object = defaultUpowerService;
        try {
            object = "upower -i /org/freedesktop/UPower/devices/battery_BAT0";
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doAfter(BatteryRequest batteryRequest) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"doAfter", (Object[])new Object[]{batteryRequest});
        DefaultUpowerService defaultUpowerService = this;
        BatteryRequest batteryRequest2 = batteryRequest;
        DefaultUpowerService defaultUpowerService2 = defaultUpowerService;
        BatteryRequest batteryRequest3 = batteryRequest2;
        try {
            void batteryRequest4;
            Pattern statePattern = Pattern.compile(".*(fully-charged|charging|discharging).*");
            Pattern percentagePattern = Pattern.compile(".*percentage:[\\W]{1,}([\\d]{1,3})%.*");
            String state = null;
            int percentage = -1;
            for (String line : ((CommandOutput)batteryRequest4.getShellCommand().getOutputs().get(0)).getOutput().split("\n")) {
                if (state != null && percentage > 0) break;
                Matcher stateMatcher = statePattern.matcher(line);
                if (stateMatcher.matches()) {
                    state = stateMatcher.group(1);
                    continue;
                }
                Matcher percentageMatcher = percentagePattern.matcher(line);
                if (!percentageMatcher.matches()) continue;
                percentage = Integer.valueOf(percentageMatcher.group(1));
            }
            batteryRequest4.setBatteryStatus(new BatteryStatus(defaultUpowerService2.node, LocalDateTime.now(), BatteryState.getFromUpowerString(state), Integer.valueOf(percentage).intValue(), batteryRequest4.getShellCommand()));
            defaultUpowerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultUpowerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"doAfter", (Object[])new Object[]{batteryRequest2}, (Throwable)((Object)defaultUpowerService2));
        }
        if (defaultUpowerService2 != null) {
            throw defaultUpowerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.shell.impl.service.DefaultUpowerService", (String)"doAfter", (Object[])new Object[]{batteryRequest}, null, (long)l);
    }
}

